/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.widgets;

import org.eclipse.reddeer.core.handler.WidgetHandler;
import org.eclipse.reddeer.core.lookup.WidgetLookup;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.swt.api.Widget;
import org.eclipse.reddeer.swt.exception.SWTLayerException;
import org.hamcrest.Matcher;

public abstract class AbstractWidget<T extends org.eclipse.swt.widgets.Widget>
implements Widget<T> {
    protected T swtWidget;

    protected AbstractWidget(T swtWidget) {
        if (swtWidget == null) {
            throw new SWTLayerException("SWT widget provided is null");
        }
        if (swtWidget.isDisposed()) {
            throw new SWTLayerException("SWT widget provided is disposed");
        }
        this.swtWidget = swtWidget;
    }

    protected AbstractWidget(T swtWidget, Runnable diagnostics) {
        if (swtWidget == null) {
            if (diagnostics != null) {
                diagnostics.run();
            }
            throw new SWTLayerException("SWT widget provided is null");
        }
        if (swtWidget.isDisposed()) {
            throw new SWTLayerException("SWT widget provided is disposed");
        }
        this.swtWidget = swtWidget;
    }

    protected AbstractWidget(Class<T> widgetClass, ReferencedComposite refComposite, int index, Matcher<?> ... matchers) {
        if (refComposite != null && WidgetHandler.getInstance().isDisposed((org.eclipse.swt.widgets.Widget)refComposite.getControl())) {
            throw new SWTLayerException("Given referenced composite is disposed");
        }
        this.swtWidget = WidgetLookup.getInstance().activeWidget(refComposite, widgetClass, index, matchers);
    }

    @Override
    public T getSWTWidget() {
        return this.swtWidget;
    }

    @Override
    public boolean isDisposed() {
        return WidgetHandler.getInstance().isDisposed(this.swtWidget);
    }
}

