/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.description.DescriptionPackage;
import org.eclipse.sirius.diagram.description.tool.ToolPackage;
import org.eclipse.sirius.diagram.tools.api.management.ToolManagement;
import org.eclipse.sirius.tools.internal.validation.EValidatorAdapter;
import org.osgi.framework.BundleContext;

public class DiagramPlugin
extends EMFPlugin {
    public static final String ID = "org.eclipse.sirius.diagram";
    public static final DiagramPlugin INSTANCE = new DiagramPlugin();
    private static Implementation plugin;

    public DiagramPlugin() {
        super(new ResourceLocator[0]);
    }

    public ResourceLocator getPluginResourceLocator() {
        return plugin;
    }

    public static Implementation getPlugin() {
        return plugin;
    }

    public static Implementation getDefault() {
        return plugin;
    }

    public static class Implementation
    extends EMFPlugin.EclipsePlugin {
        Map<DDiagram, ToolManagement> toolManagementMap;

        public Implementation() {
            plugin = this;
        }

        public void logError(String error) {
            this.logError(error, null);
        }

        public void logError(String error, Throwable throwable) {
            this.logMessage(error, throwable, 4);
        }

        public void logInfo(String message) {
            this.logInfo(message, null);
        }

        public void logInfo(String message, Throwable throwable) {
            this.logMessage(message, throwable, 1);
        }

        public void logWarning(String message) {
            this.logWarning(message, null);
        }

        public void logWarning(String message, Throwable throwable) {
            this.logMessage(message, throwable, 2);
        }

        private void logMessage(String message, Throwable throwable, int code) {
            String msg = message;
            if (message == null && throwable != null) {
                msg = throwable.getMessage();
            }
            this.getLog().log((IStatus)new Status(code, DiagramPlugin.ID, 0, msg, throwable));
            this.debug(msg, throwable);
        }

        private void debug(String message, Throwable throwable) {
            if (!this.isDebugging()) {
                return;
            }
            if (message != null) {
                System.err.println(message);
            }
            if (throwable != null) {
                throwable.printStackTrace();
            }
        }

        public void start(BundleContext context) throws Exception {
            super.start(context);
            EValidator.Registry.INSTANCE.put((Object)DiagramPackage.eINSTANCE, (Object)new EValidatorAdapter());
            EValidator.Registry.INSTANCE.put((Object)DescriptionPackage.eINSTANCE, (Object)new EValidatorAdapter());
            EValidator.Registry.INSTANCE.put((Object)ToolPackage.eINSTANCE, (Object)new EValidatorAdapter());
            this.toolManagementMap = new HashMap<DDiagram, ToolManagement>();
        }

        public void stop(BundleContext context) throws Exception {
            this.toolManagementMap = null;
            try {
                InstanceScope.INSTANCE.getNode(DiagramPlugin.ID).flush();
            }
            finally {
                super.stop(context);
            }
        }

        public ToolManagement getToolManagement(Diagram diagram) {
            DDiagram dDiagram = this.getDDiagram(diagram);
            if (dDiagram != null) {
                ToolManagement toolManagement = this.toolManagementMap.get(dDiagram);
                if (toolManagement == null) {
                    toolManagement = new ToolManagement(dDiagram);
                    this.toolManagementMap.put(dDiagram, toolManagement);
                }
                return toolManagement;
            }
            return null;
        }

        private DDiagram getDDiagram(Diagram diagram) {
            if (diagram != null) {
                try {
                    EObject elt = diagram.getElement();
                    if (elt instanceof DDiagram) {
                        return (DDiagram)elt;
                    }
                }
                catch (IllegalStateException illegalStateException) {}
            }
            return null;
        }

        public ToolManagement getToolManagement(DDiagram dDiagram) {
            if (dDiagram != null) {
                ToolManagement toolManagement = this.toolManagementMap.get(dDiagram);
                if (toolManagement == null) {
                    toolManagement = new ToolManagement(dDiagram);
                    this.toolManagementMap.put(dDiagram, toolManagement);
                }
                return toolManagement;
            }
            return null;
        }

        public ToolManagement removeToolManagement(DDiagram diagram) {
            ToolManagement toolManagement = this.toolManagementMap.get(diagram);
            if (toolManagement != null) {
                this.toolManagementMap.remove(diagram);
            }
            return toolManagement;
        }

        public ToolManagement removeToolManagement(Diagram diagram) {
            if (diagram != null && diagram.getElement() instanceof DDiagram) {
                DDiagram dDiagram = (DDiagram)diagram.getElement();
                return this.removeToolManagement(dDiagram);
            }
            return null;
        }
    }
}

