/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.api.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.sirius.diagram.business.api.diagramtype.DiagramTypeDescriptorRegistry;
import org.eclipse.sirius.diagram.business.api.diagramtype.IDiagramTypeDescriptor;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.DiagramImportDescription;
import org.eclipse.sirius.diagram.tools.api.preferences.SiriusDiagramPreferencesKeys;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.viewpoint.description.Group;
import org.eclipse.sirius.viewpoint.description.tool.PasteDescription;

public class DiagramDescriptionQuery {
    protected DiagramDescription diagramDescription;

    public DiagramDescriptionQuery(DiagramDescription diagramDescription) {
        this.diagramDescription = diagramDescription;
    }

    public Iterator<? extends DiagramDescription> superTypes() {
        return new SuperTypesIterator(this.diagramDescription);
    }

    public Collection<PasteDescription> getAllPasteTools() {
        ArrayList<PasteDescription> descs = new ArrayList<PasteDescription>();
        for (DiagramDescription diagHier : new SuperTypes(this.diagramDescription)) {
            descs.addAll((Collection<PasteDescription>)diagHier.getPasteDescriptions());
        }
        descs.addAll((Collection<PasteDescription>)this.diagramDescription.getPasteDescriptions());
        return descs;
    }

    public Option<Group> getParentGroup() {
        DiagramDescription current = this.diagramDescription;
        while (current != null) {
            if (!((current = current.eContainer()) instanceof Group)) continue;
            return Options.newSome((Object)((Group)current));
        }
        return Options.newNone();
    }

    public boolean isHeaderSectionEnabled() {
        boolean isHeaderSectionEnabled = false;
        String headerPrefKey = SiriusDiagramPreferencesKeys.PREF_DISPLAY_HEADER_SECTION.name();
        boolean prefHeaderEnabled = Platform.getPreferencesService().getBoolean("org.eclipse.sirius.diagram", headerPrefKey, false, null);
        if (prefHeaderEnabled) {
            for (IDiagramTypeDescriptor diagramTypeDescriptor : DiagramTypeDescriptorRegistry.getInstance().getAllDiagramTypeDescriptors()) {
                if (!diagramTypeDescriptor.getDiagramDescriptionProvider().handles(this.diagramDescription.eClass().getEPackage())) continue;
                isHeaderSectionEnabled = diagramTypeDescriptor.getDiagramDescriptionProvider().supportHeader();
                break;
            }
        }
        return isHeaderSectionEnabled;
    }

    private static class SuperTypes
    implements Iterable<DiagramDescription> {
        private DiagramDescription desc;

        SuperTypes(DiagramDescription description) {
            this.desc = description;
        }

        @Override
        public Iterator<DiagramDescription> iterator() {
            return new SuperTypesIterator(this.desc);
        }
    }

    private static class SuperTypesIterator
    implements Iterator<DiagramDescription> {
        private DiagramDescription cur;

        SuperTypesIterator(DiagramDescription map) {
            this.cur = map;
        }

        @Override
        public boolean hasNext() {
            return this.doGetNext() != null;
        }

        @Override
        public DiagramDescription next() {
            this.cur = this.doGetNext();
            if (this.cur == null) {
                throw new NoSuchElementException();
            }
            return this.cur;
        }

        private DiagramDescription doGetNext() {
            DiagramDescription next = null;
            if (this.cur instanceof DiagramImportDescription) {
                next = ((DiagramImportDescription)this.cur).getImportedDiagram();
            }
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

