/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.dialect.description;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.dialect.description.IInterpretedExpressionTargetSwitch;
import org.eclipse.sirius.diagram.business.api.query.MappingBasedToolDescriptionQuery;
import org.eclipse.sirius.diagram.description.tool.BehaviorTool;
import org.eclipse.sirius.diagram.description.tool.DeleteHookParameter;
import org.eclipse.sirius.diagram.description.tool.EdgeCreationDescription;
import org.eclipse.sirius.diagram.description.tool.RequestDescription;
import org.eclipse.sirius.diagram.description.tool.ToolPackage;
import org.eclipse.sirius.diagram.description.tool.util.ToolSwitch;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.RepresentationElementMapping;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;
import org.eclipse.sirius.viewpoint.description.tool.ChangeContext;
import org.eclipse.sirius.viewpoint.description.tool.CreateInstance;
import org.eclipse.sirius.viewpoint.description.tool.MappingBasedToolDescription;

public class DiagramToolInterpretedExpressionTargetSwitch
extends ToolSwitch<Option<Collection<String>>> {
    private static final int DO_NOT_CONSIDER_FEATURE = -1;
    protected EStructuralFeature feature;
    protected boolean considerFeature;
    private IInterpretedExpressionTargetSwitch globalSwitch;

    public DiagramToolInterpretedExpressionTargetSwitch(EStructuralFeature feature, IInterpretedExpressionTargetSwitch defaultInterpretedExpressionTargetSwitch) {
        this.feature = feature;
        this.globalSwitch = defaultInterpretedExpressionTargetSwitch;
    }

    @Override
    public Option<Collection<String>> doSwitch(EObject theEObject) {
        Option doSwitch = (Option)super.doSwitch(theEObject);
        if (doSwitch != null) {
            return doSwitch;
        }
        Set targets = Collections.emptySet();
        return Options.newSome(targets);
    }

    public void setConsiderFeature(boolean considerFeature) {
        this.considerFeature = considerFeature;
    }

    private int getFeatureId(EClass eClass) {
        int featureID = -1;
        if (this.considerFeature && this.feature != null) {
            featureID = eClass.getFeatureID(this.feature);
        }
        return featureID;
    }

    protected EObject getFirstContextChangingContainer(EObject element) {
        EObject container = element.eContainer();
        while (!this.isChangingContextElement(container)) {
            container = container.eContainer();
        }
        return container;
    }

    private boolean isChangingContextElement(EObject element) {
        boolean descCanChange = element instanceof RepresentationDescription || element instanceof RepresentationElementMapping;
        boolean operationCanChange = element instanceof CreateInstance || element instanceof ChangeContext;
        boolean toolCanChange = element instanceof AbstractToolDescription;
        return descCanChange || operationCanChange || toolCanChange;
    }

    @Override
    public Option<Collection<String>> caseRequestDescription(RequestDescription object) {
        Option result = null;
        switch (this.getFeatureId(ToolPackage.eINSTANCE.getRequestDescription())) {
            case -1: 
            case 3: 
            case 6: {
                result = Options.newNone();
                break;
            }
        }
        return result;
    }

    @Override
    public Option<Collection<String>> caseBehaviorTool(BehaviorTool object) {
        Option result = null;
        switch (this.getFeatureId(ToolPackage.eINSTANCE.getBehaviorTool())) {
            case -1: 
            case 3: 
            case 6: {
                result = Options.newNone();
                break;
            }
        }
        return result;
    }

    @Override
    public Option<Collection<String>> caseEdgeCreationDescription(EdgeCreationDescription object) {
        Option result = null;
        switch (this.getFeatureId(ToolPackage.eINSTANCE.getEdgeCreationDescription())) {
            case -1: 
            case 17: {
                LinkedHashSet targets = new LinkedHashSet();
                for (RepresentationElementMapping correspondingMapping : Iterables.concat(object.getEdgeMappings(), object.getExtraSourceMappings())) {
                    Option targetsFromMapping = this.globalSwitch.doSwitch((EObject)correspondingMapping, false);
                    if (!targetsFromMapping.some()) continue;
                    targets.addAll((Collection)targetsFromMapping.get());
                }
                result = Options.newSome(targets);
                break;
            }
        }
        return result;
    }

    @Override
    public Option<Collection<String>> caseDeleteHookParameter(DeleteHookParameter object) {
        return this.globalSwitch.doSwitch(this.getFirstContextChangingContainer(object), false);
    }

    @Override
    public Option<Collection<String>> caseMappingBasedToolDescription(MappingBasedToolDescription tool) {
        Option result = null;
        switch (this.getFeatureId(org.eclipse.sirius.viewpoint.description.tool.ToolPackage.eINSTANCE.getMappingBasedToolDescription())) {
            case -1: 
            case 3: 
            case 6: {
                LinkedHashSet targets = new LinkedHashSet();
                for (RepresentationElementMapping correspondingMapping : new MappingBasedToolDescriptionQuery(tool).getMappings()) {
                    Option targetsFromMapping = this.globalSwitch.doSwitch((EObject)correspondingMapping, false);
                    if (!targetsFromMapping.some()) continue;
                    targets.addAll((Collection)targetsFromMapping.get());
                }
                result = Options.newSome(targets);
                break;
            }
        }
        return result;
    }
}

