/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ext.emf;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

public final class AllContents
implements Iterable<EObject> {
    private final EObject root;
    private final EClass klass;
    private final boolean includeRoot;

    private AllContents(EObject root, EClass klass, boolean includeRoot) {
        this.root = root;
        this.klass = klass;
        this.includeRoot = includeRoot;
    }

    public static Iterable<EObject> of(EObject obj) {
        return AllContents.of(obj, false);
    }

    public static Iterable<EObject> of(EObject obj, boolean includeRoot) {
        return new AllContents(obj, null, includeRoot);
    }

    public static Iterable<EObject> of(EObject obj, EClass klass) {
        return AllContents.of(obj, klass, false);
    }

    public static Iterable<EObject> of(EObject obj, EClass klass, boolean includeRoot) {
        return new AllContents(obj, klass, includeRoot);
    }

    @Override
    public Iterator<EObject> iterator() {
        Object contentsIterator = this.root == null ? Collections.emptyIterator() : (this.klass == null ? this.root.eAllContents() : Iterators.filter((Iterator)this.root.eAllContents(), (Predicate)new Predicate<EObject>(){

            public boolean apply(EObject input) {
                return AllContents.this.klass.isInstance((Object)input);
            }
        }));
        if (this.includeRoot) {
            return Iterators.concat((Iterator)Iterators.singletonIterator((Object)this.root), (Iterator)contentsIterator);
        }
        return contentsIterator;
    }
}

