/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.ui.tools.internal.editor.provider;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.sirius.table.ui.tools.internal.editor.AbstractDTableEditor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.ui.actions.ActionFactory;

public class DTableCellEditorFocusListener
implements FocusListener {
    AbstractDTableEditor tableEditor;
    TextCellEditor textCellEditor;
    IAction emfCutAction;
    IAction emfCopyAction;
    IAction emfPasteAction;
    IAction standardCut;
    IAction standardCopy;
    IAction standardPaste;

    public DTableCellEditorFocusListener(AbstractDTableEditor tableEditor, TextCellEditor textCellEditor) {
        this.tableEditor = tableEditor;
        this.textCellEditor = textCellEditor;
        this.emfCutAction = tableEditor.getActionBars().getGlobalActionHandler(ActionFactory.CUT.getId());
        this.emfCopyAction = tableEditor.getActionBars().getGlobalActionHandler(ActionFactory.COPY.getId());
        this.emfPasteAction = tableEditor.getActionBars().getGlobalActionHandler(ActionFactory.PASTE.getId());
        this.standardCut = new StandardCutAction(textCellEditor);
        this.standardCopy = new StandardCopyAction(textCellEditor);
        this.standardPaste = new StandardPasteAction(textCellEditor);
    }

    public void focusLost(FocusEvent e) {
        this.tableEditor.getActionBars().setGlobalActionHandler(ActionFactory.CUT.getId(), this.emfCutAction);
        this.tableEditor.getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId(), this.emfCopyAction);
        this.tableEditor.getActionBars().setGlobalActionHandler(ActionFactory.PASTE.getId(), this.emfPasteAction);
        this.tableEditor.getActionBars().updateActionBars();
    }

    public void focusGained(FocusEvent e) {
        this.tableEditor.getActionBars().setGlobalActionHandler(ActionFactory.CUT.getId(), this.standardCut);
        this.tableEditor.getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId(), this.standardCopy);
        this.tableEditor.getActionBars().setGlobalActionHandler(ActionFactory.PASTE.getId(), this.standardPaste);
        this.tableEditor.getActionBars().updateActionBars();
    }

    private static class StandardCopyAction
    extends Action {
        TextCellEditor textCellEditor;

        StandardCopyAction(TextCellEditor textCellEditor) {
            this.textCellEditor = textCellEditor;
        }

        public void run() {
            this.textCellEditor.performCopy();
        }
    }

    private static class StandardCutAction
    extends Action {
        TextCellEditor textCellEditor;

        StandardCutAction(TextCellEditor textCellEditor) {
            this.textCellEditor = textCellEditor;
        }

        public void run() {
            this.textCellEditor.performCut();
        }
    }

    private static class StandardPasteAction
    extends Action {
        TextCellEditor textCellEditor;

        StandardPasteAction(TextCellEditor textCellEditor) {
            this.textCellEditor = textCellEditor;
        }

        public void run() {
            this.textCellEditor.performPaste();
        }
    }
}

