/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.ui.tools.internal.paperclips;

import org.eclipse.sirius.table.ui.tools.internal.paperclips.PaperClips;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.Print;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.PrintIterator;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.ScaleIterator;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.internal.util.Util;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;

public class ScalePrint
implements Print {
    final Print target;
    final Double scale;

    public ScalePrint(Print target) {
        this(target, null);
    }

    public ScalePrint(Print target, Double scale) {
        Util.notNull(target);
        if (scale != null && !(scale > 0.0)) {
            PaperClips.error(5, "Scale " + scale + " must be > 0");
        }
        this.target = target;
        this.scale = scale;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.scale == null ? 0 : this.scale.hashCode());
        result = 31 * result + (this.target == null ? 0 : this.target.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ScalePrint other = (ScalePrint)obj;
        if (this.scale == null ? other.scale != null : !this.scale.equals(other.scale)) {
            return false;
        }
        return !(this.target == null ? other.target != null : !this.target.equals(other.target));
    }

    public Print getTarget() {
        return this.target;
    }

    public Double getScale() {
        return this.scale;
    }

    @Override
    public PrintIterator iterator(Device device, GC gc) {
        return new ScaleIterator(this, device, gc);
    }
}

