/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtbot.generator.client.views;

import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.VerticalRuler;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swtbot.generator.client.Recorder;
import org.eclipse.swtbot.generator.client.RecorderClientStatusListener;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.AbstractTextEditor;

public class RecorderClientView
extends ViewPart
implements RecorderClientStatusListener,
IElementChangedListener {
    public static final String ID = "org.eclipse.swtbot.generator.client.view.recorder.client";
    private static int DEFAULT_PORT_NUMBER = 8000;
    private static String IS_CONNECTED_LABEL = "Connected";
    private static String TRYING_CONNECT_LABEL = "Connecting...";
    private static String NOT_CONNECTED_LABEL = "No connection";
    private static String CONNECT_LABEL = "   Connect   ";
    private static String CANCEL_CONNECT_LABEL = "Cancel";
    private static String DISCONNECT_LABEL = "Disconnect";
    private static String ADD_TO_METHOD_TOGGLE_LABEL = "Add to method: ";
    private static String START_RECORDING_LABEL = "Record";
    private static String STOP_RECORDING_LABEL = "Stop recording";
    private Button connectButton;
    private Text portText;
    private Label statusLabel;
    private ComboViewer availableMethodsDropDown;
    private Button addToMethodToggle;
    private Button refreshAvailableMethodsButton;
    private Button recordingButton;
    private SourceViewer viewer;

    public RecorderClientView() {
        if (!Recorder.INSTANCE.isInitialized()) {
            Recorder.INSTANCE.initialize();
        } else {
            Recorder.INSTANCE.reset();
        }
        Recorder.INSTANCE.addStatusListener(this);
    }

    public void dispose() {
        Recorder.INSTANCE.removeStatusListener(this);
        super.dispose();
    }

    public void updateUI() {
        this.updateUIForConnectionState(Recorder.INSTANCE.getConnectionState());
        this.portText.setText(String.valueOf(Recorder.INSTANCE.getPort()));
    }

    public void createPartControl(Composite parent) {
        Group group = new Group(parent, 0);
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setLayout((Layout)new GridLayout(1, false));
        Composite launchContainer = new Composite((Composite)group, 0);
        launchContainer.setLayoutData((Object)new GridData(4, 4, true, false));
        launchContainer.setLayout((Layout)new GridLayout(2, false));
        this.connectButton = new Button(launchContainer, 8);
        this.connectButton.setText(CONNECT_LABEL);
        this.connectButton.setLayoutData((Object)new GridData(4, 4, false, false));
        this.connectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (Recorder.INSTANCE.getConnectionState() == Recorder.ConnectionState.CONNECTED) {
                    Recorder.INSTANCE.interruptRecorderClient();
                } else if (Recorder.INSTANCE.getConnectionState() == Recorder.ConnectionState.CONNECTING) {
                    Recorder.INSTANCE.interruptRecorderClient();
                } else {
                    Recorder.INSTANCE.startRecorderClient(RecorderClientView.this.getPort());
                }
                RecorderClientView.this.updateUIForConnectionState(Recorder.INSTANCE.getConnectionState());
            }
        });
        Composite portLaunchContainer = new Composite(launchContainer, 0);
        portLaunchContainer.setLayoutData((Object)new GridData(4, 4, true, false));
        portLaunchContainer.setLayout((Layout)new GridLayout(2, false));
        Label portLabel = new Label(portLaunchContainer, 0);
        portLabel.setLayoutData((Object)new GridData(4, 4, false, false));
        portLabel.setText("port:");
        this.portText = new Text(portLaunchContainer, 131072);
        this.portText.setText(String.valueOf(DEFAULT_PORT_NUMBER));
        this.portText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.portText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                block2: {
                    String port = String.valueOf(RecorderClientView.this.portText.getText()) + e.text;
                    try {
                        Integer.parseInt(port);
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (port.length() <= 0) break block2;
                        e.doit = false;
                    }
                }
            }
        });
        this.statusLabel = new Label((Composite)group, 4);
        this.statusLabel.setText("No connection");
        Label horizontalSeparator = new Label((Composite)group, 258);
        horizontalSeparator.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite methodSelectionContainer = new Composite((Composite)group, 0);
        methodSelectionContainer.setLayoutData((Object)new GridData(4, 4, true, false));
        methodSelectionContainer.setLayout((Layout)new GridLayout(3, false));
        this.addToMethodToggle = new Button(methodSelectionContainer, 32);
        this.addToMethodToggle.setLayoutData((Object)new GridData(4, 4, false, false));
        this.addToMethodToggle.setText(ADD_TO_METHOD_TOGGLE_LABEL);
        this.addToMethodToggle.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (Recorder.INSTANCE.isInsertingDirectlyInEditor()) {
                    Recorder.INSTANCE.setInsertingDirectlyInEditor(false);
                    RecorderClientView.this.availableMethodsDropDown.getControl().setEnabled(false);
                    RecorderClientView.this.refreshAvailableMethodsButton.setEnabled(false);
                } else {
                    Recorder.INSTANCE.setInsertingDirectlyInEditor(true);
                    RecorderClientView.this.availableMethodsDropDown.getControl().setEnabled(true);
                    RecorderClientView.this.refreshAvailableMethodsButton.setEnabled(true);
                    if (RecorderClientView.this.availableMethodsDropDown.getInput() == null || ((IMethod[])RecorderClientView.this.availableMethodsDropDown.getInput()).length == 0) {
                        RecorderClientView.this.updateMethodSelectionDropDown();
                    }
                }
            }
        });
        this.addToMethodToggle.setEnabled(false);
        this.availableMethodsDropDown = new ComboViewer(methodSelectionContainer);
        this.availableMethodsDropDown.getControl().setLayoutData((Object)new GridData(4, 4, true, false));
        this.availableMethodsDropDown.getControl().setEnabled(false);
        this.availableMethodsDropDown.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.availableMethodsDropDown.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                IMethod method = (IMethod)element;
                String parameterNamesString = "";
                try {
                    String[] parameterNames = method.getParameterNames();
                    int i = 0;
                    while (i < parameterNames.length) {
                        parameterNamesString = i == 0 ? String.valueOf(parameterNamesString) + parameterNames[i] : String.valueOf(parameterNamesString) + ", " + parameterNames[i];
                        ++i;
                    }
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                }
                return String.valueOf(method.getElementName()) + "(" + parameterNamesString + ")";
            }
        });
        this.availableMethodsDropDown.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Recorder.INSTANCE.setSelectedMethod((IMethod)selection.getFirstElement());
            }
        });
        this.refreshAvailableMethodsButton = new Button(methodSelectionContainer, 8);
        this.refreshAvailableMethodsButton.setLayoutData((Object)new GridData(4, 4, false, false));
        this.refreshAvailableMethodsButton.setEnabled(false);
        this.refreshAvailableMethodsButton.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.swtbot.generator.client", (String)"icons/refresh.gif").createImage());
        this.refreshAvailableMethodsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RecorderClientView.this.updateMethodSelectionDropDown();
            }
        });
        this.recordingButton = new Button((Composite)group, 8);
        this.recordingButton.setLayoutData((Object)new GridData(4, 4, true, false));
        this.recordingButton.setText(START_RECORDING_LABEL);
        this.recordingButton.setEnabled(false);
        this.recordingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (Recorder.INSTANCE.isRecording()) {
                    RecorderClientView.this.recordingButton.setText(START_RECORDING_LABEL);
                    Recorder.INSTANCE.setRecording(false);
                } else {
                    RecorderClientView.this.recordingButton.setText(STOP_RECORDING_LABEL);
                    Recorder.INSTANCE.setRecording(true);
                }
            }
        });
        this.viewer = new SourceViewer((Composite)group, (IVerticalRuler)new VerticalRuler(0), 2818);
        this.viewer.setDocument(Recorder.INSTANCE.getDocument());
        this.viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        JavaCore.addElementChangedListener((IElementChangedListener)this);
        this.updateUIForConnectionState(Recorder.INSTANCE.getConnectionState());
        this.updateMethodSelectionDropDown();
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private int getPort() {
        return Integer.parseInt(this.portText.getText());
    }

    @Override
    public void connectionStarted() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                RecorderClientView.this.updateMethodSelectionDropDown();
                RecorderClientView.this.updateUIForConnectionState(Recorder.ConnectionState.CONNECTED);
            }
        });
    }

    @Override
    public void connectionEnded() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                RecorderClientView.this.updateUIForConnectionState(Recorder.ConnectionState.DISCONNECTED);
            }
        });
    }

    private void updateUIForConnectionState(Recorder.ConnectionState state) {
        switch (state) {
            case CONNECTED: {
                this.statusLabel.setText(IS_CONNECTED_LABEL);
                this.recordingButton.setText(START_RECORDING_LABEL);
                this.connectButton.setText(DISCONNECT_LABEL);
                this.addToMethodToggle.setSelection(false);
                this.recordingButton.setEnabled(true);
                this.connectButton.setEnabled(true);
                this.portText.setEnabled(false);
                this.addToMethodToggle.setEnabled(true);
                this.availableMethodsDropDown.getControl().setEnabled(false);
                this.refreshAvailableMethodsButton.setEnabled(false);
                break;
            }
            case CONNECTING: {
                this.statusLabel.setText(TRYING_CONNECT_LABEL);
                this.recordingButton.setText(START_RECORDING_LABEL);
                this.connectButton.setText(CANCEL_CONNECT_LABEL);
                this.addToMethodToggle.setSelection(false);
                this.recordingButton.setEnabled(false);
                this.connectButton.setEnabled(true);
                this.portText.setEnabled(false);
                this.addToMethodToggle.setEnabled(false);
                this.availableMethodsDropDown.getControl().setEnabled(false);
                this.refreshAvailableMethodsButton.setEnabled(false);
                break;
            }
            case DISCONNECTED: {
                this.statusLabel.setText(NOT_CONNECTED_LABEL);
                this.recordingButton.setText(START_RECORDING_LABEL);
                this.connectButton.setText(CONNECT_LABEL);
                this.addToMethodToggle.setSelection(false);
                this.recordingButton.setEnabled(false);
                this.connectButton.setEnabled(true);
                this.portText.setEnabled(true);
                this.addToMethodToggle.setEnabled(false);
                this.availableMethodsDropDown.getControl().setEnabled(false);
                this.refreshAvailableMethodsButton.setEnabled(false);
            }
        }
    }

    public void elementChanged(ElementChangedEvent event) {
        if (Recorder.INSTANCE.shouldUpdateMethodSelectionViewer(event)) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    RecorderClientView.this.updateMethodSelectionDropDown();
                }
            });
        }
    }

    private IEditorPart getActiveEditor() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return null;
        }
        IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
        if (workbenchWindow == null) {
            return null;
        }
        IWorkbenchPage workbenchPage = workbenchWindow.getActivePage();
        if (workbenchPage == null) {
            return null;
        }
        return workbenchPage.getActiveEditor();
    }

    private void updateMethodSelectionDropDown() {
        IEditorPart activeEditor = this.getActiveEditor();
        if (activeEditor == null) {
            Recorder.INSTANCE.setSelectedMethod(null);
            Recorder.INSTANCE.setSelectedMethodDocument(null);
            this.availableMethodsDropDown.setInput(null);
        } else if (activeEditor instanceof JavaEditor) {
            ITypeRoot root = EditorUtility.getEditorInputJavaElement((IEditorPart)activeEditor, (boolean)false);
            IType type = root.findPrimaryType();
            try {
                IMethod[] methods = type.getMethods();
                IMethod methodToSelect = null;
                if (Recorder.INSTANCE.getSelectedMethod() != null) {
                    methodToSelect = this.findSimilarMethod(Recorder.INSTANCE.getSelectedMethod(), methods);
                }
                IDocument currentActiveDocument = ((AbstractTextEditor)activeEditor).getDocumentProvider().getDocument((Object)activeEditor.getEditorInput());
                Recorder.INSTANCE.setSelectedMethod(methodToSelect);
                Recorder.INSTANCE.setSelectedMethodDocument(currentActiveDocument);
                this.availableMethodsDropDown.setInput((Object)methods);
                if (methodToSelect != null) {
                    StructuredSelection selection = new StructuredSelection((Object)methodToSelect);
                    this.availableMethodsDropDown.setSelection((ISelection)selection);
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
    }

    private IMethod findSimilarMethod(IMethod method, IMethod[] methods) {
        IMethod similarMethod = null;
        IMethod[] iMethodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod candidate = iMethodArray[n2];
            if (method.isSimilar(candidate)) {
                similarMethod = candidate;
                break;
            }
            ++n2;
        }
        return similarMethod;
    }
}

