/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.launch;

import java.io.File;
import java.net.InetAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupParticipant;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage;
import org.eclipse.tcf.internal.debug.launch.TCFLaunchDelegate;
import org.eclipse.tcf.internal.debug.model.TCFSourceRef;
import org.eclipse.tcf.services.ILineNumbers;
import org.eclipse.tcf.services.IPathMap;

public class TCFSourceLookupParticipant
extends AbstractSourceLookupParticipant {
    private final LinkedHashMap<String, Object[]> cache = new LinkedHashMap<String, Object[]>(511, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 1023;
        }
    };

    public void sourceContainersChanged(ISourceLookupDirector director) {
        this.cache.clear();
    }

    public String getSourceName(Object object) throws CoreException {
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof ILineNumbers.CodeArea) {
            ILineNumbers.CodeArea area = (ILineNumbers.CodeArea)object;
            return TCFSourceLookupParticipant.toFileName(area);
        }
        if (object instanceof TCFSourceRef) {
            TCFSourceRef ref = (TCFSourceRef)object;
            if (ref.area == null) {
                return null;
            }
            return TCFSourceLookupParticipant.toFileName(ref.area);
        }
        return null;
    }

    public static String toFileName(ILineNumbers.CodeArea area) {
        if (area.directory != null && area.file != null && !TCFSourceLookupParticipant.isAbsolutePath(area.file)) {
            return String.valueOf(area.directory) + "/" + area.file;
        }
        return area.file;
    }

    public static String toFileName(IPathMap.PathMapRule r, String fnm) {
        String dst;
        String src;
        block10: {
            block9: {
                block8: {
                    block7: {
                        try {
                            src = r.getSource();
                            if (src != null) break block7;
                            return null;
                        }
                        catch (Exception exception) {
                            return null;
                        }
                    }
                    if (fnm.startsWith(src)) break block8;
                    return null;
                }
                String host = r.getHost();
                if (host == null || host.length() <= 0 || InetAddress.getLocalHost().equals(InetAddress.getByName(host))) break block9;
                return null;
            }
            dst = r.getDestination();
            if (dst != null && dst.length() != 0) break block10;
            return null;
        }
        int l = src.length();
        if (dst.endsWith("/") && l < fnm.length() && fnm.charAt(l) == '/') {
            ++l;
        }
        return String.valueOf(dst) + fnm.substring(l);
    }

    private static boolean isAbsolutePath(String fnm) {
        if (fnm.length() == 0) {
            return false;
        }
        char ch = fnm.charAt(0);
        if (ch == '/' || ch == '\\') {
            return true;
        }
        return fnm.length() >= 3 && fnm.charAt(1) == ':' && ((ch = fnm.charAt(2)) == '/' || ch == '\\');
    }

    private String applyPathMap(String fnm) {
        ILaunchConfiguration cfg = this.getDirector().getLaunchConfiguration();
        if (cfg == null) {
            return fnm;
        }
        try {
            String path_map = cfg.getAttribute("org.eclipse.tcf.debug.PathMap", "");
            if (path_map.length() == 0) {
                return fnm;
            }
            ArrayList<TCFLaunchDelegate.PathMapRule> map = TCFLaunchDelegate.parsePathMapAttribute(path_map);
            for (TCFLaunchDelegate.PathMapRule r : map) {
                String res;
                String query = r.getContextQuery();
                if (query != null && query.length() > 0 && !query.equals("*") || (res = TCFSourceLookupParticipant.toFileName((IPathMap.PathMapRule)r, fnm)) == null) continue;
                return res;
            }
            if (fnm.startsWith("/cygdrive/")) {
                fnm = String.valueOf(fnm.substring(10, 11)) + ":" + fnm.substring(11);
            }
            return fnm;
        }
        catch (Exception exception) {
            return fnm;
        }
    }

    private Object[] findSource(String name) throws CoreException {
        File file = new File(this.applyPathMap(name));
        Object[] res = file.isAbsolute() && file.exists() && file.isFile() ? new Object[]{new LocalFileStorage(file)} : super.findSourceElements((Object)name);
        ArrayList<Object> list = new ArrayList<Object>();
        Object[] objectArray = res;
        int n = res.length;
        int n2 = 0;
        while (n2 < n) {
            block7: {
                Object o;
                block6: {
                    IPath path;
                    o = objectArray[n2];
                    if (!(o instanceof IStorage) || o instanceof IFile || (path = ((IStorage)o).getFullPath()) == null) break block6;
                    URI uri = URIUtil.toURI((IPath)path);
                    IFile[] arr = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(uri);
                    if (arr == null || arr.length <= 0) break block6;
                    int cnt = list.size();
                    IFile[] iFileArray = arr;
                    int n3 = arr.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IFile resource = iFileArray[n4];
                        if (resource.isAccessible()) {
                            list.add(resource);
                        }
                        ++n4;
                    }
                    if (list.size() > cnt) break block7;
                }
                list.add(o);
            }
            ++n2;
        }
        return list.toArray(new Object[list.size()]);
    }

    public Object[] findSourceElements(Object object) throws CoreException {
        String name = this.getSourceName(object);
        if (name == null) {
            return null;
        }
        Object[] res = this.cache.get(name);
        if (res != null) {
            return res;
        }
        res = this.findSource(name);
        this.cache.put(name, res);
        return res;
    }
}

