/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.core.internal.operations;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.services.IFileSystem;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.tcf.core.concurrent.TCFOperationMonitor;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.IConfirmCallback;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.IOperation;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.runtime.IFSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.FSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.core.nls.Messages;

public abstract class AbstractOperation
implements IOperation {
    protected static final FSTreeNode[] NO_CHILDREN = new FSTreeNode[0];
    private static final DecimalFormat SIZE_FORMAT = new DecimalFormat("#,##0.##");
    protected static final int DEFAULT_CHUNK_SIZE = 5120;
    private int fStandardAnswer = -1;

    protected abstract IStatus doRun(IProgressMonitor var1);

    @Override
    public final IStatus run(IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            IStatus iStatus = this.doRun(monitor);
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public final void runInJob(ICallback callback) {
        this.runInJob(false, callback);
    }

    @Override
    public final void runInUserJob(ICallback callback) {
        this.runInJob(true, callback);
    }

    private final void runInJob(boolean user, final ICallback callback) {
        Job job = new Job(this.getName()){

            protected IStatus run(IProgressMonitor monitor) {
                return AbstractOperation.this.run(monitor);
            }
        };
        if (callback != null) {
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    callback.done((Object)AbstractOperation.this, event.getResult());
                }
            });
        }
        job.setUser(user);
        job.schedule();
    }

    protected String getPath(FSTreeNode node, String childName) {
        String path = node.getLocation(true);
        if (path.charAt(path.length() - 1) == '/') {
            return String.valueOf(path) + childName;
        }
        return String.valueOf(path) + '/' + childName;
    }

    protected List<FSTreeNode> dropNestedNodes(List<? extends IFSTreeNode> nodes) {
        ArrayList<FSTreeNode> result = new ArrayList<FSTreeNode>();
        for (IFSTreeNode iFSTreeNode : nodes) {
            this.addWithoutNested(result, iFSTreeNode);
        }
        return result;
    }

    private void addWithoutNested(List<FSTreeNode> result, IFSTreeNode newNode) {
        if (!(newNode instanceof FSTreeNode)) {
            return;
        }
        ListIterator<FSTreeNode> it = result.listIterator();
        while (it.hasNext()) {
            FSTreeNode node = it.next();
            if (node == newNode || node.isAncestorOf(newNode)) {
                return;
            }
            if (!newNode.isAncestorOf(node)) continue;
            it.set((FSTreeNode)newNode);
            return;
        }
        result.add((FSTreeNode)newNode);
    }

    protected IStatus refresh(FSTreeNode node, long olderThan, IProgressMonitor monitor) {
        if (node.getLastRefresh() < olderThan) {
            return node.operationRefresh(false).run((IProgressMonitor)new SubProgressMonitor(monitor, 0));
        }
        return Status.OK_STATUS;
    }

    protected int confirmCallback(Object node, IConfirmCallback confirmCallback) {
        if (confirmCallback == null) {
            return 0;
        }
        if (this.fStandardAnswer >= 0) {
            return this.fStandardAnswer;
        }
        int answer = confirmCallback.confirms(node);
        switch (answer) {
            case 0: 
            case 2: 
            case 3: {
                return answer;
            }
            case 4: {
                this.fStandardAnswer = 2;
                return this.fStandardAnswer;
            }
            case 1: {
                this.fStandardAnswer = 0;
                return this.fStandardAnswer;
            }
        }
        return 3;
    }

    protected String formatSize(long size) {
        double kbSize = (double)size / 1024.0;
        if (kbSize < 1.0) {
            return String.valueOf(SIZE_FORMAT.format(size)) + Messages.OpStreamOp_Bytes;
        }
        double mbSize = kbSize / 1024.0;
        if (mbSize < 1.0) {
            return String.valueOf(SIZE_FORMAT.format(kbSize)) + Messages.OpStreamOp_KBs;
        }
        return String.valueOf(SIZE_FORMAT.format(mbSize)) + Messages.OpStreamOp_MBs;
    }

    protected void handleFSError(FSTreeNode node, String msg, IFileSystem.FileSystemException error, TCFOperationMonitor<?> result) {
        int status = error.getStatus();
        if (status == 65538) {
            node.getParent().removeNode(node, true);
            result.setDone(null);
        } else {
            node.setContent(NO_CHILDREN, false);
            result.setError(msg, (Throwable)error);
        }
    }

    protected void tcfReadDir(final IFileSystem fs, String path, final IReadDirDone callback) {
        fs.opendir(path, new IFileSystem.DoneOpen(){
            private IFileSystem.IFileHandle fHandle;
            protected List<IFileSystem.DirEntry> fEntries;

            public void doneOpen(IToken token, IFileSystem.FileSystemException error, IFileSystem.IFileHandle handle) {
                if (error != null) {
                    callback.error(error);
                } else {
                    this.fHandle = handle;
                    if (callback.checkCancelled()) {
                        this.cleanup();
                    } else {
                        this.fEntries = new ArrayList<IFileSystem.DirEntry>();
                        this.readDir();
                    }
                }
            }

            protected void readDir() {
                fs.readdir(this.fHandle, new IFileSystem.DoneReadDir(){

                    public void doneReadDir(IToken token, IFileSystem.FileSystemException error, IFileSystem.DirEntry[] entries, boolean eof) {
                        if (error != null) {
                            this.cleanup();
                            callback.error(error);
                        } else if (callback.checkCancelled()) {
                            this.cleanup();
                        } else {
                            fEntries.addAll(Arrays.asList(entries));
                            if (eof) {
                                this.cleanup();
                                callback.done(fEntries);
                            } else {
                                this.readDir();
                            }
                        }
                    }
                });
            }

            protected void cleanup() {
                if (this.fHandle != null) {
                    fs.close(this.fHandle, new IFileSystem.DoneClose(){

                        public void doneClose(IToken token, IFileSystem.FileSystemException error) {
                        }
                    });
                }
            }
        });
    }

    public static interface IReadDirDone {
        public void error(IFileSystem.FileSystemException var1);

        public boolean checkCancelled();

        public void done(List<IFileSystem.DirEntry> var1);
    }
}

