/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.ui.internal.compare;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.ISharedDocumentAdapter;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.runtime.IFSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.ui.activator.UIPlugin;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.compare.EditableSharedDocumentAdapter;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.compare.MergeTypedElement;
import org.eclipse.tcf.te.tcf.filesystem.ui.nls.Messages;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.ide.FileStoreEditorInput;

public class LocalTypedElement
extends MergeTypedElement
implements IEditableContent,
IAdaptable,
EditableSharedDocumentAdapter.ISharedDocumentAdapterListener {
    private boolean dirty;
    private EditableSharedDocumentAdapter documentAdapter;
    private EditableSharedDocumentAdapter.ISharedDocumentAdapterListener documentListener;

    public LocalTypedElement(IFSTreeNode node) {
        super(node);
        this.setContent(this.getContent());
        this.dirty = false;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == ISharedDocumentAdapter.class) {
            if (this.documentAdapter == null) {
                this.documentAdapter = new EditableSharedDocumentAdapter(this);
            }
            return this.documentAdapter;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public void setContent(byte[] contents) {
        this.dirty = true;
        super.setContent(contents);
    }

    public void setDocumentListener(EditableSharedDocumentAdapter.ISharedDocumentAdapterListener documentListener) {
        this.documentListener = documentListener;
    }

    protected InputStream createStream() throws CoreException {
        try {
            File cacheFile = this.node.getCacheFile();
            return new BufferedInputStream(new FileInputStream(cacheFile));
        }
        catch (FileNotFoundException e) {
            Status error = new Status(4, UIPlugin.getUniqueIdentifier(), e.getMessage(), (Throwable)e);
            throw new CoreException((IStatus)error);
        }
    }

    public boolean isEditable() {
        return true;
    }

    public ITypedElement replace(ITypedElement dest, ITypedElement src) {
        return dest;
    }

    public boolean store2Document(IProgressMonitor monitor) throws CoreException {
        if (this.isConnected()) {
            IEditorInput input = this.documentAdapter.getDocumentKey(this);
            this.documentAdapter.saveDocument(input, monitor);
            return true;
        }
        return false;
    }

    public boolean isDirty() {
        return this.dirty || this.documentAdapter != null && this.documentAdapter.hasBufferedContents();
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean isConnected() {
        return this.documentAdapter != null && this.documentAdapter.isConnected();
    }

    public String toString() {
        File cacheFile = this.node.getCacheFile();
        return cacheFile.toString();
    }

    @Override
    public void handleDocumentConnected() {
        if (this.documentListener != null) {
            this.documentListener.handleDocumentConnected();
        }
    }

    @Override
    public void handleDocumentDeleted() {
        if (this.documentListener != null) {
            this.documentListener.handleDocumentDeleted();
        }
    }

    @Override
    public void handleDocumentDisconnected() {
        if (this.documentListener != null) {
            this.documentListener.handleDocumentDisconnected();
        }
    }

    @Override
    public void handleDocumentFlushed() {
        this.fireContentChanged();
        if (this.documentListener != null) {
            this.documentListener.handleDocumentFlushed();
        }
    }

    @Override
    public void handleDocumentSaved() {
        if (this.documentListener != null) {
            this.documentListener.handleDocumentSaved();
        }
    }

    public IEditorInput getEditorInput() {
        Path path = new Path(this.node.getCacheFile().getAbsolutePath());
        IFileStore fileStore = EFS.getLocalFileSystem().getStore((IPath)path);
        return new FileStoreEditorInput(fileStore);
    }

    public void store2Cache(IProgressMonitor monitor) throws CoreException {
        File cacheFile = this.node.getCacheFile();
        monitor.beginTask(NLS.bind((String)Messages.LocalTypedElement_SavingFile, (Object)cacheFile.getName()), 100);
        InputStream is = this.getContents();
        FilterOutputStream bos = null;
        try {
            try {
                int length;
                long total = cacheFile.length();
                bos = new BufferedOutputStream(new FileOutputStream(cacheFile));
                byte[] data = new byte[10240];
                long current = 0L;
                int currProgress = 0;
                while ((length = is.read(data)) > 0) {
                    ((BufferedOutputStream)bos).write(data, 0, length);
                    ((BufferedOutputStream)bos).flush();
                    int progress = (int)((current += (long)length) * 100L / total);
                    if (currProgress == progress) continue;
                    monitor.worked(progress - currProgress);
                    currProgress = progress;
                }
                this.setDirty(false);
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, UIPlugin.getUniqueIdentifier(), e.getMessage(), (Throwable)e));
            }
        }
        catch (Throwable throwable) {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (Exception exception) {}
            }
            this.fireContentChanged();
            throw throwable;
        }
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
        if (bos != null) {
            try {
                bos.close();
            }
            catch (Exception exception) {}
        }
        this.fireContentChanged();
    }
}

