/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.ui.internal.decorators;

import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.tcf.te.tcf.filesystem.ui.activator.UIPlugin;
import org.eclipse.tcf.te.ui.jface.images.AbstractImageDescriptor;

public class PhantomImageDescriptor
extends AbstractImageDescriptor {
    private static final int HIGHLIGHT_ALPHA = 127;
    private static final String ID_FS_NODE_CUT_MASK = "FS_NODE_CUT_MASK@";
    private static final String ID_FS_NODE_CUT = "FS_NODE_CUT@";
    private Image baseImage;

    public PhantomImageDescriptor(Image baseImage) {
        super(UIPlugin.getDefault().getImageRegistry());
        this.baseImage = baseImage;
        String key = ID_FS_NODE_CUT + baseImage.hashCode();
        this.setDecriptorKey(key);
    }

    protected void drawCompositeImage(int width, int height) {
        this.drawCentered(this.baseImage, width, height);
        this.drawCentered(this.getMaskImage(), width, height);
    }

    private Image getMaskImage() {
        String maskKey = ID_FS_NODE_CUT_MASK + this.baseImage.hashCode();
        Image maskImage = UIPlugin.getImage(maskKey);
        if (maskImage == null) {
            ImageData baseData = this.baseImage.getImageData();
            PaletteData palette = new PaletteData(new RGB[]{new RGB(255, 255, 255), new RGB(0, 0, 0)});
            ImageData imageData = new ImageData(baseData.width, baseData.height, 1, palette);
            imageData.alphaData = this.createAlphaData();
            maskImage = new Image(this.baseImage.getDevice(), imageData);
            UIPlugin.getDefault().getImageRegistry().put(maskKey, maskImage);
        }
        return maskImage;
    }

    private byte[] createAlphaData() {
        ImageData imageData = this.baseImage.getImageData();
        if (imageData.maskData != null) {
            if (imageData.depth == 32) {
                return this.maskAlpha32();
            }
            return this.maskAlpha();
        }
        return this.nonMaskAlpha();
    }

    private byte[] nonMaskAlpha() {
        ImageData imageData = this.baseImage.getImageData();
        Assert.isTrue((imageData.maskData == null ? 1 : 0) != 0);
        byte[] alphaData = new byte[imageData.width * imageData.height];
        int i = 0;
        int y = 0;
        while (y < imageData.height) {
            int x = 0;
            while (x < imageData.width) {
                int pixel = imageData.getPixel(x, y);
                int alpha = 255;
                if (imageData.transparentPixel != -1 && imageData.transparentPixel == pixel) {
                    alpha = 0;
                } else if (imageData.alpha != -1) {
                    alpha = imageData.alpha;
                } else if (imageData.alphaData != null) {
                    alpha = imageData.getAlpha(x, y);
                }
                alphaData[i++] = (byte)(alpha * 127 / 255);
                ++x;
            }
            ++y;
        }
        return alphaData;
    }

    private byte[] maskAlpha() {
        ImageData imageData = this.baseImage.getImageData();
        Assert.isTrue((imageData.maskData != null && imageData.depth != 32 ? 1 : 0) != 0);
        ImageData mask = imageData.getTransparencyMask();
        int blackIndex = this.getBlackIndex(mask);
        byte[] alphaData = new byte[imageData.width * imageData.height];
        int i = 0;
        int y = 0;
        while (y < imageData.height) {
            int x = 0;
            while (x < imageData.width) {
                int alpha = mask.getPixel(x, y) == blackIndex ? 0 : 255;
                alphaData[i++] = (byte)(alpha * 127 / 255);
                ++x;
            }
            ++y;
        }
        return alphaData;
    }

    private byte[] maskAlpha32() {
        ImageData imageData = this.baseImage.getImageData();
        Assert.isTrue((imageData.maskData != null && imageData.depth == 32 ? 1 : 0) != 0);
        ImageData mask = imageData.getTransparencyMask();
        int blackIndex = this.getBlackIndex(mask);
        int alphaMask = ~(imageData.palette.redMask | imageData.palette.greenMask | imageData.palette.blueMask);
        int alphaShift = 0;
        while (alphaMask != 0 && (alphaMask >>> alphaShift & 1) == 0) {
            ++alphaShift;
        }
        byte[] alphaData = new byte[imageData.width * imageData.height];
        int i = 0;
        int y = 0;
        while (y < imageData.height) {
            int x = 0;
            while (x < imageData.width) {
                int pixel = imageData.getPixel(x, y);
                int alpha = (pixel & alphaMask) >>> alphaShift;
                if (alpha <= 0 || alpha > 255) {
                    alpha = mask.getPixel(x, y) == blackIndex ? 0 : 255;
                }
                alphaData[i++] = (byte)(alpha * 127 / 255);
                ++x;
            }
            ++y;
        }
        return alphaData;
    }

    private int getBlackIndex(ImageData mask) {
        RGB[] rgbs = mask.getRGBs();
        if (rgbs != null) {
            int i = 0;
            while (i < rgbs.length) {
                RGB rgb = rgbs[i];
                if (rgb.red == 0 && rgb.green == 0 && rgb.blue == 0) {
                    return i;
                }
                ++i;
            }
        }
        return 0;
    }

    protected Point getSize() {
        return new Point(this.baseImage.getImageData().width, this.baseImage.getImageData().height);
    }

    protected Image getBaseImage() {
        return this.baseImage;
    }
}

