/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.services.contexts.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.interfaces.IDisposable;
import org.eclipse.tcf.te.tcf.services.contexts.interfaces.IContextService;

public class ContextServiceAdapter
implements IContextService,
IDisposable {
    final IPeer peer;
    private final List<IContextService.IDelegate> delegates = new ArrayList<IContextService.IDelegate>();

    public ContextServiceAdapter(IPeer peer) {
        Assert.isNotNull((Object)peer);
        this.peer = peer;
    }

    public void dispose() {
        this.delegates.clear();
    }

    public IPeer getPeer() {
        return this.peer;
    }

    @Override
    public IContextService.IDelegate getDelegate(String contextID) {
        IContextService.IDelegate[] candidates;
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Assert.isNotNull((Object)contextID);
        IContextService.IDelegate[] iDelegateArray = candidates = this.delegates.toArray(new IContextService.IDelegate[this.delegates.size()]);
        int n = candidates.length;
        int n2 = 0;
        while (n2 < n) {
            IContextService.IDelegate candidate = iDelegateArray[n2];
            if (candidate.canHandle(contextID)) {
                return candidate;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public void addDelegate(IContextService.IDelegate delegate) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Assert.isNotNull((Object)delegate);
        if (!this.delegates.contains(delegate)) {
            this.delegates.add(delegate);
        }
    }

    @Override
    public void removeDelegate(IContextService.IDelegate delegate) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Assert.isNotNull((Object)delegate);
        this.delegates.remove(delegate);
    }
}

