/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.views.handler;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.te.ui.views.Managers;
import org.eclipse.tcf.te.ui.views.interfaces.ICategory;
import org.eclipse.tcf.te.ui.views.interfaces.categories.ICategorizable;
import org.eclipse.tcf.te.ui.views.internal.categories.AbstractCategoryContributionItem;
import org.eclipse.tcf.te.ui.views.nls.Messages;

public class CategoryAddToContributionItem
extends AbstractCategoryContributionItem {
    @Override
    protected IAction createAction(AbstractCategoryContributionItem item, ISelection selection, ICategory category, boolean single) {
        return new AddToCategoryAction(item, selection, category, single);
    }

    @Override
    protected boolean isValid(ICategory parentCategory, Object element, ICategory category) {
        Assert.isNotNull((Object)element);
        Assert.isNotNull((Object)category);
        ICategorizable categorizable = this.getCategorizable(element);
        Assert.isNotNull((Object)categorizable);
        return categorizable.isValid(ICategorizable.OPERATION.ADD, parentCategory, category);
    }

    @Override
    protected boolean isEnabled(ISelection selection, ICategory category) {
        Assert.isNotNull((Object)selection);
        Assert.isNotNull((Object)category);
        boolean enabled = false;
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            enabled = true;
            for (Object element : (IStructuredSelection)selection) {
                ICategorizable categorizable = this.getCategorizable(element);
                if (!(enabled &= categorizable != null && categorizable.isEnabled(ICategorizable.OPERATION.ADD, category))) break;
            }
        }
        return enabled;
    }

    protected static class AddToCategoryAction
    extends AbstractCategoryContributionItem.AbstractCategoryAction {
        public AddToCategoryAction(AbstractCategoryContributionItem item, ISelection selection, ICategory category, boolean single) {
            super(item, selection, category, single);
        }

        @Override
        protected String makeSingleText(String text) {
            Assert.isNotNull((Object)text);
            return NLS.bind((String)Messages.AddToCategoryAction_single_text, (Object)text);
        }

        @Override
        protected boolean execute(Object element, ICategory category) {
            Assert.isNotNull((Object)element);
            Assert.isNotNull((Object)category);
            boolean refresh = false;
            ICategorizable categorizable = this.getCategorizable(element);
            Assert.isNotNull((Object)categorizable);
            if (!Managers.getCategoryManager().belongsTo(category.getId(), categorizable.getId())) {
                Managers.getCategoryManager().add(category.getId(), categorizable.getId());
                refresh = true;
            }
            return refresh;
        }
    }
}

