/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.filesystem;

import java.util.HashMap;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.ILogEntry;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.filesystem.CVSFileStore;
import org.eclipse.team.internal.ccvs.core.filesystem.CVSURI;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolderTree;

public class CVSFileTree {
    private RemoteFolderTree remoteTree;
    private HashMap remoteFolders;
    private HashMap logMap;
    private CVSURI baseURI;

    public CVSFileTree(IFileStore treeRoot, CVSURI uri, RemoteFolderTree remoteTree, HashMap remoteFolders, HashMap logMap) {
        this.remoteTree = remoteTree;
        this.baseURI = uri;
        this.remoteFolders = remoteFolders;
        this.logMap = logMap;
    }

    public IFileStore[] getChildrenFileStores(IFileStore store) {
        CVSURI cvsUri = CVSURI.fromUri(store.toURI());
        RemoteFolderTree folderTree = (RemoteFolderTree)this.remoteFolders.get(cvsUri.getProjectStrippedPath().toString());
        if (folderTree == null) {
            return null;
        }
        ICVSRemoteResource[] remoteResources = folderTree.getChildren();
        IFileStore[] fileStore = new IFileStore[remoteResources.length];
        int i = 0;
        while (i < remoteResources.length) {
            try {
                IFileInfo fileInfo = this.getFileInfo(remoteResources[i], (IProgressMonitor)new NullProgressMonitor());
                fileStore[i] = new CVSFileStore(this.baseURI.append(fileInfo.getName()), fileInfo);
            }
            catch (TeamException teamException) {}
            ++i;
        }
        return fileStore;
    }

    private IFileInfo getFileInfo(ICVSResource resource, IProgressMonitor monitor) throws TeamException {
        monitor = Policy.monitorFor(monitor);
        if (resource == null) {
            return null;
        }
        FileInfo info = new FileInfo();
        info.setExists(true);
        info.setName(resource.getName());
        if (!resource.isFolder()) {
            ICVSRemoteFile file = (ICVSRemoteFile)resource;
            ILogEntry entry = (ILogEntry)this.logMap.get(file);
            info.setLastModified(entry.getDate().getTime());
        } else {
            info.setLastModified(0L);
            info.setDirectory(true);
        }
        return info;
    }

    public IFileInfo[] getChildrenFileInfos(IFileStore store) {
        CVSURI cvsUri = CVSURI.fromUri(store.toURI());
        RemoteFolderTree folderTree = (RemoteFolderTree)this.remoteFolders.get(cvsUri.getProjectStrippedPath().toString());
        if (folderTree == null) {
            return null;
        }
        ICVSRemoteResource[] remoteResources = folderTree.getChildren();
        IFileInfo[] fileInfos = new IFileInfo[remoteResources.length];
        int i = 0;
        while (i < remoteResources.length) {
            try {
                IFileInfo fileInfo;
                fileInfos[i] = fileInfo = this.getFileInfo(remoteResources[i], (IProgressMonitor)new NullProgressMonitor());
            }
            catch (TeamException teamException) {}
            ++i;
        }
        return fileInfos;
    }

    public IFileInfo getFileInfo(IFileStore store) {
        ICVSRemoteFolder folder = null;
        String resourceName = null;
        CVSURI cvsUri = CVSURI.fromUri(store.toURI());
        folder = cvsUri.getParentFolder();
        resourceName = cvsUri.getLastSegment();
        if (folder.getName().equals("")) {
            FileInfo info = new FileInfo();
            info.setExists(true);
            info.setName(resourceName);
            info.setDirectory(true);
            return info;
        }
        try {
            RemoteFolderTree remoteFolder = (RemoteFolderTree)this.remoteFolders.get(folder.getName());
            if (remoteFolder == null) {
                String repoPath = folder.getRepositoryRelativePath();
                Path repoPath2 = new Path(repoPath);
                repoPath2 = repoPath2.removeFirstSegments(1);
                remoteFolder = (RemoteFolderTree)this.remoteFolders.get(repoPath2.toString());
            }
            if (remoteFolder == null) {
                remoteFolder = this.remoteTree;
            }
            ICVSRemoteResource[] children = remoteFolder.getChildren();
            ICVSRemoteResource resource = null;
            int i = 0;
            while (i < children.length) {
                ICVSRemoteResource child = children[i];
                if (child.getName().equals(resourceName)) {
                    resource = child;
                    break;
                }
                ++i;
            }
            return this.getFileInfo(resource, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            CVSProviderPlugin.log(e);
            return null;
        }
    }
}

