/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.registry.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.tm4e.registry.IGrammarDefinition;

public class GrammarCache {
    private final Map<String, IGrammarDefinition> definitions = new HashMap<String, IGrammarDefinition>();
    private final Map<String, Collection<String>> injections = new HashMap<String, Collection<String>>();
    private final Map<String, String> scopeNameBindings = new HashMap<String, String>();

    public void registerGrammarDefinition(IGrammarDefinition definition) {
        this.definitions.put(definition.getScopeName(), definition);
    }

    public void unregisterGrammarDefinition(IGrammarDefinition definition) {
        this.definitions.remove(definition.getScopeName());
    }

    public Collection<IGrammarDefinition> getDefinitions() {
        return this.definitions.values();
    }

    public IGrammarDefinition getDefinition(String scopeName) {
        return this.definitions.get(scopeName);
    }

    public Collection<String> getInjections(String scopeName) {
        return this.injections.get(scopeName);
    }

    public void registerInjection(String scopeName, String injectTo) {
        Collection<String> injections = this.getInjections(injectTo);
        if (injections == null) {
            injections = new ArrayList<String>();
            this.injections.put(injectTo, injections);
        }
        injections.add(scopeName);
    }

    public String getScopeNameForContentType(String contentTypeId) {
        return this.scopeNameBindings.get(contentTypeId);
    }

    public String[] getContentTypesForScope(String scopeName) {
        if (scopeName == null) {
            return null;
        }
        return this.scopeNameBindings.entrySet().stream().filter(map -> scopeName.equals(map.getValue())).map(map -> (String)map.getKey()).collect(Collectors.toList()).toArray(new String[0]);
    }

    public void registerContentTypeBinding(String contentTypeId, String scopeName) {
        this.scopeNameBindings.put(contentTypeId, scopeName);
    }
}

