/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.trace;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multiset;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.core.Activator;
import org.eclipse.tracecompass.tmf.core.TmfCommonConstants;
import org.eclipse.tracecompass.tmf.core.signal.TmfEventFilterAppliedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSelectionRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceModelSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfWindowRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceContext;

@NonNullByDefault
public final class TmfTraceManager {
    private final Map<ITmfTrace, TmfTraceContext> fTraces = new LinkedHashMap<ITmfTrace, TmfTraceContext>();
    private final Multiset<IResource> fInstanceCounts = (Multiset)NonNullUtils.checkNotNull((Object)HashMultiset.create());
    private @Nullable ITmfTrace fCurrentTrace = null;
    private static final String TEMP_DIR_NAME = ".tracecompass-temp";
    private static @Nullable TmfTraceManager tm = null;

    private TmfTraceManager() {
        TmfSignalManager.registerVIP(this);
    }

    public static synchronized TmfTraceManager getInstance() {
        TmfTraceManager mgr = tm;
        if (mgr == null) {
            tm = mgr = new TmfTraceManager();
        }
        return mgr;
    }

    public synchronized void dispose() {
        TmfSignalManager.deregister(this);
        this.fTraces.clear();
        this.fInstanceCounts.clear();
        this.fCurrentTrace = null;
    }

    public synchronized @Nullable ITmfTrace getActiveTrace() {
        return this.fCurrentTrace;
    }

    public synchronized Collection<ITmfTrace> getActiveTraceSet() {
        ITmfTrace trace = this.fCurrentTrace;
        return TmfTraceManager.getTraceSet(trace);
    }

    public synchronized Set<ITmfTrace> getOpenedTraces() {
        return Collections.unmodifiableSet(this.fTraces.keySet());
    }

    public synchronized Set<ITmfTrace> getTracesForHost(String hostId) {
        return Collections.unmodifiableSet(this.fTraces.keySet().stream().flatMap(t -> TmfTraceManager.getTraceSet(t).stream()).filter(t -> hostId.equals(t.getHostId())).collect(Collectors.toSet()));
    }

    public synchronized @Nullable IFile getTraceEditorFile(ITmfTrace trace) {
        TmfTraceContext ctx = this.fTraces.get(trace);
        if (ctx != null) {
            return ctx.getEditorFile();
        }
        return null;
    }

    public synchronized TmfTraceContext getCurrentTraceContext() {
        TmfTraceContext curCtx = this.fTraces.get(this.fCurrentTrace);
        if (curCtx == null) {
            return TmfTraceContext.NULL_CONTEXT;
        }
        return curCtx;
    }

    public synchronized TmfTraceContext getTraceContext(ITmfTrace trace) {
        TmfTraceContext curCtx = this.fTraces.get(trace);
        if (curCtx == null) {
            return TmfTraceContext.NULL_CONTEXT;
        }
        return curCtx;
    }

    public synchronized String getTraceUniqueName(@Nullable ITmfTrace trace) {
        if (trace == null) {
            return "";
        }
        TmfTraceContext ctx = this.getTraceContext(trace);
        int instanceNumber = ctx.getInstanceNumber();
        String name = NonNullUtils.nullToEmptyString((Object)trace.getName());
        if (instanceNumber <= 1) {
            return name;
        }
        return String.valueOf(name) + " | " + instanceNumber;
    }

    public static Collection<ITmfTrace> getTraceSet(@Nullable ITmfTrace trace) {
        if (trace == null) {
            return ImmutableSet.of();
        }
        List<@NonNull ITmfTrace> traces = trace.getChildren(ITmfTrace.class);
        if (!traces.isEmpty()) {
            Iterable iterable = (Iterable)NonNullUtils.checkNotNull((Object)Iterables.concat((Iterable)Iterables.transform(traces, TmfTraceManager::getTraceSet)));
            return ImmutableSet.copyOf((Iterable)iterable);
        }
        return ImmutableSet.of((Object)trace);
    }

    public static Collection<ITmfTrace> getTraceSetWithExperiment(@Nullable ITmfTrace trace) {
        if (trace == null) {
            return ImmutableSet.of();
        }
        List<@NonNull ITmfTrace> traces = trace.getChildren(ITmfTrace.class);
        if (!traces.isEmpty()) {
            Iterable iterable = (Iterable)NonNullUtils.checkNotNull((Object)Iterables.concat((Iterable)Iterables.transform(traces, t -> TmfTraceManager.getTraceSetWithExperiment(t))));
            return ImmutableSet.builder().add((Object)trace).addAll(iterable).build();
        }
        return Collections.singleton(trace);
    }

    public static String getSupplementaryFileDir(ITmfTrace trace) {
        IResource resource = trace.getResource();
        if (resource == null) {
            return TmfTraceManager.getTemporaryDir(trace);
        }
        String supplDir = null;
        try {
            supplDir = resource.getPersistentProperty(TmfCommonConstants.TRACE_SUPPLEMENTARY_FOLDER);
        }
        catch (CoreException e) {
            return TmfTraceManager.getTemporaryDir(trace);
        }
        return String.valueOf(supplDir) + File.separator;
    }

    public static void refreshSupplementaryFiles(ITmfTrace trace) {
        IResource resource = trace.getResource();
        if (resource != null && resource.exists()) {
            IProject project;
            String supplFolderPath = TmfTraceManager.getSupplementaryFileDir(trace);
            if (!supplFolderPath.startsWith((project = resource.getProject()).getLocation().toOSString())) {
                Activator.logWarning(String.format("Supplementary files folder for trace %s is not within the project.", trace.getName()));
                return;
            }
            IFolder supplFolder = project.getFolder(supplFolderPath.substring(project.getLocationURI().getPath().length()));
            if (supplFolder.exists()) {
                try {
                    supplFolder.refreshLocal(2, null);
                }
                catch (CoreException e) {
                    Activator.logError("Error refreshing resources", e);
                }
            }
        }
    }

    public static void deleteSupplementaryFiles(ITmfTrace trace) {
        try {
            FileUtils.cleanDirectory((File)new File(TmfTraceManager.getSupplementaryFileDir(trace)));
        }
        catch (IOException e) {
            Activator.logError("Error deleting supplementary files for trace " + trace.getName(), e);
        }
        TmfTraceManager.refreshSupplementaryFiles(trace);
    }

    public static void deleteSupplementaryFolder(ITmfTrace trace) {
        TmfTraceManager.deleteSupplementaryFiles(trace);
        File parent = new File(TmfTraceManager.getSupplementaryFileDir(trace));
        try {
            TmfTraceManager.deleteFolder(parent, TmfTraceManager.getTemporaryDirPath());
        }
        catch (IOException e) {
            Activator.logError("Error deleting supplementary folder for trace " + trace.getName(), e);
        }
    }

    public synchronized boolean isSynchronized(ITmfTrace trace, ITmfTrace other) {
        boolean sameTrace;
        boolean bl = sameTrace = trace.getResource() == null ? false : trace.getResource().equals((Object)other.getResource());
        return trace.equals(other) || !sameTrace && this.getTraceContext(trace).isSynchronized();
    }

    public synchronized void updateTraceContext(ITmfTrace trace, UnaryOperator<TmfTraceContext.Builder> updater) {
        TmfTraceContext ctx = this.getTraceContext(trace);
        if (!ctx.equals(TmfTraceContext.NULL_CONTEXT)) {
            this.fTraces.put(trace, ((TmfTraceContext.Builder)NonNullUtils.checkNotNull((Object)((TmfTraceContext.Builder)updater.apply(ctx.builder())))).build());
        }
    }

    @TmfSignalHandler
    public synchronized void traceOpened(TmfTraceOpenedSignal signal) {
        ITmfTrace trace = signal.getTrace();
        IFile editorFile = signal.getEditorFile();
        TmfTimeRange windowRange = trace.getInitialTimeRange();
        ITmfTimestamp startTs = windowRange.getStartTime();
        TmfTimeRange selectionRange = new TmfTimeRange(startTs, startTs);
        TmfTraceContext startCtx = trace.createTraceContext(selectionRange, windowRange, editorFile, null);
        this.fTraces.put(trace, startCtx);
        IResource resource = trace.getResource();
        if (resource != null) {
            this.fInstanceCounts.add((Object)resource);
            this.updateTraceContext(trace, builder -> builder.setInstanceNumber(this.fInstanceCounts.count((Object)resource)));
        }
        this.fCurrentTrace = trace;
    }

    @TmfSignalHandler
    public synchronized void signalReceived(TmfTraceModelSignal signal) {
        this.fTraces.forEach((t, u) -> u.receive(signal));
    }

    @TmfSignalHandler
    public synchronized void traceSelected(TmfTraceSelectedSignal signal) {
        ITmfTrace newTrace = signal.getTrace();
        if (!this.fTraces.containsKey(newTrace)) {
            throw new RuntimeException();
        }
        this.fCurrentTrace = newTrace;
    }

    @TmfSignalHandler
    public synchronized void filterApplied(TmfEventFilterAppliedSignal signal) {
        ITmfTrace trace = signal.getTrace();
        if (trace == null) {
            return;
        }
        this.updateTraceContext(trace, builder -> builder.setFilter(signal.getEventFilter()));
    }

    @TmfSignalHandler
    public synchronized void traceClosed(TmfTraceClosedSignal signal) {
        this.fTraces.remove(signal.getTrace());
        IResource resource = signal.getTrace().getResource();
        if (resource != null && this.fTraces.keySet().stream().noneMatch(trace -> resource.equals((Object)trace.getResource()))) {
            this.fInstanceCounts.setCount((Object)resource, 0);
        }
        if (this.fTraces.size() == 0) {
            this.fCurrentTrace = null;
        }
    }

    @TmfSignalHandler
    public synchronized void selectionRangeUpdated(TmfSelectionRangeUpdatedSignal signal) {
        ITmfTimestamp beginTs = signal.getBeginTime();
        ITmfTimestamp endTs = signal.getEndTime();
        ITmfTrace signalTrace = signal.getTrace();
        for (ITmfTrace trace : this.fTraces.keySet()) {
            if (!beginTs.intersects(this.getValidTimeRange(trace)) && !endTs.intersects(this.getValidTimeRange(trace)) || signalTrace != null && !this.isSynchronized(trace, signalTrace)) continue;
            this.updateTraceContext(trace, builder -> builder.setSelection(new TmfTimeRange(beginTs, endTs)));
        }
    }

    @TmfSignalHandler
    public synchronized void windowRangeUpdated(TmfWindowRangeUpdatedSignal signal) {
        ITmfTrace signalTrace = signal.getTrace();
        for (Map.Entry<ITmfTrace, TmfTraceContext> entry : this.fTraces.entrySet()) {
            TmfTimeRange targetTr;
            TmfTimeRange validTr;
            ITmfTrace trace = (ITmfTrace)NonNullUtils.checkNotNull((Object)entry.getKey());
            if (signalTrace != null && !this.isSynchronized(trace, signalTrace) || (validTr = this.getValidTimeRange(trace)) == null || (targetTr = signal.getCurrentRange().getIntersection(validTr)) == null) continue;
            this.updateTraceContext(trace, builder -> builder.setWindowRange(targetTr));
        }
    }

    private @Nullable TmfTimeRange getValidTimeRange(ITmfTrace trace) {
        if (!this.fTraces.containsKey(trace)) {
            return null;
        }
        List<ITmfTrace> traces = trace.getChildren(ITmfTrace.class);
        if (traces.isEmpty()) {
            return trace.getTimeRange();
        }
        if (traces.size() == 1) {
            return traces.get(0).getTimeRange();
        }
        ITmfTimestamp start = traces.get(0).getStartTime();
        ITmfTimestamp end = traces.get(0).getEndTime();
        int i = 1;
        while (i < traces.size()) {
            ITmfTrace curTrace = traces.get(i);
            if (curTrace.getStartTime().compareTo(start) < 0) {
                start = curTrace.getStartTime();
            }
            if (curTrace.getEndTime().compareTo(end) > 0) {
                end = curTrace.getEndTime();
            }
            ++i;
        }
        return new TmfTimeRange(start, end);
    }

    public static String getTemporaryDirPath() {
        String property = System.getProperty("osgi.instance.area");
        if (property != null) {
            try {
                File dir = URIUtil.toFile((URI)URIUtil.fromString((String)property));
                dir = new File(String.valueOf(dir.getAbsolutePath()) + File.separator + TEMP_DIR_NAME);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                return dir.getAbsolutePath();
            }
            catch (URISyntaxException e) {
                Activator.logError(e.getLocalizedMessage(), e);
            }
        }
        return System.getProperty("java.io.tmpdir");
    }

    private static String getTemporaryDir(ITmfTrace trace) {
        String pathName = String.valueOf(TmfTraceManager.getTemporaryDirPath()) + File.separator + trace.getName() + File.separator;
        File dir = new File(pathName);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return pathName;
    }

    private static void deleteFolder(File folder, String stopPath) throws IOException {
        File parent;
        if (folder.exists()) {
            FileUtils.deleteDirectory((File)folder);
        }
        if (!(parent = folder.getParentFile()).getAbsolutePath().equals(stopPath) && parent.list().length == 0) {
            TmfTraceManager.deleteFolder(parent, stopPath);
        }
    }
}

