/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.viewers.runtime.specifications;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collections;
import org.eclipse.viatra.addon.viewers.runtime.specifications.SpecificationDescriptorUtilities;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.matchers.planning.QueryProcessingException;
import org.eclipse.viatra.query.runtime.matchers.psystem.annotations.PAnnotation;
import org.eclipse.viatra.query.runtime.matchers.psystem.annotations.ParameterReference;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.viatra.transformation.views.traceability.generic.AbstractQuerySpecificationDescriptor;

public class ContainmentQuerySpecificationDescriptor
extends AbstractQuerySpecificationDescriptor {
    public static final String ANNOTATION_ID = "ContainsItem";
    private static final String SOURCE = "container";
    private static final String TARGET = "item";
    private final String container;
    private final String item;

    public ContainmentQuerySpecificationDescriptor(IQuerySpecification<?> specification, PAnnotation annotation) {
        super(specification, ContainmentQuerySpecificationDescriptor.getTraceSource(specification, annotation), Collections.emptyMap());
        String parameterTargetValue;
        String parameterSourceValue;
        ParameterReference parameterSource = (ParameterReference)annotation.getFirstValue(SOURCE, ParameterReference.class).orElseThrow(() -> new QueryProcessingException("Invalid container value", (Object)specification));
        this.container = parameterSourceValue = parameterSource.getName();
        ParameterReference parameterTarget = (ParameterReference)annotation.getFirstValue(TARGET, ParameterReference.class).orElseThrow(() -> new QueryProcessingException("Invalid item value", (Object)specification));
        this.item = parameterTargetValue = parameterTarget.getName();
    }

    private static Multimap<PParameter, PParameter> getTraceSource(IQuerySpecification<?> specification, PAnnotation annotation) {
        ArrayListMultimap traces = ArrayListMultimap.create();
        ParameterReference parameterSource = (ParameterReference)annotation.getFirstValue(SOURCE, ParameterReference.class).orElseThrow(() -> new QueryProcessingException("Invalid container value", (Object)specification));
        ParameterReference parameterTarget = (ParameterReference)annotation.getFirstValue(TARGET, ParameterReference.class).orElseThrow(() -> new QueryProcessingException("Invalid item value", (Object)specification));
        SpecificationDescriptorUtilities.insertToTraces(specification, (Multimap<PParameter, PParameter>)traces, parameterSource.getName());
        SpecificationDescriptorUtilities.insertToTraces(specification, (Multimap<PParameter, PParameter>)traces, parameterTarget.getName());
        return traces;
    }

    public String getContainer() {
        return this.container;
    }

    public String getItem() {
        return this.item;
    }
}

