/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.ui.queryresult;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.viatra.query.runtime.api.AdvancedViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.IModelConnectorTypeEnum;
import org.eclipse.viatra.query.runtime.api.scope.QueryScope;
import org.eclipse.viatra.query.runtime.emf.EMFScope;
import org.eclipse.viatra.query.runtime.matchers.backend.QueryEvaluationHint;
import org.eclipse.viatra.query.runtime.matchers.util.Preconditions;
import org.eclipse.viatra.query.runtime.registry.QuerySpecificationRegistry;
import org.eclipse.viatra.query.runtime.ui.modelconnector.IModelConnector;
import org.eclipse.viatra.query.tooling.ui.preferences.RuntimePreferencesInterpreter;
import org.eclipse.viatra.query.tooling.ui.queryresult.QueryResultTreeInput;

public enum QueryResultViewModel {
    INSTANCE;

    private Set<QueryResultTreeInput> inputs = new HashSet<QueryResultTreeInput>();
    private QueryEvaluationHint defaultHint = new QueryEvaluationHint(null, QueryEvaluationHint.BackendRequirement.DEFAULT_CACHING);

    protected QueryResultTreeInput createInput(IModelConnector connector, IModelConnectorTypeEnum type) {
        Preconditions.checkArgument((connector != null ? 1 : 0) != 0, (String)"Connector cannot be null");
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (String)"Type cannot be null");
        Notifier notifier = connector.getNotifier(type);
        EMFScope scope = new EMFScope(notifier, RuntimePreferencesInterpreter.getBaseIndexOptionsFromPreferences());
        AdvancedViatraQueryEngine engine = AdvancedViatraQueryEngine.createUnmanagedEngine((QueryScope)scope);
        QueryResultTreeInput input = this.createInput(engine, false);
        input.setModelConnector(connector);
        return input;
    }

    protected QueryResultTreeInput createInput(AdvancedViatraQueryEngine engine, boolean readOnlyEngine) {
        QueryResultTreeInput input = new QueryResultTreeInput(engine, QuerySpecificationRegistry.getInstance(), readOnlyEngine, this.defaultHint);
        this.inputs.add(input);
        return input;
    }

    protected boolean removeInput(QueryResultTreeInput input) {
        Preconditions.checkArgument((input != null ? 1 : 0) != 0, (String)"Input cannot be null");
        boolean removed = this.inputs.remove(input);
        if (removed) {
            AdvancedViatraQueryEngine engine = input.getEngine();
            input.dispose();
            if (engine != null && !input.isReadOnlyEngine()) {
                engine.dispose();
            }
        }
        return removed;
    }
}

