/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.util;

import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.viatra.query.runtime.matchers.util.IMemoryView;
import org.eclipse.viatra.query.runtime.matchers.util.IMultiLookup;
import org.eclipse.viatra.query.runtime.matchers.util.MarkedMemory;
import org.eclipse.viatra.query.runtime.matchers.util.SingletonMemoryView;

public interface IMultiLookupAbstract<Key, Value, Bucket extends MarkedMemory<Value>>
extends IMultiLookup<Key, Value> {
    public Object lowLevelGet(Key var1);

    public Object lowLevelGetUnsafe(Object var1);

    public void lowLevelRemove(Key var1);

    public Object lowLevelPutIfAbsent(Key var1, Value var2);

    public void lowLevelPut(Key var1, Object var2);

    public Iterable<Object> lowLevelValues();

    public Iterable<Key> lowLevelKeySet();

    public int lowLevelSize();

    @Override
    default public IMemoryView<Value> lookup(Key key) {
        Object object = this.lowLevelGet(key);
        if (object == null) {
            return null;
        }
        if (object instanceof MarkedMemory) {
            return (MarkedMemory)object;
        }
        return this.yieldSingleton(object);
    }

    @Override
    default public IMemoryView<Value> lookupUnsafe(Object key) {
        Object object = this.lowLevelGetUnsafe(key);
        if (object == null) {
            return null;
        }
        if (object instanceof MarkedMemory) {
            return (MarkedMemory)object;
        }
        return this.yieldSingleton(object);
    }

    @Override
    default public IMultiLookup.ChangeGranularity addPair(Key key, Value value) {
        MarkedMemory<Object> bucket;
        boolean keyChange;
        Object old = this.lowLevelPutIfAbsent(key, value);
        boolean bl = keyChange = old == null;
        if (keyChange) {
            return IMultiLookup.ChangeGranularity.KEY;
        }
        if (old instanceof MarkedMemory) {
            bucket = (MarkedMemory)old;
        } else {
            bucket = this.createSingletonBucket(old);
            this.lowLevelPut(key, bucket);
        }
        if (this.addToBucket(bucket, value)) {
            if (this.negativesAllowed()) {
                if (bucket.isEmpty()) {
                    this.lowLevelRemove(key);
                    return IMultiLookup.ChangeGranularity.KEY;
                }
                this.handleSingleton(key, bucket);
                return IMultiLookup.ChangeGranularity.VALUE;
            }
            return IMultiLookup.ChangeGranularity.VALUE;
        }
        return IMultiLookup.ChangeGranularity.DUPLICATE;
    }

    @Override
    default public IMultiLookup.ChangeGranularity addPairPositiveMultiplicity(Key key, Value value, int count2) {
        Object bucket;
        boolean keyChange;
        if (count2 == 1) {
            return this.addPair(key, value);
        }
        Object old = this.lowLevelGet(key);
        boolean bl = keyChange = old == null;
        if (keyChange) {
            bucket = this.createSingletonBucket(value);
            this.lowLevelPut(key, bucket);
            --count2;
        } else if (old instanceof MarkedMemory) {
            bucket = (MarkedMemory)old;
        } else {
            bucket = this.createSingletonBucket(old);
            this.lowLevelPut(key, bucket);
        }
        boolean newValue = bucket.addSigned(value, count2);
        if (keyChange) {
            return IMultiLookup.ChangeGranularity.KEY;
        }
        if (newValue) {
            return IMultiLookup.ChangeGranularity.VALUE;
        }
        return IMultiLookup.ChangeGranularity.DUPLICATE;
    }

    @Override
    default public IMultiLookup.ChangeGranularity removePair(Key key, Value value) {
        Object old = this.lowLevelGet(key);
        if (old instanceof MarkedMemory) {
            MarkedMemory bucket = (MarkedMemory)old;
            boolean valueChange = this.removeFromBucket(bucket, value);
            this.handleSingleton(key, bucket);
            if (valueChange) {
                return IMultiLookup.ChangeGranularity.VALUE;
            }
            return IMultiLookup.ChangeGranularity.DUPLICATE;
        }
        if (value.equals(old)) {
            this.lowLevelRemove(key);
            return IMultiLookup.ChangeGranularity.KEY;
        }
        Bucket deltaBucket = this.createDeltaBucket(old, value);
        this.lowLevelPut(key, deltaBucket);
        return IMultiLookup.ChangeGranularity.VALUE;
    }

    default public void handleSingleton(Key key, Bucket bucket) {
        Value remainingSingleton = this.asSingleton(bucket);
        if (remainingSingleton != null) {
            this.lowLevelPut(key, remainingSingleton);
        }
    }

    @Override
    default public Iterable<Value> distinctValues() {
        return new Iterable<Value>(){
            private final Iterator<Value> EMPTY_ITERATOR = Collections.emptySet().iterator();

            @Override
            public Iterator<Value> iterator() {
                return new Iterator<Value>(){
                    Iterator<Object> bucketIterator;
                    Iterator<Value> elementIterator;
                    {
                        this.bucketIterator = IMultiLookupAbstract.this.lowLevelValues().iterator();
                        this.elementIterator = EMPTY_ITERATOR;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.elementIterator.hasNext() || this.bucketIterator.hasNext();
                    }

                    @Override
                    public Value next() {
                        if (this.elementIterator.hasNext()) {
                            return this.elementIterator.next();
                        }
                        if (this.bucketIterator.hasNext()) {
                            Object bucket = this.bucketIterator.next();
                            if (bucket instanceof MarkedMemory) {
                                this.elementIterator = ((MarkedMemory)bucket).distinctValues().iterator();
                                return this.elementIterator.next();
                            }
                            this.elementIterator = EMPTY_ITERATOR;
                            return bucket;
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    default public Iterable<Key> distinctKeys() {
        return this.lowLevelKeySet();
    }

    @Override
    default public int countKeys() {
        return this.lowLevelSize();
    }

    public boolean negativesAllowed();

    public boolean addToBucket(Bucket var1, Value var2);

    public boolean removeFromBucket(Bucket var1, Value var2);

    public Value asSingleton(Bucket var1);

    public Bucket createSingletonBucket(Value var1);

    default public IMemoryView<Value> yieldSingleton(Value value) {
        return new SingletonMemoryView<Value>(value);
    }

    public Bucket createDeltaBucket(Value var1, Value var2);

    public static interface ToMultisetsAbstract<Key, Value>
    extends IMultiLookupAbstract<Key, Value, MarkedMemory.MarkedMultiset<Value>> {
        public MarkedMemory.MarkedMultiset<Value> createMarkedMultiset();

        @Override
        default public boolean negativesAllowed() {
            return false;
        }

        @Override
        default public boolean addToBucket(MarkedMemory.MarkedMultiset<Value> bucket, Value value) {
            return bucket.addOne(value);
        }

        @Override
        default public boolean removeFromBucket(MarkedMemory.MarkedMultiset<Value> bucket, Value value) {
            return bucket.removeOne(value);
        }

        @Override
        default public Value asSingleton(MarkedMemory.MarkedMultiset<Value> bucket) {
            if (bucket.size() != 1) {
                return null;
            }
            Object candidate = bucket.iterator().next();
            return (Value)(bucket.getCount(candidate) == 1 ? candidate : null);
        }

        @Override
        default public MarkedMemory.MarkedMultiset<Value> createSingletonBucket(Value value) {
            MarkedMemory.MarkedMultiset<Value> result = this.createMarkedMultiset();
            result.addOne(value);
            return result;
        }

        @Override
        default public MarkedMemory.MarkedMultiset<Value> createDeltaBucket(Value positive, Value negative) {
            throw new IllegalStateException();
        }
    }

    public static interface ToSetsAbstract<Key, Value>
    extends IMultiLookupAbstract<Key, Value, MarkedMemory.MarkedSet<Value>> {
        public MarkedMemory.MarkedSet<Value> createMarkedSet();

        @Override
        default public boolean negativesAllowed() {
            return false;
        }

        @Override
        default public boolean addToBucket(MarkedMemory.MarkedSet<Value> bucket, Value value) {
            if (bucket.addOne(value)) {
                return true;
            }
            throw new IllegalStateException();
        }

        @Override
        default public boolean removeFromBucket(MarkedMemory.MarkedSet<Value> bucket, Value value) {
            return bucket.removeOne(value);
        }

        @Override
        default public Value asSingleton(MarkedMemory.MarkedSet<Value> bucket) {
            return bucket.size() == 1 ? (Value)bucket.iterator().next() : null;
        }

        @Override
        default public MarkedMemory.MarkedSet<Value> createSingletonBucket(Value value) {
            MarkedMemory.MarkedSet<Value> result = this.createMarkedSet();
            result.addOne(value);
            return result;
        }

        @Override
        default public MarkedMemory.MarkedSet<Value> createDeltaBucket(Value positive, Value negative) {
            throw new IllegalStateException();
        }
    }
}

