/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.network.mailbox;

import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.rete.network.CommunicationGroup;
import org.eclipse.viatra.query.runtime.rete.network.Direction;
import org.eclipse.viatra.query.runtime.rete.network.MessageKind;
import org.eclipse.viatra.query.runtime.rete.network.Receiver;
import org.eclipse.viatra.query.runtime.rete.network.ReteContainer;
import org.eclipse.viatra.query.runtime.rete.network.mailbox.AdaptableMailbox;
import org.eclipse.viatra.query.runtime.rete.network.mailbox.DefaultMailbox;
import org.eclipse.viatra.query.runtime.rete.network.mailbox.Mailbox;
import org.eclipse.viatra.query.runtime.rete.network.mailbox.UpdateSplittingMailbox;

public class AdaptiveMailbox
implements Mailbox {
    protected boolean fallThrough = false;
    protected boolean split = false;
    protected AdaptableMailbox wrappedMailbox;
    protected final Receiver receiver;
    protected final ReteContainer container;
    protected CommunicationGroup group;

    public AdaptiveMailbox(Receiver receiver, ReteContainer container) {
        this.receiver = receiver;
        this.container = container;
        this.wrappedMailbox = new DefaultMailbox(receiver, container);
        this.wrappedMailbox.setAdapter(this);
    }

    @Override
    public void postMessage(Direction direction, Tuple update) {
        if (this.fallThrough) {
            this.receiver.update(direction, update);
        } else {
            this.wrappedMailbox.postMessage(direction, update);
        }
    }

    @Override
    public void deliverAll(MessageKind kind) {
        this.wrappedMailbox.deliverAll(kind);
    }

    public String toString() {
        return "A_MBOX -> " + this.wrappedMailbox;
    }

    public boolean isFallThrough() {
        return this.fallThrough;
    }

    public void setFallThrough(boolean fallThrough) {
        this.fallThrough = fallThrough;
    }

    public void setSplitFlag(boolean splitValue) {
        if (this.split != splitValue) {
            assert (this.isEmpty());
            this.wrappedMailbox = splitValue ? new UpdateSplittingMailbox(this.receiver, this.container) : new DefaultMailbox(this.receiver, this.container);
            this.wrappedMailbox.setAdapter(this);
            this.split = splitValue;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.wrappedMailbox.isEmpty();
    }

    public void clear() {
        this.wrappedMailbox.clear();
    }

    @Override
    public Receiver getReceiver() {
        return this.receiver;
    }

    @Override
    public CommunicationGroup getCurrentGroup() {
        return this.group;
    }

    @Override
    public void setCurrentGroup(CommunicationGroup group) {
        this.group = group;
    }
}

