/**
 * Copyright (c) 2010-2017, Grill Balázs, IncQueryLabs
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Grill Balázs - initial API and implementation
 */
package org.eclipse.viatra.query.testing.core.coverage;

import java.util.function.Consumer;
import org.eclipse.viatra.query.runtime.api.AdvancedViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.ViatraQueryMatcher;
import org.eclipse.viatra.query.runtime.api.scope.QueryScope;
import org.eclipse.viatra.query.runtime.emf.EMFScope;
import org.eclipse.viatra.query.runtime.matchers.backend.IQueryBackend;
import org.eclipse.viatra.query.runtime.rete.matcher.ReteBackendFactory;
import org.eclipse.viatra.query.runtime.rete.matcher.ReteEngine;
import org.eclipse.viatra.query.runtime.rete.network.Node;
import org.eclipse.viatra.query.runtime.rete.network.ReteContainer;
import org.eclipse.viatra.query.runtime.rete.network.Supplier;
import org.eclipse.viatra.query.testing.core.coverage.CoverageContext;
import org.eclipse.viatra.query.testing.core.coverage.CoverageInfo;
import org.eclipse.viatra.query.testing.core.coverage.CoverageState;

/**
 * This utility can determine the coverage of nodes in a Rete network.
 * 
 * @since 1.6
 */
@SuppressWarnings("all")
public class ReteCoverage {
  private final ReteEngine reteEngine;
  
  private final EMFScope scope;
  
  /**
   * Although this constructor requires a matcher, it extracts the underlying ReteEngine and
   * the computed coverage is engine-wide.
   * 
   * @throws ViatraQueryRuntimeException
   */
  public ReteCoverage(final ViatraQueryMatcher<?> matcher) {
    ViatraQueryEngine _engine = matcher.getEngine();
    IQueryBackend _queryBackend = ((AdvancedViatraQueryEngine) _engine).getQueryBackend(
      ReteBackendFactory.INSTANCE);
    this.reteEngine = ((ReteEngine) _queryBackend);
    QueryScope _scope = matcher.getEngine().getScope();
    this.scope = ((EMFScope) _scope);
  }
  
  public CoverageInfo<Node> reteCoverage() {
    final CoverageInfo<Node> coverage = new CoverageInfo<Node>();
    final Consumer<ReteContainer> _function = (ReteContainer it) -> {
      final Consumer<Node> _function_1 = (Node it_1) -> {
        coverage.put(CoverageContext.<Node>create(it_1, this.scope), this.computeCoverage(it_1));
      };
      it.getAllNodes().forEach(_function_1);
    };
    this.reteEngine.getReteNet().getContainers().forEach(_function);
    return coverage;
  }
  
  private CoverageState computeCoverage(final Node node) {
    if ((node instanceof Supplier)) {
      CoverageState _xifexpression = null;
      boolean _isEmpty = ((Supplier)node).getPulledContents().isEmpty();
      if (_isEmpty) {
        _xifexpression = CoverageState.NOT_COVERED;
      } else {
        _xifexpression = CoverageState.COVERED;
      }
      return _xifexpression;
    }
    return CoverageState.NOT_REPRESENTED_UNKNOWN_REASON;
  }
}
