/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.debug.notification;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.jdt.internal.debug.core.model.JDIStackFrame;
import org.eclipse.jdt.internal.debug.core.model.JDIThread;
import org.eclipse.viatra.query.runtime.util.ViatraQueryLoggingUtil;
import org.eclipse.viatra.query.tooling.debug.notification.ViatraQueryDebugEventSetListener;

public class ViatraDebugEventSetProcessor
implements IDebugEventSetListener {
    private static ViatraDebugEventSetProcessor instance;
    private List<ViatraQueryDebugEventSetListener> listeners = new LinkedList<ViatraQueryDebugEventSetListener>();

    public static ViatraDebugEventSetProcessor getInstance() {
        if (instance == null) {
            instance = new ViatraDebugEventSetProcessor();
        }
        return instance;
    }

    protected ViatraDebugEventSetProcessor() {
    }

    public void addListener(ViatraQueryDebugEventSetListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ViatraQueryDebugEventSetListener listener) {
        this.listeners.remove(listener);
    }

    public void handleDebugEvents(DebugEvent[] events) {
        DebugEvent[] debugEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            Object source;
            DebugEvent event = debugEventArray[n2];
            if ((event.getKind() == 2 || event.getDetail() == 8) && (source = event.getSource()) instanceof JDIThread) {
                JDIThread thread = (JDIThread)source;
                try {
                    for (ViatraQueryDebugEventSetListener listener : this.listeners) {
                        listener.update((JDIStackFrame)thread.getStackFrames()[0]);
                    }
                }
                catch (DebugException e) {
                    ViatraQueryLoggingUtil.getLogger(ViatraDebugEventSetProcessor.class).error((Object)"Couldn't retrieve the stack frames!", (Throwable)e);
                }
            }
            ++n2;
        }
    }
}

