/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.debug.variables.values;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.StringReference;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;
import org.eclipse.viatra.query.runtime.util.ViatraQueryLoggingUtil;
import org.eclipse.viatra.query.tooling.debug.common.ViatraQueryDebugValue;
import org.eclipse.viatra.query.tooling.debug.common.ViatraQueryDebugVariable;
import org.eclipse.viatra.query.tooling.debug.variables.ValueWrapper;
import org.eclipse.viatra.query.tooling.debug.variables.values.MatchValue;

public class MatcherValue
extends ViatraQueryDebugValue {
    public MatcherValue(JDIDebugTarget debugTarget, ValueWrapper value) {
        super(debugTarget, value, new String[0]);
    }

    @Override
    public String getLabel() {
        try {
            ValueWrapper patternName = this.fValue.invoke("getPatternName");
            if (patternName.getValue() != null) {
                return ((StringReference)patternName.getValue()).value();
            }
            return null;
        }
        catch (Exception e) {
            ViatraQueryLoggingUtil.getLogger(MatcherValue.class).error((Object)"Label initialization has failed!", (Throwable)e);
            return null;
        }
    }

    @Override
    protected synchronized List<IJavaVariable> getVariablesList() throws DebugException {
        ArrayReference matches;
        if (this.fVariables != null) {
            return this.fVariables;
        }
        this.fVariables = new ArrayList();
        ValueWrapper matchesWrapper = this.fValue.invoke("getAllMatches").get("elementData");
        if (matchesWrapper.isArray() && (matches = (ArrayReference)matchesWrapper.getValue()).length() > 0) {
            for (Value match : matches.getValues()) {
                if (match == null) continue;
                ValueWrapper wrappedMatch = ValueWrapper.wrap(match, this.fValue.getThreadReference());
                ViatraQueryDebugVariable var = new ViatraQueryDebugVariable(this.getJavaDebugTarget());
                MatchValue value = new MatchValue(this.debugTarget, wrappedMatch, new String[0]);
                var.setValue((IValue)value);
                this.fVariables.add(var);
            }
        }
        return this.fVariables;
    }

    public String getValueString() throws DebugException {
        String label = this.getLabel();
        return label == null ? super.getValueString() : label;
    }
}

