/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.localsearch.ui.debugger.views;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.gef.layout.ILayoutAlgorithm;
import org.eclipse.gef.layout.algorithms.TreeLayoutAlgorithm;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.services.IEvaluationService;
import org.eclipse.viatra.integration.zest.viewer.ModifiableZestContentViewer;
import org.eclipse.viatra.integration.zest.viewer.ZestContentViewer;
import org.eclipse.viatra.query.runtime.api.AdvancedViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.localsearch.MatchingFrame;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ILocalSearchAdapter;
import org.eclipse.viatra.query.runtime.localsearch.matcher.integration.LocalSearchBackend;
import org.eclipse.viatra.query.runtime.localsearch.matcher.integration.LocalSearchEMFBackendFactory;
import org.eclipse.viatra.query.runtime.localsearch.matcher.integration.LocalSearchResultProvider;
import org.eclipse.viatra.query.runtime.matchers.backend.IQueryBackend;
import org.eclipse.viatra.query.runtime.matchers.backend.IQueryBackendFactory;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PQuery;
import org.eclipse.viatra.query.runtime.util.ViatraQueryLoggingUtil;
import org.eclipse.viatra.query.tooling.localsearch.ui.debugger.LocalSearchDebugger;
import org.eclipse.viatra.query.tooling.localsearch.ui.debugger.provider.FrameViewerContentProvider;
import org.eclipse.viatra.query.tooling.localsearch.ui.debugger.provider.MatchesTableLabelProvider;
import org.eclipse.viatra.query.tooling.localsearch.ui.debugger.provider.OperationListContentProvider;
import org.eclipse.viatra.query.tooling.localsearch.ui.debugger.provider.OperationListLabelProvider;
import org.eclipse.viatra.query.tooling.localsearch.ui.debugger.provider.viewelement.IPlanNode;

public class LocalSearchDebugView
extends ViewPart {
    public static final String ID = "org.eclipse.viatra.query.tooling.localsearch.ui.LocalSearchDebugView";
    public static final String VIEWER_KEY = "key";
    private OperationListContentProvider operationListContentProvider;
    private TreeViewer operationListViewer;
    private ZestContentViewer graphViewer;
    private CTabFolder matchesTabFolder;
    private Map<PQuery, CTabItem> matchesTabIndex = new HashMap<PQuery, CTabItem>();
    private Map<String, TableViewer> matchViewersMap = new HashMap<String, TableViewer>();
    private LocalSearchDebugger debugger;
    private Thread planExecutorThread = null;
    private LocalSearchBackend localSearchBackend;

    public void createDebugger(AdvancedViatraQueryEngine engine, IQuerySpecification<?> query, Object[] adornment) {
        this.disposeExistingDebugger();
        this.initializeDebugger(engine, query, adornment);
        this.closeMatchTabs();
    }

    private String getSimpleQueryName(PQuery query) {
        String[] stringTokens = query.getFullyQualifiedName().split("\\.");
        String queryName = stringTokens[stringTokens.length - 1];
        return queryName;
    }

    private void initializeDebugger(AdvancedViatraQueryEngine engine, IQuerySpecification<?> specification, Object[] adornment) {
        IQueryBackend lsBackend = engine.getQueryBackend((IQueryBackendFactory)LocalSearchEMFBackendFactory.INSTANCE);
        LocalSearchResultProvider lsResultProvider = (LocalSearchResultProvider)lsBackend.getResultProvider(specification.getInternalQueryRepresentation());
        this.localSearchBackend = (LocalSearchBackend)lsBackend;
        this.debugger = new LocalSearchDebugger(this, engine, specification, adornment);
        this.localSearchBackend.addAdapter((ILocalSearchAdapter)this.debugger);
        this.operationListViewer.setInput((Object)this.debugger.getViewModel());
        this.operationListViewer.refresh();
        Runnable planExecutorRunnable = () -> {
            Iterator tuples = lsResultProvider.getAllMatches(adornment).iterator();
            while (!Thread.currentThread().isInterrupted() && tuples.hasNext()) {
            }
        };
        if (this.planExecutorThread != null && this.planExecutorThread.isAlive()) {
            this.planExecutorThread.interrupt();
            this.planExecutorThread.stop();
        }
        this.planExecutorThread = new Thread(planExecutorRunnable);
        this.planExecutorThread.start();
        IEvaluationService service = (IEvaluationService)this.getSite().getService(IEvaluationService.class);
        service.requestEvaluation("org.eclipse.viatra.query.tooling.localsearch.ui.debugger.operational");
    }

    public LocalSearchDebugger getDebugger() {
        return this.debugger;
    }

    public CTabFolder getMatchesTabFolder() {
        return this.matchesTabFolder;
    }

    public void createPartControl(Composite parent) {
        parent.setLayoutData((Object)new FillLayout());
        SashForm sashForm = new SashForm(parent, 256);
        SashForm planSashForm = new SashForm((Composite)sashForm, 512);
        this.createTreeViewer(planSashForm);
        this.matchesTabFolder = new CTabFolder((Composite)planSashForm, 66);
        this.createZestViewer(sashForm);
    }

    public void recreateColumns(List<String> colNames, int keySize, TableViewer matchesViewer) {
        TableColumn[] columns;
        TableColumn[] tableColumnArray = columns = matchesViewer.getTable().getColumns();
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn tableColumn = tableColumnArray[n2];
            tableColumn.dispose();
            ++n2;
        }
        int i = 0;
        while (i < colNames.size()) {
            TableViewerColumn col = this.createTableViewerColumn(colNames.get(i), 100, i, matchesViewer);
            col.setLabelProvider((CellLabelProvider)new MatchesTableLabelProvider(i, i < keySize, matchesViewer));
            ++i;
        }
    }

    private TableViewerColumn createTableViewerColumn(String title, int bound, int colNumber, TableViewer matchesViewer) {
        TableViewerColumn viewerColumn = new TableViewerColumn(matchesViewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(bound);
        column.setResizable(true);
        column.setMoveable(true);
        return viewerColumn;
    }

    private void createZestViewer(SashForm sashForm) {
        this.graphViewer = new ModifiableZestContentViewer();
        this.graphViewer.createControl((Composite)sashForm, 2048);
        FrameViewerContentProvider zestContentProvider = new FrameViewerContentProvider();
        this.graphViewer.setContentProvider((IContentProvider)zestContentProvider);
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        AdapterFactoryLabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory);
        this.graphViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        ILayoutAlgorithm layout = this.getLayout();
        this.graphViewer.setLayoutAlgorithm(layout);
    }

    private void createTreeViewer(SashForm sashForm) {
        this.operationListViewer = new TreeViewer((Composite)sashForm, 2818);
        this.operationListContentProvider = new OperationListContentProvider();
        this.operationListViewer.setContentProvider((IContentProvider)this.operationListContentProvider);
        this.operationListViewer.setLabelProvider((IBaseLabelProvider)new OperationListLabelProvider());
        this.operationListViewer.addDoubleClickListener(event -> {
            IStructuredSelection thisSelection = (IStructuredSelection)event.getSelection();
            try {
                IWorkbenchPartSite site = this.getSite();
                HashMap eventContextParameters = Maps.newHashMap();
                eventContextParameters.put("activeWorkbenchWindow", site.getWorkbenchWindow());
                eventContextParameters.put("activePart", this);
                eventContextParameters.put("activePartId", ID);
                eventContextParameters.put("selection", thisSelection);
                ICommandService commandService = (ICommandService)site.getService(ICommandService.class);
                commandService.getCommand("org.eclipse.viatra.query.tooling.localsearch.ui.debugger.localsearch.placebreakpoint").executeWithChecks(new ExecutionEvent(null, (Map)eventContextParameters, null, null));
            }
            catch (ExecutionException | NotEnabledException | NotHandledException | NotDefinedException e) {
                ViatraQueryLoggingUtil.getLogger(((Object)((Object)this)).getClass()).error((Object)"Error setting up breakpoint", e);
            }
        });
    }

    private ILayoutAlgorithm getLayout() {
        TreeLayoutAlgorithm layout = new TreeLayoutAlgorithm();
        return layout;
    }

    public void setFocus() {
        this.operationListViewer.getControl().setFocus();
    }

    public void refreshView(PQuery currentQuery, IPlanNode currentNode) {
        this.getViewSite().getShell().getDisplay().syncExec(() -> {
            this.operationListViewer.refresh();
            this.graphViewer.refresh();
            if (currentNode != null) {
                this.operationListViewer.expandToLevel((Object)currentNode, 0);
                this.operationListViewer.reveal((Object)currentNode);
            }
            Collection<TableViewer> tableViewers = this.matchViewersMap.values();
            for (TableViewer tableViewer : tableViewers) {
                tableViewer.refresh();
            }
            this.selectMatchTab(currentQuery);
        });
        IEvaluationService service = (IEvaluationService)this.getSite().getService(IEvaluationService.class);
        service.requestEvaluation("org.eclipse.viatra.query.tooling.localsearch.ui.debugger.operational");
    }

    public TreeViewer getOperationListViewer() {
        return this.operationListViewer;
    }

    public ZestContentViewer getGraphViewer() {
        return this.graphViewer;
    }

    public TableViewer getMatchesViewer(PQuery query) {
        String queryName = this.getSimpleQueryName(query);
        TableViewer viewer = this.matchViewersMap.get(queryName);
        if (viewer == null) {
            this.getOrCreateMatchesTab(query);
        }
        return this.matchViewersMap.get(queryName);
    }

    public void selectMatchTab(PQuery query) {
        this.getMatchesTabFolder().setSelection(this.matchesTabIndex.get(query));
    }

    private void getOrCreateMatchesTab(PQuery query) {
        String tabTitle = this.getSimpleQueryName(query);
        this.getViewSite().getShell().getDisplay().syncExec(() -> {
            CTabItem item = new CTabItem(this.getMatchesTabFolder(), 0);
            item.setText(tabTitle);
            this.getMatchesTabFolder().setSelection(item);
            this.matchesTabIndex.put(query, item);
            Composite container = new Composite((Composite)this.getMatchesTabFolder(), 0);
            container.setLayout((Layout)new FillLayout());
            TableViewer viewer = this.createTableViewer(container);
            viewer.addSelectionChangedListener(event -> {
                if (event.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    MatchingFrame frame = (MatchingFrame)selection.getFirstElement();
                    this.graphViewer.setInput((Object)frame);
                    this.graphViewer.refresh();
                }
            });
            this.matchViewersMap.put(tabTitle, viewer);
            viewer.refresh();
            ArrayList matchViewerInput = new ArrayList();
            viewer.setData(VIEWER_KEY, matchViewerInput);
            viewer.setInput(matchViewerInput);
            item.setControl((Control)container);
            item.addListener(4, event -> viewer.setSelection(null));
            item.addListener(15, event -> viewer.setSelection(null));
        });
    }

    private TableViewer createTableViewer(Composite parent) {
        TableViewer matchesViewer = new TableViewer(parent, 68354);
        matchesViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        matchesViewer.getControl().setLayoutData((Object)gridData);
        Table table = matchesViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        return matchesViewer;
    }

    public void dispose() {
        this.disposeExistingDebugger();
        super.dispose();
    }

    private void disposeExistingDebugger() {
        if (this.debugger != null) {
            this.localSearchBackend.removeAdapter((ILocalSearchAdapter)this.debugger);
            this.debugger.dispose();
            this.debugger = null;
        }
    }

    private void closeMatchTabs() {
        CTabItem[] cTabItemArray = this.getMatchesTabFolder().getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem item = cTabItemArray[n2];
            item.dispose();
            ++n2;
        }
        this.matchViewersMap.clear();
        this.matchesTabIndex.clear();
    }
}

