/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.xml.model.clipboard;

import com.google.common.collect.Maps;
import java.util.Map;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;
import org.eclipse.wb.internal.core.xml.model.clipboard.ClipboardCommand;
import org.eclipse.wb.internal.core.xml.model.clipboard.IClipboardObjectProperty;
import org.eclipse.wb.internal.core.xml.model.property.GenericProperty;
import org.eclipse.wb.internal.core.xml.model.property.GenericPropertyImpl;

public final class PropertiesClipboardCommand
extends ClipboardCommand {
    private static final long serialVersionUID = 0L;
    private final Map<String, String> m_propertyTitleToSource = Maps.newTreeMap();
    private final Map<String, Object> m_propertyTitleToObject = Maps.newTreeMap();

    public PropertiesClipboardCommand(XmlObjectInfo object) throws Exception {
        Property[] propertyArray = object.getProperties();
        int n = propertyArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClipboardObjectProperty objectProperty;
            Object value;
            GenericPropertyImpl genericProperty;
            String clipboardSource;
            Property property = propertyArray[n2];
            String title = property.getTitle();
            if (property instanceof GenericProperty && property.isModified() && (clipboardSource = (genericProperty = (GenericPropertyImpl)property).getClipboardSource()) != null) {
                this.m_propertyTitleToSource.put(title, clipboardSource);
            }
            if (property instanceof IClipboardObjectProperty && (value = (objectProperty = (IClipboardObjectProperty)property).getClipboardObject()) != Property.UNKNOWN_VALUE) {
                this.m_propertyTitleToObject.put(title, value);
            }
            ++n2;
        }
    }

    public void execute(XmlObjectInfo object) throws Exception {
        Property[] propertyArray = object.getProperties();
        int n = propertyArray.length;
        int n2 = 0;
        while (n2 < n) {
            Property property = propertyArray[n2];
            String title = property.getTitle();
            if (property instanceof GenericPropertyImpl) {
                GenericPropertyImpl genericProperty = (GenericPropertyImpl)property;
                String clipboardSource = this.m_propertyTitleToSource.get(title);
                if (clipboardSource != null) {
                    genericProperty.setExpression(clipboardSource, Property.UNKNOWN_VALUE);
                }
            }
            if (property instanceof IClipboardObjectProperty) {
                IClipboardObjectProperty objectProperty = (IClipboardObjectProperty)property;
                Object value = this.m_propertyTitleToObject.get(title);
                if (value != null) {
                    objectProperty.setClipboardObject(value);
                }
            }
            ++n2;
        }
    }
}

