/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.xml.model.property.accessor;

import java.lang.reflect.Field;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.accessor.AccessorUtils;
import org.eclipse.wb.internal.core.model.property.table.PropertyTooltipProvider;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.xml.DocumentElement;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;
import org.eclipse.wb.internal.core.xml.model.property.accessor.ExpressionAccessor;
import org.eclipse.wb.internal.core.xml.model.utils.XmlObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FieldExpressionAccessor
extends ExpressionAccessor {
    private final Field m_field;
    private final PropertyTooltipProvider m_tooltipProvider;

    public FieldExpressionAccessor(Field field) {
        super(field.getName());
        this.m_field = field;
        this.m_tooltipProvider = AccessorUtils.PropertyTooltipProvider_forField((Field)field);
    }

    @Override
    public Object getDefaultValue(XmlObjectInfo object) throws Exception {
        if (XmlObjectUtils.isImplicit(object) && object.getParent() instanceof XmlObjectInfo) {
            XmlObjectInfo xmlParent = (XmlObjectInfo)object.getParent();
            DocumentElement objectElement = this.getExistingElement(object);
            if (objectElement == this.getExistingElement(xmlParent)) {
                return Property.UNKNOWN_VALUE;
            }
        }
        return object.getArbitraryValue(this);
    }

    @Override
    public void visit(XmlObjectInfo object, int state) throws Exception {
        super.visit(object, state);
        if (state == 1) {
            Object toolkitObject = object.getObject();
            Object value = ReflectionUtils.getFieldObject((Object)toolkitObject, (String)this.m_field.getName());
            object.putArbitraryValue(this, value);
        }
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == PropertyTooltipProvider.class) {
            return adapter.cast(this.m_tooltipProvider);
        }
        return super.getAdapter(adapter);
    }

    public Field getField() {
        return this.m_field;
    }
}

