/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.snippets.internal.util;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.wst.common.snippets.internal.Logger;

public class VisibilityUtil {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isContentType(IEditorInput input, String[] filterContentTypes) {
        boolean isMatch = false;
        if (filterContentTypes == null) return true;
        if (filterContentTypes.length == 0) {
            return true;
        }
        if (filterContentTypes.length < 1) return isMatch;
        String firstFilter = filterContentTypes[0];
        if (firstFilter.compareTo("*") == 0) {
            return true;
        }
        if (firstFilter.compareTo("!") == 0) {
            return false;
        }
        if (firstFilter.compareTo("-") == 0) {
            return false;
        }
        isMatch = false;
        InputStream contents = null;
        IContentDescription contentDesc = null;
        try {
            IContentType currentContentType;
            Object resource;
            IFile file = (IFile)input.getAdapter(IFile.class);
            if (file == null && (resource = input.getAdapter(IResource.class)) instanceof IFile) {
                file = (IFile)resource;
            }
            if (file != null && (contentDesc = file.getContentDescription()) == null) {
                contents = file.getContents();
                contentDesc = Platform.getContentTypeManager().getDescriptionFor(contents, input.getName(), null);
                if (contents != null) {
                    try {
                        contents.close();
                        contents = null;
                    }
                    catch (IOException iOException) {}
                }
            }
            boolean findByname = true;
            if (contentDesc != null && (currentContentType = contentDesc.getContentType()) != null) {
                findByname = false;
                int i = 0;
                while (i < filterContentTypes.length) {
                    IContentType contentType = Platform.getContentTypeManager().getContentType(filterContentTypes[i]);
                    if (contentType != null && currentContentType.isKindOf(contentType)) {
                        isMatch = true;
                        break;
                    }
                    ++i;
                }
            }
            if (findByname) {
                IWorkbenchAdapter adapter;
                IContentType[] contentTypes = Platform.getContentTypeManager().findContentTypesFor(input.getName());
                if ((contentTypes == null || contentTypes.length == 0) && (adapter = (IWorkbenchAdapter)input.getAdapter(IWorkbenchAdapter.class)) != null) {
                    contentTypes = Platform.getContentTypeManager().findContentTypesFor(adapter.getLabel((Object)input));
                }
                int j = 0;
                while (j < contentTypes.length) {
                    int i = 0;
                    while (i < filterContentTypes.length) {
                        String filterContentTypeName = filterContentTypes[i];
                        IContentType filterContentType = Platform.getContentTypeManager().getContentType(filterContentTypeName);
                        if (filterContentType != null && contentTypes[j].isKindOf(filterContentType)) {
                            isMatch = true;
                            break;
                        }
                        ++i;
                    }
                    ++j;
                }
            }
        }
        catch (IOException e) {
            Logger.logException(e);
            if (contents == null) return isMatch;
            try {
                contents.close();
                return isMatch;
            }
            catch (IOException iOException) {}
            return isMatch;
        }
        catch (CoreException e) {
            try {
                Logger.logException(e);
                if (contents == null) return isMatch;
            }
            catch (Throwable throwable) {
                if (contents == null) throw throwable;
                try {
                    contents.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                contents.close();
                return isMatch;
            }
            catch (IOException iOException) {}
            return isMatch;
        }
        if (contents == null) return isMatch;
        try {
            contents.close();
            return isMatch;
        }
        catch (IOException iOException) {}
        return isMatch;
    }
}

