/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.metamodel.util;

import java.util.Iterator;
import java.util.Stack;
import org.eclipse.wst.css.core.internal.metamodel.CSSMMNode;

public abstract class CSSMetaModelTraverser {
    Stack fTravStack = null;
    protected static final short TRAV_CONT = 0;
    protected static final short TRAV_STOP = 1;
    protected static final short TRAV_PRUNE = 2;

    public final void apply(CSSMMNode node) {
        this.fTravStack = new Stack();
        this.begin(node);
        this.traverse(node);
        this.end(node);
    }

    private final short traverse(CSSMMNode node) {
        if (node == null) {
            return 0;
        }
        this.fTravStack.push(node);
        short rc = this.preNode(node);
        if (rc == 0) {
            Iterator i = node.getChildNodes();
            while (i.hasNext()) {
                CSSMMNode child = (CSSMMNode)i.next();
                short rcChild = this.traverse(child);
                if (rcChild != 1) continue;
                this.fTravStack.pop();
                return 1;
            }
        } else if (rc == 1) {
            this.fTravStack.pop();
            return 1;
        }
        rc = this.postNode(node);
        this.fTravStack.pop();
        return rc == 2 ? (short)0 : rc;
    }

    protected void begin(CSSMMNode node) {
    }

    protected void end(CSSMMNode node) {
    }

    protected short preNode(CSSMMNode node) {
        return 0;
    }

    protected short postNode(CSSMMNode node) {
        return 0;
    }
}

