/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.v8native;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.wst.jsdt.chromium.internal.v8native.DebugSession;
import org.eclipse.wst.jsdt.chromium.internal.v8native.DebuggerCommand;
import org.eclipse.wst.jsdt.chromium.internal.v8native.processor.AfterCompileProcessor;
import org.eclipse.wst.jsdt.chromium.internal.v8native.processor.BreakpointProcessor;
import org.eclipse.wst.jsdt.chromium.internal.v8native.processor.ScriptCollectedProcessor;
import org.eclipse.wst.jsdt.chromium.internal.v8native.processor.V8EventProcessor;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.EventNotification;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.IncomingMessage;

public class DefaultResponseHandler {
    private static final Logger LOGGER = Logger.getLogger(DefaultResponseHandler.class.getName());
    private final BreakpointProcessor bpp;
    private final AfterCompileProcessor afterCompileProcessor;
    private final ScriptCollectedProcessor scriptCollectedProcessor;
    private static final Map<DebuggerCommand, ProcessorGetter> command2EventProcessorGetter = new HashMap<DebuggerCommand, ProcessorGetter>();

    static {
        ProcessorGetter bppGetter = new ProcessorGetter(){

            @Override
            BreakpointProcessor get(DefaultResponseHandler instance) {
                return instance.bpp;
            }
        };
        command2EventProcessorGetter.put(DebuggerCommand.BREAK, bppGetter);
        command2EventProcessorGetter.put(DebuggerCommand.EXCEPTION, bppGetter);
        command2EventProcessorGetter.put(DebuggerCommand.AFTER_COMPILE, new ProcessorGetter(){

            @Override
            AfterCompileProcessor get(DefaultResponseHandler instance) {
                return instance.afterCompileProcessor;
            }
        });
        command2EventProcessorGetter.put(DebuggerCommand.SCRIPT_COLLECTED, new ProcessorGetter(){

            @Override
            ScriptCollectedProcessor get(DefaultResponseHandler instance) {
                return instance.scriptCollectedProcessor;
            }
        });
    }

    public DefaultResponseHandler(DebugSession debugSession) {
        this.bpp = new BreakpointProcessor(debugSession);
        this.afterCompileProcessor = new AfterCompileProcessor(debugSession);
        this.scriptCollectedProcessor = new ScriptCollectedProcessor(debugSession);
    }

    public BreakpointProcessor getBreakpointProcessor() {
        return this.bpp;
    }

    public void handleResponseWithHandler(IncomingMessage response) {
        EventNotification eventResponse = response.asEventNotification();
        if (eventResponse == null) {
            return;
        }
        String commandString = eventResponse.event();
        DebuggerCommand command = DebuggerCommand.forString(commandString);
        if (command == null) {
            LOGGER.log(Level.WARNING, "Unknown command in V8 debugger reply JSON: {0}", commandString);
            return;
        }
        ProcessorGetter handlerGetter = command2EventProcessorGetter.get((Object)command);
        if (handlerGetter == null) {
            return;
        }
        handlerGetter.get(this).messageReceived(eventResponse);
    }

    private static abstract class ProcessorGetter {
        private ProcessorGetter() {
        }

        abstract V8EventProcessor get(DefaultResponseHandler var1);
    }
}

