/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.dom;

import com.google.common.collect.UnmodifiableIterator;
import com.google.javascript.jscomp.parsing.parser.IdentifierToken;
import com.google.javascript.jscomp.parsing.parser.Token;
import com.google.javascript.jscomp.parsing.parser.TokenType;
import com.google.javascript.jscomp.parsing.parser.trees.ArrayLiteralExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ArrayPatternTree;
import com.google.javascript.jscomp.parsing.parser.trees.AssignmentRestElementTree;
import com.google.javascript.jscomp.parsing.parser.trees.BinaryOperatorTree;
import com.google.javascript.jscomp.parsing.parser.trees.BlockTree;
import com.google.javascript.jscomp.parsing.parser.trees.BreakStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.CallExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.CaseClauseTree;
import com.google.javascript.jscomp.parsing.parser.trees.CatchTree;
import com.google.javascript.jscomp.parsing.parser.trees.ClassDeclarationTree;
import com.google.javascript.jscomp.parsing.parser.trees.CommaExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.Comment;
import com.google.javascript.jscomp.parsing.parser.trees.ComputedPropertyDefinitionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ComputedPropertyGetterTree;
import com.google.javascript.jscomp.parsing.parser.trees.ComputedPropertyMemberVariableTree;
import com.google.javascript.jscomp.parsing.parser.trees.ComputedPropertyMethodTree;
import com.google.javascript.jscomp.parsing.parser.trees.ComputedPropertySetterTree;
import com.google.javascript.jscomp.parsing.parser.trees.ConditionalExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ContinueStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.DebuggerStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.DefaultClauseTree;
import com.google.javascript.jscomp.parsing.parser.trees.DefaultParameterTree;
import com.google.javascript.jscomp.parsing.parser.trees.DoWhileStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.EmptyStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.ExportDeclarationTree;
import com.google.javascript.jscomp.parsing.parser.trees.ExportSpecifierTree;
import com.google.javascript.jscomp.parsing.parser.trees.ExpressionStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.ForInStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.ForOfStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.ForStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.FunctionDeclarationTree;
import com.google.javascript.jscomp.parsing.parser.trees.GetAccessorTree;
import com.google.javascript.jscomp.parsing.parser.trees.IdentifierExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.IfStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.ImportDeclarationTree;
import com.google.javascript.jscomp.parsing.parser.trees.ImportSpecifierTree;
import com.google.javascript.jscomp.parsing.parser.trees.LabelledStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.LiteralExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.MemberExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.MemberLookupExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ModuleImportTree;
import com.google.javascript.jscomp.parsing.parser.trees.NewExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.NullTree;
import com.google.javascript.jscomp.parsing.parser.trees.ObjectLiteralExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ObjectPatternTree;
import com.google.javascript.jscomp.parsing.parser.trees.ParenExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ParseTree;
import com.google.javascript.jscomp.parsing.parser.trees.ParseTreeType;
import com.google.javascript.jscomp.parsing.parser.trees.PostfixExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ProgramTree;
import com.google.javascript.jscomp.parsing.parser.trees.PropertyNameAssignmentTree;
import com.google.javascript.jscomp.parsing.parser.trees.RestParameterTree;
import com.google.javascript.jscomp.parsing.parser.trees.ReturnStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.SetAccessorTree;
import com.google.javascript.jscomp.parsing.parser.trees.SpreadExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.SuperExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.SwitchStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.TemplateLiteralExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.TemplateLiteralPortionTree;
import com.google.javascript.jscomp.parsing.parser.trees.TemplateSubstitutionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ThisExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ThrowStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.TryStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.TypeNameTree;
import com.google.javascript.jscomp.parsing.parser.trees.UnaryExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.VariableDeclarationListTree;
import com.google.javascript.jscomp.parsing.parser.trees.VariableDeclarationTree;
import com.google.javascript.jscomp.parsing.parser.trees.VariableStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.WhileStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.WithStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.YieldExpressionTree;
import com.google.javascript.jscomp.parsing.parser.util.SourceRange;
import java.util.Iterator;
import java.util.List;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ArrayAccess;
import org.eclipse.wst.jsdt.core.dom.ArrayInitializer;
import org.eclipse.wst.jsdt.core.dom.ArrayName;
import org.eclipse.wst.jsdt.core.dom.ArrowFunctionExpression;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.BooleanLiteral;
import org.eclipse.wst.jsdt.core.dom.BreakStatement;
import org.eclipse.wst.jsdt.core.dom.CatchClause;
import org.eclipse.wst.jsdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.ConditionalExpression;
import org.eclipse.wst.jsdt.core.dom.ContinueStatement;
import org.eclipse.wst.jsdt.core.dom.DoStatement;
import org.eclipse.wst.jsdt.core.dom.EmptyStatement;
import org.eclipse.wst.jsdt.core.dom.ExportDeclaration;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.ExpressionStatement;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.ForInStatement;
import org.eclipse.wst.jsdt.core.dom.ForOfStatement;
import org.eclipse.wst.jsdt.core.dom.ForStatement;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionExpression;
import org.eclipse.wst.jsdt.core.dom.FunctionInvocation;
import org.eclipse.wst.jsdt.core.dom.IfStatement;
import org.eclipse.wst.jsdt.core.dom.ImportDeclaration;
import org.eclipse.wst.jsdt.core.dom.InfixExpression;
import org.eclipse.wst.jsdt.core.dom.JSdoc;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.LabeledStatement;
import org.eclipse.wst.jsdt.core.dom.ListExpression;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.ModuleSpecifier;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.NullLiteral;
import org.eclipse.wst.jsdt.core.dom.NumberLiteral;
import org.eclipse.wst.jsdt.core.dom.ObjectLiteral;
import org.eclipse.wst.jsdt.core.dom.ObjectLiteralField;
import org.eclipse.wst.jsdt.core.dom.ObjectName;
import org.eclipse.wst.jsdt.core.dom.ParenthesizedExpression;
import org.eclipse.wst.jsdt.core.dom.PostfixExpression;
import org.eclipse.wst.jsdt.core.dom.PrefixExpression;
import org.eclipse.wst.jsdt.core.dom.RegularExpressionLiteral;
import org.eclipse.wst.jsdt.core.dom.RestElementName;
import org.eclipse.wst.jsdt.core.dom.ReturnStatement;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SimplePropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.SpreadElement;
import org.eclipse.wst.jsdt.core.dom.Statement;
import org.eclipse.wst.jsdt.core.dom.StringLiteral;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.SwitchCase;
import org.eclipse.wst.jsdt.core.dom.SwitchStatement;
import org.eclipse.wst.jsdt.core.dom.TemplateElement;
import org.eclipse.wst.jsdt.core.dom.TemplateLiteral;
import org.eclipse.wst.jsdt.core.dom.ThrowStatement;
import org.eclipse.wst.jsdt.core.dom.TryStatement;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.VariableKind;
import org.eclipse.wst.jsdt.core.dom.WhileStatement;
import org.eclipse.wst.jsdt.core.dom.WithStatement;
import org.eclipse.wst.jsdt.core.dom.YieldExpression;

public class ClosureCompilerASTConverter {
    private static final String KEYWORD_SUPER = "super";
    private static final boolean DEBUG = false;
    private final AST ast;
    private final List<Comment> comments;
    private Comment currentComment;
    private final Iterator<Comment> nextCommentIter;

    public ClosureCompilerASTConverter(AST t, List<Comment> comment) {
        this.ast = t;
        this.comments = comment;
        this.nextCommentIter = this.comments.iterator();
        this.currentComment = this.nextCommentIter.hasNext() ? this.nextCommentIter.next() : null;
    }

    public ASTNode transform(StructuralPropertyDescriptor property, ParseTree tree) {
        if (tree == null) {
            return null;
        }
        ASTNode node = this.process(property, tree);
        if (node == null) {
            return null;
        }
        this.setSourceRange(node, tree);
        return node;
    }

    private <T extends ASTNode> void attachJSDoc(ParseTree tree, BodyDeclaration node) {
        Comment info = this.handleJsDoc(tree);
        if (info != null && info.isJsDoc()) {
            JSdoc doc = this.ast.newJSdoc();
            doc.setComment(info.value);
            doc.setSourceRange(info.location.start.offset, info.location.end.offset - info.location.start.offset);
            node.setJavadoc(doc);
        }
    }

    private <T extends ASTNode> void attachJSDoc(ParseTree tree, VariableDeclarationStatement node) {
        Comment info = this.handleJsDoc(tree);
        if (info != null && info.isJsDoc()) {
            JSdoc doc = this.ast.newJSdoc();
            doc.setComment(info.value);
            doc.setSourceRange(info.location.start.offset, info.location.end.offset - info.location.start.offset);
            node.setJavadoc(doc);
        }
    }

    private InfixExpression.Operator convertBinaryOperator(Token operator) {
        return InfixExpression.Operator.toOperator(operator.toString());
    }

    private VariableKind convertVariableKind(TokenType token) {
        switch (token) {
            case LET: {
                return VariableKind.LET;
            }
            case CONST: {
                return VariableKind.CONST;
            }
        }
        return VariableKind.VAR;
    }

    private boolean notNullStatement(ParseTree tree) {
        return tree.type != ParseTreeType.NULL;
    }

    private ASTNode process(StructuralPropertyDescriptor property, ParseTree node) {
        switch (node.type) {
            case BINARY_OPERATOR: {
                return this.processBinaryExpression(node.asBinaryOperator());
            }
            case ARRAY_LITERAL_EXPRESSION: {
                return this.processArrayLiteral(node.asArrayLiteralExpression());
            }
            case TEMPLATE_LITERAL_EXPRESSION: {
                return this.processTemplateLiteral(node.asTemplateLiteralExpression());
            }
            case TEMPLATE_LITERAL_PORTION: {
                return this.processTemplateLiteralPortion(node.asTemplateLiteralPortion());
            }
            case TEMPLATE_SUBSTITUTION: {
                return this.processTemplateSubstitution(node.asTemplateSubstitution());
            }
            case UNARY_EXPRESSION: {
                return this.processUnaryExpression(node.asUnaryExpression());
            }
            case BLOCK: {
                return this.processBlock(node.asBlock());
            }
            case BREAK_STATEMENT: {
                return this.processBreakStatement(node.asBreakStatement());
            }
            case CALL_EXPRESSION: {
                return this.processFunctionCall(node.asCallExpression());
            }
            case SWITCH_STATEMENT: {
                return this.processSwitchStatement(node.asSwitchStatement());
            }
            case CASE_CLAUSE: {
                return this.processSwitchCase(node.asCaseClause());
            }
            case DEFAULT_CLAUSE: {
                return this.processSwitchDefault(node.asDefaultClause());
            }
            case CATCH: {
                return this.processCatchClause(node.asCatch());
            }
            case CONTINUE_STATEMENT: {
                return this.processContinueStatement(node.asContinueStatement());
            }
            case DO_WHILE_STATEMENT: {
                return this.processDoLoop(node.asDoWhileStatement());
            }
            case EMPTY_STATEMENT: {
                return this.processEmptyStatement(node.asEmptyStatement());
            }
            case EXPRESSION_STATEMENT: {
                return this.processExpressionStatement(node.asExpressionStatement());
            }
            case DEBUGGER_STATEMENT: {
                return this.processDebuggerStatement(node.asDebuggerStatement());
            }
            case THIS_EXPRESSION: {
                return this.processThisExpression(node.asThisExpression());
            }
            case FOR_STATEMENT: {
                return this.processForLoop(node.asForStatement());
            }
            case FOR_IN_STATEMENT: {
                return this.processForInLoop(node.asForInStatement());
            }
            case FUNCTION_DECLARATION: {
                return this.processFunction(property, node.asFunctionDeclaration());
            }
            case MEMBER_LOOKUP_EXPRESSION: {
                return this.processElementGet(node.asMemberLookupExpression());
            }
            case MEMBER_EXPRESSION: {
                return this.processPropertyGet(property, node.asMemberExpression());
            }
            case CONDITIONAL_EXPRESSION: {
                return this.processConditionalExpression(node.asConditionalExpression());
            }
            case IF_STATEMENT: {
                return this.processIfStatement(node.asIfStatement());
            }
            case LABELLED_STATEMENT: {
                return this.processLabeledStatement(node.asLabelledStatement());
            }
            case PAREN_EXPRESSION: {
                return this.processParenthesizedExpression(node.asParenExpression());
            }
            case IDENTIFIER_EXPRESSION: {
                return this.processName(property, node.asIdentifierExpression());
            }
            case NEW_EXPRESSION: {
                return this.processNewExpression(node.asNewExpression());
            }
            case OBJECT_LITERAL_EXPRESSION: {
                return this.processObjectLiteral(node.asObjectLiteralExpression());
            }
            case COMPUTED_PROPERTY_GETTER: {
                return this.processComputedPropertyGetter(property, node.asComputedPropertyGetter());
            }
            case COMPUTED_PROPERTY_SETTER: {
                return this.processComputedPropertySetter(property, node.asComputedPropertySetter());
            }
            case COMPUTED_PROPERTY_METHOD: {
                return this.processComputedPropertyMethod(property, node.asComputedPropertyMethod());
            }
            case COMPUTED_PROPERTY_DEFINITION: 
            case COMPUTED_PROPERTY_MEMBER_VARIABLE: {
                return null;
            }
            case RETURN_STATEMENT: {
                return this.processReturnStatement(node.asReturnStatement());
            }
            case POSTFIX_EXPRESSION: {
                return this.processPostfixExpression(node.asPostfixExpression());
            }
            case PROGRAM: {
                return this.processAstRoot(node.asProgram());
            }
            case LITERAL_EXPRESSION: {
                return this.processLiteralExpression(node.asLiteralExpression());
            }
            case THROW_STATEMENT: {
                return this.processThrowStatement(node.asThrowStatement());
            }
            case TRY_STATEMENT: {
                return this.processTryStatement(node.asTryStatement());
            }
            case VARIABLE_STATEMENT: {
                return this.processVariableStatement(node.asVariableStatement());
            }
            case VARIABLE_DECLARATION_LIST: {
                return this.processVariableDeclarationList(node.asVariableDeclarationList());
            }
            case VARIABLE_DECLARATION: {
                return this.processVariableDeclaration(node.asVariableDeclaration());
            }
            case WHILE_STATEMENT: {
                return this.processWhileLoop(node.asWhileStatement());
            }
            case WITH_STATEMENT: {
                return this.processWithStatement(node.asWithStatement());
            }
            case COMMA_EXPRESSION: {
                return this.processCommaExpression(node.asCommaExpression());
            }
            case NULL: {
                return this.processNull(node.asNull());
            }
            case FINALLY: {
                return this.transform(property, node.asFinally().block);
            }
            case MISSING_PRIMARY_EXPRESSION: {
                return null;
            }
            case PROPERTY_NAME_ASSIGNMENT: {
                return this.processPropertyNameAssignment(node.asPropertyNameAssignment());
            }
            case GET_ACCESSOR: {
                return this.processGetAccessor(property, node.asGetAccessor());
            }
            case SET_ACCESSOR: {
                return this.processSetAccessor(property, node.asSetAccessor());
            }
            case FORMAL_PARAMETER_LIST: {
                return null;
            }
            case CLASS_DECLARATION: {
                return this.processClassDeclaration(property, node.asClassDeclaration());
            }
            case SUPER_EXPRESSION: {
                return this.processSuper(node.asSuperExpression());
            }
            case YIELD_EXPRESSION: {
                return this.processYield(node.asYieldStatement());
            }
            case FOR_OF_STATEMENT: {
                return this.processForOf(node.asForOfStatement());
            }
            case EXPORT_DECLARATION: {
                return this.processExportDecl(node.asExportDeclaration());
            }
            case EXPORT_SPECIFIER: {
                return this.processExportSpec(node.asExportSpecifier());
            }
            case IMPORT_DECLARATION: {
                return this.processImportDecl(node.asImportDeclaration());
            }
            case IMPORT_SPECIFIER: {
                return this.processImportSpec(node.asImportSpecifier());
            }
            case MODULE_IMPORT: {
                return this.processModuleImport(node.asModuleImport());
            }
            case ARRAY_PATTERN: {
                return this.processArrayPattern(property, node.asArrayPattern());
            }
            case OBJECT_PATTERN: {
                return this.processObjectPattern(property, node.asObjectPattern());
            }
            case ASSIGNMENT_REST_ELEMENT: {
                return this.processAssignmentRestElement(node.asAssignmentRestElement());
            }
            case DEFAULT_PARAMETER: {
                return this.processDefaultParameter(property, node.asDefaultParameter());
            }
            case REST_PARAMETER: {
                return this.processRestParameter(property, node.asRestParameter());
            }
            case SPREAD_EXPRESSION: {
                return this.processSpreadExpression(node.asSpreadExpression());
            }
            case TYPE_NAME: {
                return this.processTypeName(node.asTypeName());
            }
        }
        return this.processIllegalToken(node);
    }

    private ASTNode processComputedPropertyMethod(StructuralPropertyDescriptor property, ComputedPropertyMethodTree tree) {
        FunctionDeclaration $ = this.ast.newFunctionDeclaration();
        FunctionDeclarationTree methodTree = tree.method.asFunctionDeclaration();
        this.transformAndSetProperty($, FunctionDeclaration.BODY_PROPERTY, methodTree.functionBody);
        this.transformAndSetProperty($, FunctionDeclaration.METHOD_NAME_PROPERTY, tree.property);
        if (methodTree.isStatic) {
            $.modifiers().add(this.ast.newModifier(Modifier.ModifierKeyword.STATIC_KEYWORD));
        }
        return this.adjustFunctionDeclarationToProperty(property, $);
    }

    private ASTNode processComputedPropertySetter(StructuralPropertyDescriptor property, ComputedPropertySetterTree tree) {
        FunctionDeclaration $ = this.ast.newFunctionDeclaration();
        this.transformAndSetProperty($, FunctionDeclaration.BODY_PROPERTY, (ParseTree)tree.body);
        this.transformAndSetProperty($, FunctionDeclaration.METHOD_NAME_PROPERTY, tree.property);
        $.modifiers().add(this.ast.newModifier(Modifier.ModifierKeyword.SET_KEYWORD));
        if (tree.isStatic) {
            $.modifiers().add(this.ast.newModifier(Modifier.ModifierKeyword.STATIC_KEYWORD));
        }
        return this.adjustFunctionDeclarationToProperty(property, $);
    }

    private ASTNode processComputedPropertyGetter(StructuralPropertyDescriptor property, ComputedPropertyGetterTree tree) {
        FunctionDeclaration $ = this.ast.newFunctionDeclaration();
        this.transformAndSetProperty($, FunctionDeclaration.BODY_PROPERTY, (ParseTree)tree.body);
        this.transformAndSetProperty($, FunctionDeclaration.METHOD_NAME_PROPERTY, tree.property);
        $.modifiers().add(this.ast.newModifier(Modifier.ModifierKeyword.GET_KEYWORD));
        if (tree.isStatic) {
            $.modifiers().add(this.ast.newModifier(Modifier.ModifierKeyword.STATIC_KEYWORD));
        }
        return this.adjustFunctionDeclarationToProperty(property, $);
    }

    private ASTNode processArrayLiteral(ArrayLiteralExpressionTree tree) {
        ArrayInitializer $ = this.ast.newArrayInitializer();
        for (ParseTree pe : tree.elements) {
            if (!this.notNullStatement(pe)) continue;
            $.expressions().add(this.transform(ArrayInitializer.EXPRESSIONS_PROPERTY, pe));
        }
        return $;
    }

    private ASTNode processArrayPattern(StructuralPropertyDescriptor property, ArrayPatternTree tree) {
        ArrayName $ = this.ast.newArrayName();
        for (ParseTree child : tree.elements) {
            if (!this.notNullStatement(child)) continue;
            $.elements().add(this.transform(ArrayName.ELEMENTS_PROPERTY, child));
        }
        Class<SingleVariableDeclaration> claz = this.classForProperty(property);
        if (claz.isAssignableFrom(SingleVariableDeclaration.class)) {
            SingleVariableDeclaration svd = this.ast.newSingleVariableDeclaration();
            svd.setPattern($);
            return svd;
        }
        return $;
    }

    private ASTNode processAssignmentRestElement(AssignmentRestElementTree tree) {
        RestElementName $ = this.ast.newRestElementName();
        if (tree.identifier != null) {
            $.setArgument(this.transformLabelName(tree.identifier));
        }
        return $;
    }

    private ASTNode processAstRoot(ProgramTree tree) {
        JavaScriptUnit $ = this.ast.newJavaScriptUnit();
        for (ParseTree child : tree.sourceElements) {
            switch (child.type) {
                case EXPORT_DECLARATION: {
                    $.exports().add(this.transform(JavaScriptUnit.EXPORTS_PROPERTY, child));
                    break;
                }
                case IMPORT_DECLARATION: {
                    $.imports().add(this.transform(JavaScriptUnit.IMPORTS_PROPERTY, child));
                    break;
                }
                default: {
                    $.statements().add(this.transform(JavaScriptUnit.STATEMENTS_PROPERTY, child));
                }
            }
        }
        return $;
    }

    private ASTNode processBinaryExpression(BinaryOperatorTree tree) {
        Assignment.Operator assignOp = Assignment.Operator.toOperator(tree.operator.toString());
        if (assignOp != null) {
            Assignment $ = this.ast.newAssignment();
            this.safeSetProperty($, Assignment.OPERATOR_PROPERTY, assignOp);
            this.transformAndSetProperty($, Assignment.LEFT_HAND_SIDE_PROPERTY, tree.left);
            this.transformAndSetProperty($, Assignment.RIGHT_HAND_SIDE_PROPERTY, tree.right);
            return $;
        }
        InfixExpression $ = this.ast.newInfixExpression();
        this.safeSetProperty($, InfixExpression.OPERATOR_PROPERTY, this.convertBinaryOperator(tree.operator));
        this.transformAndSetProperty($, InfixExpression.LEFT_OPERAND_PROPERTY, tree.left);
        this.transformAndSetProperty($, InfixExpression.RIGHT_OPERAND_PROPERTY, tree.right);
        return $;
    }

    private ASTNode processBlock(BlockTree tree) {
        Block $ = this.ast.newBlock();
        for (ParseTree pt : tree.statements) {
            if (!this.notNullStatement(pt)) continue;
            $.statements().add(this.transform(Block.STATEMENTS_PROPERTY, pt));
        }
        return $;
    }

    private ASTNode processBreakStatement(BreakStatementTree tree) {
        BreakStatement $ = this.ast.newBreakStatement();
        if (tree.name != null) {
            $.setLabel(this.transformLabelName(tree.name));
        }
        return $;
    }

    private ASTNode processCatchClause(CatchTree tree) {
        CatchClause $ = this.ast.newCatchClause();
        this.transformAndSetProperty($, CatchClause.EXCEPTION_PROPERTY, tree.exception);
        this.transformAndSetProperty($, CatchClause.BODY_PROPERTY, tree.catchBody);
        return $;
    }

    private ASTNode processClassDeclaration(StructuralPropertyDescriptor property, ClassDeclarationTree tree) {
        TypeDeclaration $ = this.ast.newTypeDeclaration();
        if (tree.name != null) {
            $.setName(this.transformLabelName(tree.name));
        }
        this.transformAndSetProperty($, TypeDeclaration.SUPERCLASS_EXPRESSION_PROPERTY, tree.superClass);
        for (ParseTree child : tree.elements) {
            ASTNode declaration = this.transform(TypeDeclaration.BODY_DECLARATIONS_PROPERTY, child);
            if (declaration instanceof EmptyStatement) continue;
            $.bodyDeclarations().add(declaration);
        }
        this.attachJSDoc((ParseTree)tree, $);
        Class<ASTNode> claz = this.classForProperty(property);
        if (claz.isAssignableFrom(Expression.class)) {
            return this.ast.newTypeDeclarationExpression($);
        }
        if (claz.isAssignableFrom(Statement.class)) {
            return this.ast.newTypeDeclarationStatement($);
        }
        return $;
    }

    private ASTNode processCommaExpression(CommaExpressionTree tree) {
        ListExpression $ = this.ast.newListExpression();
        for (ParseTree expr : tree.expressions) {
            $.expressions().add(this.transform(ListExpression.EXPRESSIONS_PROPERTY, expr));
        }
        return $;
    }

    private ASTNode processConditionalExpression(ConditionalExpressionTree tree) {
        ConditionalExpression $ = this.ast.newConditionalExpression();
        this.transformAndSetProperty($, ConditionalExpression.EXPRESSION_PROPERTY, tree.condition);
        this.transformAndSetProperty($, ConditionalExpression.THEN_EXPRESSION_PROPERTY, tree.left);
        this.transformAndSetProperty($, ConditionalExpression.ELSE_EXPRESSION_PROPERTY, tree.right);
        return $;
    }

    private ASTNode processContinueStatement(ContinueStatementTree tree) {
        ContinueStatement $ = this.ast.newContinueStatement();
        if (tree.name != null) {
            $.setLabel(this.transformLabelName(tree.name));
        }
        return $;
    }

    private ASTNode processDebuggerStatement(DebuggerStatementTree tree) {
        return this.ast.newDebuggerStatement();
    }

    private ASTNode processDefaultParameter(StructuralPropertyDescriptor property, DefaultParameterTree tree) {
        return this.transform(property, tree.lhs);
    }

    private ASTNode processDoLoop(DoWhileStatementTree tree) {
        DoStatement $ = this.ast.newDoStatement();
        this.transformAndSetProperty($, DoStatement.EXPRESSION_PROPERTY, tree.condition);
        this.transformAndSetProperty($, DoStatement.BODY_PROPERTY, tree.body);
        return $;
    }

    private ASTNode processElementGet(MemberLookupExpressionTree tree) {
        ArrayAccess $ = this.ast.newArrayAccess();
        this.transformAndSetProperty($, ArrayAccess.INDEX_PROPERTY, tree.memberExpression);
        this.transformAndSetProperty($, ArrayAccess.ARRAY_PROPERTY, tree.operand);
        return $;
    }

    private ASTNode processEmptyStatement(EmptyStatementTree tree) {
        return this.ast.newEmptyStatement();
    }

    private ASTNode processExportDecl(ExportDeclarationTree tree) {
        ExportDeclaration $ = this.ast.newExportDeclaration();
        $.setAll(tree.isExportAll);
        $.setDefault(tree.isDefault);
        if (tree.declaration != null) {
            if (tree.declaration.type == ParseTreeType.VARIABLE_DECLARATION_LIST) {
                VariableDeclarationListTree vdTree = tree.declaration.asVariableDeclarationList();
                VariableDeclarationStatement statement = this.ast.newVariableDeclarationStatement();
                for (ParseTree child : vdTree.declarations) {
                    statement.fragments().add(this.transform(VariableDeclarationStatement.FRAGMENTS_PROPERTY, child));
                }
                $.setDeclaration(statement);
            } else {
                this.transformAndSetProperty($, ExportDeclaration.DECLARATION_PROPERTY, tree.declaration);
            }
        }
        if (tree.exportSpecifierList != null) {
            for (ParseTree spec : tree.exportSpecifierList) {
                $.specifiers().add(this.transform(ExportDeclaration.SPECIFIERS_PROPERTY, spec));
            }
        }
        if (tree.from != null) {
            $.setSource(this.transformStringLiteral((Token)tree.from));
        }
        return $;
    }

    private ASTNode processExportSpec(ExportSpecifierTree tree) {
        ModuleSpecifier $ = this.ast.newModuleSpecifier();
        if (tree.importedName != null) {
            $.setLocal(this.transformLabelName(tree.importedName));
        }
        if (tree.destinationName != null) {
            $.setDiscoverableName(this.transformLabelName(tree.destinationName));
        }
        return $;
    }

    private ASTNode processExpressionStatement(ExpressionStatementTree tree) {
        ExpressionStatement $ = this.ast.newExpressionStatement();
        this.transformAndSetProperty($, ExpressionStatement.EXPRESSION_PROPERTY, tree.expression);
        return $;
    }

    private ASTNode processForInLoop(ForInStatementTree tree) {
        ForInStatement $ = this.ast.newForInStatement();
        this.transformAndSetProperty($, ForInStatement.BODY_PROPERTY, tree.body);
        this.transformAndSetProperty($, ForInStatement.ITERATION_VARIABLE_PROPERTY, tree.initializer);
        this.transformAndSetProperty($, ForInStatement.COLLECTION_PROPERTY, tree.collection);
        return $;
    }

    private ASTNode processForLoop(ForStatementTree tree) {
        ForStatement $ = this.ast.newForStatement();
        this.transformAndSetProperty($, ForStatement.BODY_PROPERTY, tree.body);
        if (this.notNullStatement(tree.condition)) {
            this.transformAndSetProperty($, ForStatement.EXPRESSION_PROPERTY, tree.condition);
        }
        if (this.notNullStatement(tree.initializer)) {
            if (tree.initializer.type == ParseTreeType.VARIABLE_DECLARATION_LIST) {
                VariableDeclarationListTree listTree = tree.initializer.asVariableDeclarationList();
                int startPosition = listTree.location.start.offset;
                VariableDeclarationExpression vd = this.ast.newVariableDeclarationExpression();
                vd.setKind(this.convertVariableKind(listTree.declarationType));
                for (ParseTree child : listTree.declarations) {
                    vd.fragments().add(this.transform(VariableDeclarationExpression.FRAGMENTS_PROPERTY, child));
                    if (startPosition < 0) {
                        startPosition = child.location.start.offset;
                    }
                    vd.setSourceRange(startPosition, child.location.end.offset - startPosition);
                    startPosition = -1;
                }
                $.initializers().add(vd);
            } else {
                $.initializers().add(this.transform(ForStatement.INITIALIZERS_PROPERTY, tree.initializer));
            }
        }
        if (this.notNullStatement(tree.increment)) {
            $.updaters().add(this.transform(ForStatement.UPDATERS_PROPERTY, tree.increment));
        }
        return $;
    }

    private ASTNode processForOf(ForOfStatementTree tree) {
        ForOfStatement $ = this.ast.newForOfStatement();
        this.transformAndSetProperty($, ForOfStatement.BODY_PROPERTY, tree.body);
        this.transformAndSetProperty($, ForOfStatement.ITERATION_VARIABLE_PROPERTY, tree.initializer);
        this.transformAndSetProperty($, ForOfStatement.COLLECTION_PROPERTY, tree.collection);
        return $;
    }

    private ASTNode processFunction(StructuralPropertyDescriptor property, FunctionDeclarationTree tree) {
        if (tree.kind == FunctionDeclarationTree.Kind.ARROW) {
            ArrowFunctionExpression $ = this.ast.newArrowFunctionExpression();
            if (tree.functionBody.type == ParseTreeType.BLOCK) {
                this.transformAndSetProperty($, ArrowFunctionExpression.BODY_PROPERTY, tree.functionBody);
            } else {
                this.transformAndSetProperty($, ArrowFunctionExpression.EXPRESSION_PROPERTY, tree.functionBody);
            }
            if (tree.formalParameterList != null) {
                for (ParseTree param : tree.formalParameterList.parameters) {
                    $.parameters().add(this.transform(ArrowFunctionExpression.PARAMETERS_PROPERTY, param));
                }
            }
            return $;
        }
        FunctionDeclaration $ = this.ast.newFunctionDeclaration();
        this.attachJSDoc((ParseTree)tree, $);
        $.setGenerator(tree.isGenerator);
        this.transformAndSetProperty($, FunctionDeclaration.BODY_PROPERTY, tree.functionBody);
        this.transformAndSetProperty($, FunctionDeclaration.RETURN_TYPE2_PROPERTY, tree.returnType);
        if (tree.name != null) {
            SimpleName name = this.transformLabelName(tree.name);
            $.setMethodName(name);
            $.setConstructor(name.getIdentifier().equals("constructor") || name.getIdentifier().equals("\"constructor\""));
            this.setSourceRange((ASTNode)$, (Token)tree.name);
        } else {
            this.setSourceRange((ASTNode)$, (ParseTree)tree.formalParameterList);
        }
        if (tree.isStatic) {
            $.modifiers().add(this.ast.newModifier(Modifier.ModifierKeyword.STATIC_KEYWORD));
        }
        for (ParseTree param : tree.formalParameterList.parameters) {
            $.parameters().add(this.transform(FunctionDeclaration.PARAMETERS_PROPERTY, param));
        }
        if (tree.access != null) {
            Modifier.ModifierKeyword modifierKeyword = null;
            switch (tree.access) {
                case PUBLIC: {
                    modifierKeyword = Modifier.ModifierKeyword.PUBLIC_KEYWORD;
                    break;
                }
                case PROTECTED: {
                    modifierKeyword = Modifier.ModifierKeyword.PROTECTED_KEYWORD;
                    break;
                }
                case PRIVATE: {
                    modifierKeyword = Modifier.ModifierKeyword.PRIVATE_KEYWORD;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected access modifier type");
                }
            }
            if (modifierKeyword != null) {
                $.modifiers().add(this.ast.newModifier(modifierKeyword));
            }
        }
        return this.adjustFunctionDeclarationToProperty(property, $);
    }

    private ASTNode adjustFunctionDeclarationToProperty(StructuralPropertyDescriptor property, FunctionDeclaration declaration) {
        Class<ASTNode> claz = this.classForProperty(property);
        if (claz.isAssignableFrom(FunctionDeclaration.class)) {
            return declaration;
        }
        if (claz.isAssignableFrom(Expression.class)) {
            FunctionExpression e = this.ast.newFunctionExpression();
            e.setMethod(declaration);
            return e;
        }
        if (claz.isAssignableFrom(Statement.class)) {
            return this.ast.newFunctionDeclarationStatement(declaration);
        }
        return declaration;
    }

    private ASTNode processFunctionCall(CallExpressionTree tree) {
        FunctionInvocation $ = this.ast.newFunctionInvocation();
        if (tree.operand.type == ParseTreeType.IDENTIFIER_EXPRESSION) {
            this.transformAndSetProperty($, FunctionInvocation.NAME_PROPERTY, tree.operand);
        } else {
            this.transformAndSetProperty($, FunctionInvocation.EXPRESSION_PROPERTY, tree.operand);
        }
        for (ParseTree pt : tree.arguments.arguments) {
            $.arguments().add(this.transform(FunctionInvocation.ARGUMENTS_PROPERTY, pt));
        }
        return $;
    }

    private ASTNode processGetAccessor(StructuralPropertyDescriptor property, GetAccessorTree tree) {
        FunctionDeclaration $ = this.ast.newFunctionDeclaration();
        $.setMethodName(this.transformObjectLitKeyAsString(tree.propertyName));
        this.transformAndSetProperty($, FunctionDeclaration.BODY_PROPERTY, (ParseTree)tree.body);
        $.modifiers().add(this.ast.newModifier(Modifier.ModifierKeyword.GET_KEYWORD));
        if (tree.isStatic) {
            $.modifiers().add(this.ast.newModifier(Modifier.ModifierKeyword.STATIC_KEYWORD));
        }
        return this.adjustFunctionDeclarationToProperty(property, $);
    }

    private ASTNode processIfStatement(IfStatementTree tree) {
        IfStatement $ = this.ast.newIfStatement();
        this.transformAndSetProperty($, IfStatement.EXPRESSION_PROPERTY, tree.condition);
        this.transformAndSetProperty($, IfStatement.THEN_STATEMENT_PROPERTY, tree.ifClause);
        this.transformAndSetProperty($, IfStatement.ELSE_STATEMENT_PROPERTY, tree.elseClause);
        return $;
    }

    private ASTNode processIllegalToken(ParseTree node) {
        System.out.println("Unsupported syntax: " + node.type + " at " + node.location.start.line + 1);
        return this.ast.newEmptyStatement();
    }

    private ASTNode processImportDecl(ImportDeclarationTree tree) {
        ImportDeclaration $ = this.ast.newImportDeclaration();
        if (tree.moduleSpecifier != null) {
            $.setSource(this.transformStringLiteral((Token)tree.moduleSpecifier.asLiteral()));
        }
        if (tree.defaultBindingIdentifier != null) {
            ModuleSpecifier defaultModule = this.ast.newModuleSpecifier();
            defaultModule.setDefault(true);
            defaultModule.setLocal(this.transformLabelName(tree.defaultBindingIdentifier));
            this.setSourceRange((ASTNode)defaultModule, (Token)tree.defaultBindingIdentifier);
            $.specifiers().add(defaultModule);
        }
        if (tree.nameSpaceImportIdentifier != null) {
            ModuleSpecifier m = this.ast.newModuleSpecifier();
            m.setNamespace(true);
            m.setLocal(this.transformLabelName(tree.nameSpaceImportIdentifier.asIdentifier()));
            this.setSourceRange((ASTNode)m, (Token)tree.nameSpaceImportIdentifier);
            $.specifiers().add(m);
        } else if (tree.importSpecifierList != null) {
            for (ParseTree spec : tree.importSpecifierList) {
                $.specifiers().add(this.transform(ImportDeclaration.SPECIFIERS_PROPERTY, spec));
            }
        }
        return $;
    }

    private ASTNode processImportSpec(ImportSpecifierTree tree) {
        ModuleSpecifier $ = this.ast.newModuleSpecifier();
        if (tree.destinationName != null) {
            $.setLocal(this.transformLabelName(tree.destinationName.asIdentifier()));
        }
        $.setDiscoverableName(this.transformLabelName(tree.importedName.asIdentifier()));
        return $;
    }

    private ASTNode processLabeledStatement(LabelledStatementTree tree) {
        LabeledStatement $ = this.ast.newLabeledStatement();
        $.setLabel(this.transformLabelName(tree.name));
        this.transformAndSetProperty($, LabeledStatement.BODY_PROPERTY, tree.statement);
        return $;
    }

    private ASTNode processLiteralExpression(LiteralExpressionTree tree) {
        switch (tree.literalToken.type) {
            case NUMBER: {
                return this.transformNumberLiteral(tree.literalToken);
            }
            case STRING: {
                return this.transformStringLiteral(tree.literalToken);
            }
            case TRUE: 
            case FALSE: {
                return this.transformBooleanLiteral(tree.literalToken);
            }
            case NULL: {
                return this.transformNullLiteral(tree.literalToken);
            }
            case REGULAR_EXPRESSION: {
                return this.transformRegExpLiteral(tree.literalToken);
            }
        }
        throw new IllegalStateException("Unexpected literal type: " + tree.literalToken.getClass() + " type: " + tree.literalToken.type);
    }

    private ASTNode processModuleImport(ModuleImportTree tree) {
        ImportDeclaration $ = this.ast.newImportDeclaration();
        ModuleSpecifier m = this.ast.newModuleSpecifier();
        if (tree.name != null) {
            m.setLocal(this.transformLabelName(tree.name));
        }
        m.setDiscoverableName(this.transformLabelName(tree.from.asIdentifier()));
        m.setNamespace(true);
        $.specifiers().add(m);
        return $;
    }

    private ASTNode processName(StructuralPropertyDescriptor property, IdentifierExpressionTree tree) {
        Class<SingleVariableDeclaration> claz = this.classForProperty(property);
        if (tree.identifierToken == null) {
            return null;
        }
        SimpleName sn = this.transformLabelName(tree.identifierToken);
        if (claz.isAssignableFrom(SingleVariableDeclaration.class)) {
            SingleVariableDeclaration $ = this.ast.newSingleVariableDeclaration();
            $.setName(sn);
            return $;
        }
        return sn;
    }

    private ASTNode processNewExpression(NewExpressionTree tree) {
        ClassInstanceCreation $ = this.ast.newClassInstanceCreation();
        this.transformAndSetProperty($, ClassInstanceCreation.MEMBER_PROPERTY, tree.operand);
        if (tree.arguments != null) {
            for (ParseTree arg : tree.arguments.arguments) {
                $.arguments().add(this.transform(ClassInstanceCreation.ARGUMENTS_PROPERTY, arg));
            }
        }
        return $;
    }

    private ASTNode processNull(NullTree tree) {
        return this.ast.newEmptyStatement();
    }

    private ASTNode processObjectPattern(StructuralPropertyDescriptor property, ObjectPatternTree tree) {
        ObjectName $ = this.ast.newObjectName();
        for (ParseTree child : tree.fields) {
            $.objectProperties().add(this.convertToObjectLiteralField(child));
        }
        if (this.classForProperty(property).isAssignableFrom(SingleVariableDeclaration.class)) {
            SingleVariableDeclaration svd = this.ast.newSingleVariableDeclaration();
            svd.setPattern($);
            return svd;
        }
        return $;
    }

    private ASTNode processObjectLiteral(ObjectLiteralExpressionTree tree) {
        ObjectLiteral $ = this.ast.newObjectLiteral();
        for (ParseTree elem : tree.propertyNameAndValues) {
            ObjectLiteralField f = this.convertToObjectLiteralField(elem);
            $.fields().add(f);
        }
        return $;
    }

    private ObjectLiteralField convertToObjectLiteralField(ParseTree elem) {
        ObjectLiteralField f = this.ast.newObjectLiteralField();
        switch (elem.type) {
            case GET_ACCESSOR: {
                f.setKind(ObjectLiteralField.FieldKind.GET);
                GetAccessorTree getAccessor = elem.asGetAccessor();
                f.setFieldName(this.transformObjectLitKeyAsString(getAccessor.propertyName));
                this.transformAndSetProperty(f, ObjectLiteralField.INITIALIZER_PROPERTY, (ParseTree)getAccessor);
                break;
            }
            case COMPUTED_PROPERTY_GETTER: {
                f.setKind(ObjectLiteralField.FieldKind.GET);
                ComputedPropertyGetterTree compGetter = elem.asComputedPropertyGetter();
                this.transformAndSetProperty(f, ObjectLiteralField.FIELD_NAME_PROPERTY, compGetter.property);
                this.transformAndSetProperty(f, ObjectLiteralField.INITIALIZER_PROPERTY, (ParseTree)compGetter);
                break;
            }
            case SET_ACCESSOR: {
                f.setKind(ObjectLiteralField.FieldKind.SET);
                SetAccessorTree setAccessor = elem.asSetAccessor();
                f.setFieldName(this.transformObjectLitKeyAsString(setAccessor.propertyName));
                this.transformAndSetProperty(f, ObjectLiteralField.INITIALIZER_PROPERTY, (ParseTree)setAccessor);
                break;
            }
            case COMPUTED_PROPERTY_SETTER: {
                f.setKind(ObjectLiteralField.FieldKind.SET);
                ComputedPropertySetterTree compSetter = elem.asComputedPropertySetter();
                this.transformAndSetProperty(f, ObjectLiteralField.FIELD_NAME_PROPERTY, compSetter.property);
                this.transformAndSetProperty(f, ObjectLiteralField.INITIALIZER_PROPERTY, (ParseTree)compSetter.body);
                break;
            }
            case COMPUTED_PROPERTY_DEFINITION: {
                f.setKind(ObjectLiteralField.FieldKind.INIT);
                ComputedPropertyDefinitionTree compDef = elem.asComputedPropertyDefinition();
                this.transformAndSetProperty(f, ObjectLiteralField.FIELD_NAME_PROPERTY, compDef.property);
                this.transformAndSetProperty(f, ObjectLiteralField.INITIALIZER_PROPERTY, compDef.value);
                break;
            }
            case COMPUTED_PROPERTY_MEMBER_VARIABLE: {
                f.setKind(ObjectLiteralField.FieldKind.INIT);
                ComputedPropertyMemberVariableTree compVariable = elem.asComputedPropertyMemberVariable();
                this.transformAndSetProperty(f, ObjectLiteralField.FIELD_NAME_PROPERTY, compVariable.property);
                this.transformAndSetProperty(f, ObjectLiteralField.INITIALIZER_PROPERTY, compVariable.declaredType);
                break;
            }
            case COMPUTED_PROPERTY_METHOD: {
                f.setKind(ObjectLiteralField.FieldKind.INIT);
                ComputedPropertyMethodTree compMethod = elem.asComputedPropertyMethod();
                this.transformAndSetProperty(f, ObjectLiteralField.FIELD_NAME_PROPERTY, compMethod.property);
                this.transformAndSetProperty(f, ObjectLiteralField.INITIALIZER_PROPERTY, (ParseTree)compMethod);
                break;
            }
            case FUNCTION_DECLARATION: {
                f.setKind(ObjectLiteralField.FieldKind.INIT);
                FunctionDeclarationTree functionDeclaration = elem.asFunctionDeclaration();
                f.setFieldName(this.transformObjectLitKeyAsString((Token)functionDeclaration.name));
                this.transformAndSetProperty(f, ObjectLiteralField.INITIALIZER_PROPERTY, (ParseTree)functionDeclaration);
                break;
            }
            case DEFAULT_PARAMETER: {
                f.setKind(ObjectLiteralField.FieldKind.INIT);
                DefaultParameterTree defaultTree = elem.asDefaultParameter();
                this.transformAndSetProperty(f, ObjectLiteralField.FIELD_NAME_PROPERTY, defaultTree.lhs);
                this.transformAndSetProperty(f, ObjectLiteralField.INITIALIZER_PROPERTY, defaultTree.defaultValue);
                break;
            }
            default: {
                f.setKind(ObjectLiteralField.FieldKind.INIT);
                PropertyNameAssignmentTree assignment = elem.asPropertyNameAssignment();
                f.setFieldName(this.transformObjectLitKeyAsString(assignment.name));
                this.transformAndSetProperty(f, ObjectLiteralField.INITIALIZER_PROPERTY, assignment.value);
            }
        }
        this.setSourceRange((ASTNode)f, elem);
        return f;
    }

    private ASTNode processParenthesizedExpression(ParenExpressionTree tree) {
        ParenthesizedExpression $ = this.ast.newParenthesizedExpression();
        this.transformAndSetProperty($, ParenthesizedExpression.EXPRESSION_PROPERTY, tree.expression);
        return $;
    }

    private ASTNode processPostfixExpression(PostfixExpressionTree tree) {
        PostfixExpression $ = this.ast.newPostfixExpression();
        this.transformAndSetProperty($, PostfixExpression.OPERAND_PROPERTY, tree.operand);
        $.setOperator(PostfixExpression.Operator.toOperator(tree.operator.toString()));
        return $;
    }

    private ASTNode processPropertyGet(StructuralPropertyDescriptor property, MemberExpressionTree tree) {
        SimpleName name = null;
        if (tree.memberName != null) {
            name = this.transformLabelName(tree.memberName);
        }
        if (tree.operand == null && this.classForProperty(property) == SimpleName.class) {
            return name;
        }
        FieldAccess $ = this.ast.newFieldAccess();
        if (name != null) {
            $.setName(name);
        }
        this.transformAndSetProperty($, FieldAccess.EXPRESSION_PROPERTY, tree.operand);
        return $;
    }

    private ASTNode processPropertyNameAssignment(PropertyNameAssignmentTree tree) {
        VariableDeclarationFragment vdf = this.ast.newVariableDeclarationFragment();
        if (tree.name != null) {
            vdf.setName(this.transformLabelName((IdentifierToken)tree.name));
        }
        this.transformAndSetProperty(vdf, VariableDeclarationFragment.INITIALIZER_PROPERTY, tree.value);
        return this.ast.newFieldDeclaration(vdf);
    }

    private ASTNode processRestParameter(StructuralPropertyDescriptor property, RestParameterTree tree) {
        RestElementName rest = null;
        if (tree.identifier != null) {
            rest = this.ast.newRestElementName();
            rest.setArgument(this.transformLabelName(tree.identifier));
        }
        if (this.classForProperty(property).isAssignableFrom(SingleVariableDeclaration.class)) {
            SingleVariableDeclaration $ = this.ast.newSingleVariableDeclaration();
            if (rest != null) {
                $.setPattern(rest);
            }
            $.setVarargs(true);
            return $;
        }
        return rest;
    }

    private ASTNode processReturnStatement(ReturnStatementTree tree) {
        ReturnStatement $ = this.ast.newReturnStatement();
        this.transformAndSetProperty($, ReturnStatement.EXPRESSION_PROPERTY, tree.expression);
        return $;
    }

    private ASTNode processSetAccessor(StructuralPropertyDescriptor property, SetAccessorTree tree) {
        FunctionDeclaration $ = this.ast.newFunctionDeclaration();
        $.modifiers().add(this.ast.newModifier(Modifier.ModifierKeyword.SET_KEYWORD));
        $.setMethodName(this.transformObjectLitKeyAsString(tree.propertyName));
        this.transformAndSetProperty($, FunctionDeclaration.BODY_PROPERTY, (ParseTree)tree.body);
        SingleVariableDeclaration p = this.ast.newSingleVariableDeclaration();
        if (tree.parameter != null) {
            p.setName(this.transformLabelName(tree.parameter));
        }
        $.parameters().add(p);
        if (tree.isStatic) {
            $.modifiers().add(this.ast.newModifier(Modifier.ModifierKeyword.STATIC_KEYWORD));
        }
        return this.adjustFunctionDeclarationToProperty(property, $);
    }

    private ASTNode processSpreadExpression(SpreadExpressionTree tree) {
        SpreadElement $ = this.ast.newSpreadElement();
        this.transformAndSetProperty($, SpreadElement.ARGUMENT_PROPERTY, tree.expression);
        return $;
    }

    private ASTNode processSuper(SuperExpressionTree tree) {
        return this.ast.newSimpleName(KEYWORD_SUPER);
    }

    private ASTNode processSwitchCase(CaseClauseTree tree) {
        SwitchCase $ = this.ast.newSwitchCase();
        this.transformAndSetProperty($, SwitchCase.EXPRESSION_PROPERTY, tree.expression);
        return $;
    }

    private ASTNode processSwitchDefault(DefaultClauseTree tree) {
        SwitchCase $ = this.ast.newSwitchCase();
        $.setExpression(null);
        return $;
    }

    private ASTNode processSwitchStatement(SwitchStatementTree tree) {
        SwitchStatement $ = this.ast.newSwitchStatement();
        this.transformAndSetProperty($, SwitchStatement.EXPRESSION_PROPERTY, tree.expression);
        for (ParseTree pt : tree.caseClauses) {
            if (pt.type == ParseTreeType.DEFAULT_CLAUSE) {
                DefaultClauseTree dct = pt.asDefaultClause();
                $.statements().add(this.transform(SwitchStatement.STATEMENTS_PROPERTY, (ParseTree)dct));
                for (ParseTree dcs : dct.statements) {
                    $.statements().add(this.transform(SwitchStatement.STATEMENTS_PROPERTY, dcs));
                }
                continue;
            }
            CaseClauseTree cct = pt.asCaseClause();
            $.statements().add(this.transform(SwitchStatement.STATEMENTS_PROPERTY, (ParseTree)cct));
            for (ParseTree ccs : cct.statements) {
                $.statements().add(this.transform(SwitchStatement.STATEMENTS_PROPERTY, ccs));
            }
        }
        return $;
    }

    private ASTNode processTemplateLiteral(TemplateLiteralExpressionTree tree) {
        TemplateLiteral $ = this.ast.newTemplateLiteral();
        this.transformAndSetProperty($, TemplateLiteral.TAG_PROPERTY, tree.operand);
        UnmodifiableIterator iterator = tree.elements.iterator();
        ParseTree pt = null;
        while (iterator.hasNext()) {
            pt = (ParseTree)iterator.next();
            if (pt.type == ParseTreeType.TEMPLATE_LITERAL_PORTION) {
                TemplateElement element = (TemplateElement)this.transform(TemplateLiteral.ELEMENTS_PROPERTY, pt);
                element.setTail(!iterator.hasNext());
                $.elements().add(element);
                continue;
            }
            $.expressions().add(this.transform(TemplateLiteral.EXPRESSIONS_PROPERTY, pt));
        }
        if (pt != null && pt.type != ParseTreeType.TEMPLATE_LITERAL_PORTION) {
            TemplateElement el = this.ast.newTemplateElement();
            el.setSourceRange(pt.location.start.offset, 0);
            el.setTail(true);
            $.elements().add(el);
        }
        return $;
    }

    private ASTNode processTemplateLiteralPortion(TemplateLiteralPortionTree tree) {
        TemplateElement $ = this.ast.newTemplateElement();
        this.safeSetProperty($, TemplateElement.RAW_VALUE_PROPERTY, tree.value.asLiteral().value);
        return $;
    }

    private ASTNode processTemplateSubstitution(TemplateSubstitutionTree tree) {
        return this.transform(TemplateLiteral.EXPRESSIONS_PROPERTY, tree.expression);
    }

    private ASTNode processThisExpression(ThisExpressionTree tree) {
        return this.ast.newThisExpression();
    }

    private ASTNode processThrowStatement(ThrowStatementTree tree) {
        ThrowStatement $ = this.ast.newThrowStatement();
        this.transformAndSetProperty($, ThrowStatement.EXPRESSION_PROPERTY, tree.value);
        return $;
    }

    private ASTNode processTryStatement(TryStatementTree tree) {
        TryStatement $ = this.ast.newTryStatement();
        this.transformAndSetProperty($, TryStatement.BODY_PROPERTY, tree.body);
        if (tree.catchBlock != null) {
            $.catchClauses().add(this.transform(TryStatement.CATCH_CLAUSES_PROPERTY, tree.catchBlock));
        }
        this.transformAndSetProperty($, TryStatement.FINALLY_PROPERTY, tree.finallyBlock);
        return $;
    }

    private ASTNode processTypeName(TypeNameTree tree) {
        Name $ = null;
        UnmodifiableIterator segmentsIt = tree.segments.iterator();
        while (segmentsIt.hasNext()) {
            SimpleName n = this.ast.newSimpleName((String)segmentsIt.next());
            $ = $ == null ? n : this.ast.newQualifiedName($, n);
        }
        return $;
    }

    private ASTNode processUnaryExpression(UnaryExpressionTree tree) {
        PrefixExpression $ = this.ast.newPrefixExpression();
        $.setOperator(PrefixExpression.Operator.toOperator(tree.operator.toString()));
        this.transformAndSetProperty($, PrefixExpression.OPERAND_PROPERTY, tree.operand);
        return $;
    }

    private ASTNode processVariableDeclaration(VariableDeclarationTree tree) {
        VariableDeclarationFragment $ = this.ast.newVariableDeclarationFragment();
        this.transformAndSetProperty($, VariableDeclarationFragment.PATTERN_PROPERTY, tree.lvalue);
        this.transformAndSetProperty($, VariableDeclarationFragment.INITIALIZER_PROPERTY, tree.initializer);
        return $;
    }

    private ASTNode processVariableDeclarationList(VariableDeclarationListTree tree) {
        VariableDeclarationExpression $ = this.ast.newVariableDeclarationExpression((VariableDeclarationFragment)this.transform(VariableDeclarationExpression.FRAGMENTS_PROPERTY, (ParseTree)tree.declarations.get(0)));
        $.setKind(this.convertVariableKind(tree.declarationType));
        return $;
    }

    private ASTNode processVariableStatement(VariableStatementTree tree) {
        VariableDeclarationStatement $ = this.ast.newVariableDeclarationStatement();
        switch (tree.declarations.declarationType) {
            case CONST: {
                $.setKind(VariableKind.CONST);
                break;
            }
            case LET: {
                $.setKind(VariableKind.LET);
                break;
            }
            default: {
                $.setKind(VariableKind.VAR);
            }
        }
        for (ParseTree decl : tree.declarations.declarations) {
            $.fragments().add(this.transform(VariableDeclarationStatement.FRAGMENTS_PROPERTY, decl));
        }
        this.attachJSDoc((ParseTree)tree, $);
        return $;
    }

    private ASTNode processWhileLoop(WhileStatementTree tree) {
        WhileStatement $ = this.ast.newWhileStatement();
        this.transformAndSetProperty($, WhileStatement.EXPRESSION_PROPERTY, tree.condition);
        this.transformAndSetProperty($, WhileStatement.BODY_PROPERTY, tree.body);
        return $;
    }

    private ASTNode processWithStatement(WithStatementTree tree) {
        WithStatement $ = this.ast.newWithStatement();
        this.transformAndSetProperty($, WithStatement.BODY_PROPERTY, tree.body);
        this.transformAndSetProperty($, WithStatement.EXPRESSION_PROPERTY, tree.expression);
        return $;
    }

    private ASTNode processYield(YieldExpressionTree tree) {
        YieldExpression $ = this.ast.newYieldExpression();
        $.setDelegate(tree.isYieldFor);
        this.transformAndSetProperty($, YieldExpression.ARGUMENT_PROPERTY, tree.expression);
        return $;
    }

    private void setSourceRange(ASTNode node, ParseTree tree) {
        VariableDeclarationStatement vs;
        int startOffset = tree.location.start.offset;
        if (node instanceof BodyDeclaration) {
            BodyDeclaration bd = (BodyDeclaration)node;
            if (bd.getJavadoc() != null) {
                startOffset = bd.getJavadoc().getStartPosition();
            }
        } else if (node.getNodeType() == 60 && (vs = (VariableDeclarationStatement)node).getJavadoc() != null) {
            startOffset = vs.getJavadoc().getStartPosition();
        }
        node.setSourceRange(startOffset, Math.max(tree.location.end.offset - startOffset, 0));
    }

    private void setSourceRange(ASTNode node, Token token) {
        node.setSourceRange(token.location.start.offset, token.location.end.offset - token.location.start.offset);
    }

    private Comment handleJsDoc(ParseTree node) {
        if (!this.shouldAttachJSDocHere(node)) {
            return null;
        }
        return this.getJsDoc(node.location);
    }

    private boolean shouldAttachJSDocHere(ParseTree tree) {
        switch (tree.type) {
            case EXPRESSION_STATEMENT: 
            case LABELLED_STATEMENT: 
            case EXPORT_DECLARATION: {
                return false;
            }
            case BINARY_OPERATOR: 
            case CONDITIONAL_EXPRESSION: 
            case POSTFIX_EXPRESSION: 
            case MEMBER_EXPRESSION: 
            case CALL_EXPRESSION: 
            case MEMBER_LOOKUP_EXPRESSION: {
                ParseTree nearest = ClosureCompilerASTConverter.findNearestNode(tree);
                return nearest.type != ParseTreeType.PAREN_EXPRESSION;
            }
        }
        return true;
    }

    private Comment getJsDoc(SourceRange location) {
        Comment closestPreviousComment = null;
        while (this.currentComment != null && this.currentComment.location.end.offset <= location.start.offset) {
            if (this.currentComment.type == Comment.Type.JSDOC) {
                closestPreviousComment = this.currentComment;
            }
            this.currentComment = this.nextCommentIter.hasNext() ? this.nextCommentIter.next() : null;
        }
        return closestPreviousComment;
    }

    private static ParseTree findNearestNode(ParseTree tree) {
        block9: while (true) {
            switch (tree.type) {
                case EXPRESSION_STATEMENT: {
                    tree = tree.asExpressionStatement().expression;
                    continue block9;
                }
                case CALL_EXPRESSION: {
                    tree = tree.asCallExpression().operand;
                    continue block9;
                }
                case BINARY_OPERATOR: {
                    tree = tree.asBinaryOperator().left;
                    continue block9;
                }
                case CONDITIONAL_EXPRESSION: {
                    tree = tree.asConditionalExpression().condition;
                    continue block9;
                }
                case MEMBER_EXPRESSION: {
                    tree = tree.asMemberExpression().operand;
                    continue block9;
                }
                case MEMBER_LOOKUP_EXPRESSION: {
                    tree = tree.asMemberLookupExpression().operand;
                    continue block9;
                }
                case POSTFIX_EXPRESSION: {
                    tree = tree.asPostfixExpression().operand;
                    continue block9;
                }
            }
            break;
        }
        return tree;
    }

    private ASTNode transformBooleanLiteral(Token token) {
        BooleanLiteral $ = this.ast.newBooleanLiteral(token.type == TokenType.TRUE);
        this.setSourceRange((ASTNode)$, token);
        return $;
    }

    private SimpleName transformLabelName(IdentifierToken token) {
        SimpleName $ = this.ast.newSimpleName(token.value);
        this.setSourceRange((ASTNode)$, (Token)token);
        return $;
    }

    private ASTNode transformNullLiteral(Token token) {
        NullLiteral $ = this.ast.newNullLiteral();
        this.setSourceRange((ASTNode)$, token);
        return $;
    }

    private ASTNode transformNumberLiteral(Token token) {
        NumberLiteral $ = this.ast.newNumberLiteral();
        $.internalSetToken(token.asLiteral().value);
        this.setSourceRange((ASTNode)$, token);
        return $;
    }

    private SimpleName transformObjectLitKeyAsString(Token token) {
        SimpleName $ = null;
        if (token == null) {
            $ = this.ast.newSimpleName("");
            this.setSourceRange((ASTNode)$, token);
        } else if (token.type == TokenType.IDENTIFIER) {
            $ = this.transformLabelName(token.asIdentifier());
        } else {
            $ = this.ast.newSimpleName(token.asLiteral().value);
            this.setSourceRange((ASTNode)$, token);
        }
        return $;
    }

    private ASTNode transformRegExpLiteral(Token token) {
        RegularExpressionLiteral $ = this.ast.newRegularExpressionLiteral();
        $.internalSetRegularExpression(token.asLiteral().value);
        this.setSourceRange((ASTNode)$, token);
        return $;
    }

    private StringLiteral transformStringLiteral(Token token) {
        StringLiteral $ = this.ast.newStringLiteral();
        $.internalSetEscapedValue(token.asLiteral().value);
        this.setSourceRange((ASTNode)$, token);
        return $;
    }

    private void transformAndSetProperty(ASTNode node, StructuralPropertyDescriptor property, ParseTree tree) {
        if (tree == null) {
            return;
        }
        this.safeSetProperty(node, property, this.transform(property, tree));
    }

    private void safeSetProperty(ASTNode node, StructuralPropertyDescriptor property, Object value) {
        ChildPropertyDescriptor cp;
        if (property.isChildProperty() && (cp = (ChildPropertyDescriptor)property).isMandatory() && value == null) {
            return;
        }
        node.setStructuralProperty(property, value);
    }

    private Class<?> classForProperty(StructuralPropertyDescriptor property) {
        if (property.isChildProperty()) {
            ChildPropertyDescriptor cp = (ChildPropertyDescriptor)property;
            return cp.getChildType();
        }
        if (property.isChildListProperty()) {
            ChildListPropertyDescriptor cl = (ChildListPropertyDescriptor)property;
            return cl.getElementType();
        }
        if (property.isSimpleProperty()) {
            SimplePropertyDescriptor sp = (SimplePropertyDescriptor)property;
            sp.getValueType();
        }
        return Object.class;
    }
}

