/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.refactor.actions;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameRefactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.refactor.actions.SelectionDispatchAction;
import org.eclipse.wst.xsd.ui.internal.refactor.rename.RenameResourceProcessor;
import org.eclipse.wst.xsd.ui.internal.refactor.wizard.RefactoringWizardMessages;
import org.eclipse.wst.xsd.ui.internal.refactor.wizard.RenameRefactoringWizard;

public class RenameResourceAction
extends SelectionDispatchAction {
    public RenameResourceAction(ISelection selection) {
        super(selection);
    }

    public void selectionChanged(IStructuredSelection selection) {
        IResource element = RenameResourceAction.getResource(selection);
        if (element == null) {
            this.setEnabled(false);
        } else {
            RenameResourceProcessor processor = new RenameResourceProcessor(element);
            this.setEnabled(processor.isApplicable());
        }
    }

    public void run(IStructuredSelection selection) {
        IResource resource = RenameResourceAction.getResource(selection);
        RenameResourceProcessor processor = new RenameResourceProcessor(resource);
        if (!processor.isApplicable()) {
            return;
        }
        RenameRefactoring refactoring = new RenameRefactoring((RenameProcessor)processor);
        try {
            RenameRefactoringWizard wizard = new RenameRefactoringWizard((Refactoring)refactoring, RefactoringWizardMessages.RenameComponentWizard_defaultPageTitle, RefactoringWizardMessages.RenameComponentWizard_inputPage_description, null);
            RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation((RefactoringWizard)wizard);
            op.run(XSDEditorPlugin.getShell(), wizard.getDefaultPageTitle());
        }
        catch (InterruptedException interruptedException) {}
    }

    private static IResource getResource(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return null;
        }
        Object first = selection.getFirstElement();
        if (!(first instanceof IResource)) {
            return null;
        }
        return (IResource)first;
    }
}

