/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.typesystem.xsd.util;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class EmfFormatter {
    public static String objToStr(Object obj, String ident) {
        String innerIdent = "  " + ident;
        if (obj instanceof EObject) {
            StringBuffer buf = new StringBuffer();
            EObject eobj = (EObject)obj;
            buf.append(String.valueOf(eobj.eClass().getName()) + " {\n");
            for (EStructuralFeature f : eobj.eClass().getEAllStructuralFeatures()) {
                if (!eobj.eIsSet(f)) continue;
                String fType = "unknown";
                String val = "???";
                if (f instanceof EReference) {
                    EReference r = (EReference)f;
                    if (r.isContainment()) {
                        val = EmfFormatter.objToStr(eobj.eGet(f), innerIdent);
                        fType = "cref";
                    } else {
                        val = EmfFormatter.refToStr(eobj, r);
                        fType = "ref";
                    }
                } else if (f instanceof EAttribute) {
                    fType = "attr";
                    Object at = eobj.eGet(f);
                    val = eobj != at ? EmfFormatter.objToStr(at, innerIdent) : "<same as container object>";
                }
                String vType = f.getEType().getName();
                String name = f.getName();
                buf.append(String.valueOf(innerIdent) + fType + " " + vType + " " + name + " " + val + "\n");
            }
            buf.append(String.valueOf(ident) + "}");
            return buf.toString();
        }
        if (obj instanceof Collection) {
            StringBuffer buf = new StringBuffer();
            buf.append("[\n");
            for (Object o : (Collection)obj) {
                buf.append(String.valueOf(innerIdent) + EmfFormatter.objToStr(o, innerIdent) + "\n");
            }
            buf.append(String.valueOf(ident) + "]");
            return buf.toString();
        }
        if (obj != null) {
            return "'" + obj + "'";
        }
        return "null";
    }

    private static String refToStr(EObject obj, EReference ref) {
        StringBuffer buf = new StringBuffer();
        Object o = obj.eGet((EStructuralFeature)ref);
        if (o instanceof EObject) {
            EObject eo = (EObject)o;
            if (eo instanceof ENamedElement) {
                buf.append("'" + ((ENamedElement)eo).getName() + "' ");
            }
            buf.append("ref:" + EcoreUtil.getURI((EObject)eo));
            return buf.toString();
        }
        if (o instanceof Collection) {
            buf.append("[");
            Iterator i = ((Collection)o).iterator();
            while (i.hasNext()) {
                Object item = i.next();
                buf.append(EcoreUtil.getURI((EObject)((EObject)item)));
                if (!i.hasNext()) continue;
                buf.append(", ");
            }
            buf.append("]");
            return buf.toString();
        }
        return "?????";
    }
}

