/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.smap;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.generator.trace.SourceRelativeURI;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.ui.generator.trace.IEclipseTrace;
import org.eclipse.xtext.ui.generator.trace.ILocationInEclipseResource;
import org.eclipse.xtext.ui.validation.MarkerTypeProvider;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.ITextRegionWithLineInformation;
import org.eclipse.xtext.util.TextRegion;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.validation.IssueSeveritiesProvider;

public class DerivedResourceMarkerCopier {
    private static final Logger LOG = Logger.getLogger(DerivedResourceMarkerCopier.class);
    public static final String COPIED_FROM_FILE = "fromFile";
    public static final String COPY_JAVA_PROBLEMS_ISSUECODE = "org.eclipse.xtext.builder.copyJavaProblems";
    @Inject
    private IResourceServiceProvider.Registry serviceProviderRegistry;

    public void reflectErrorMarkerInSource(IFile javaFile, IEclipseTrace traceToSource) throws CoreException {
        IFile srcFile = this.findSourceFile(traceToSource, javaFile.getWorkspace());
        if (srcFile == null || !srcFile.exists()) {
            return;
        }
        int maxSeverity = this.getMaxSeverity(srcFile);
        this.cleanUpCreatedMarkers(javaFile, (IResource)srcFile);
        Set<IMarker> problemsInJava = this.findJavaProblemMarker(javaFile, maxSeverity);
        if (problemsInJava.size() == 0) {
            return;
        }
        if (!this.hasPlainXtextProblemMarker(srcFile, maxSeverity)) {
            this.copyProblemMarker(javaFile, traceToSource, problemsInJava, srcFile);
        }
    }

    private int getMaxSeverity(IFile srcFile) {
        URI resourceURI = URI.createPlatformResourceURI((String)srcFile.getFullPath().toString(), (boolean)true);
        IResourceServiceProvider serviceProvider = this.serviceProviderRegistry.getResourceServiceProvider(resourceURI);
        if (serviceProvider == null) {
            return Integer.MAX_VALUE;
        }
        IssueSeveritiesProvider severitiesProvider = (IssueSeveritiesProvider)serviceProvider.get(IssueSeveritiesProvider.class);
        Severity severity = severitiesProvider.getIssueSeverities((Resource)new ResourceImpl(resourceURI)).getSeverity(COPY_JAVA_PROBLEMS_ISSUECODE);
        switch (severity) {
            case WARNING: {
                return 1;
            }
            case ERROR: {
                return 2;
            }
            case INFO: 
            case IGNORE: {
                return Integer.MAX_VALUE;
            }
        }
        return Integer.MAX_VALUE;
    }

    private void copyProblemMarker(IFile javaFile, IEclipseTrace traceToSource, Set<IMarker> problemsInJava, IFile srcFile) throws CoreException {
        String sourceMarkerType = null;
        for (IMarker marker : problemsInJava) {
            String message = (String)marker.getAttribute("message");
            if (message == null) continue;
            Integer charStart = marker.getAttribute("charStart", 0);
            Integer charEnd = marker.getAttribute("charEnd", 0);
            int severity = MarkerUtilities.getSeverity((IMarker)marker);
            ILocationInEclipseResource associatedLocation = (ILocationInEclipseResource)traceToSource.getBestAssociatedLocation((ITextRegion)new TextRegion(charStart.intValue(), charEnd - charStart));
            if (associatedLocation == null) continue;
            if (sourceMarkerType == null) {
                sourceMarkerType = this.determinateMarkerTypeByURI(associatedLocation.getSrcRelativeResourceURI());
            }
            if (!srcFile.equals((Object)this.findIFile(associatedLocation, srcFile.getWorkspace()))) {
                LOG.error((Object)"File in associated location is not the same as main source file.");
            }
            IMarker xtendMarker = srcFile.createMarker(sourceMarkerType);
            xtendMarker.setAttribute("message", (Object)("Java problem: " + message));
            xtendMarker.setAttribute("severity", severity);
            ITextRegionWithLineInformation region = associatedLocation.getTextRegion();
            xtendMarker.setAttribute("lineNumber", region.getLineNumber());
            xtendMarker.setAttribute("charStart", region.getOffset());
            xtendMarker.setAttribute("charEnd", region.getOffset() + region.getLength());
            xtendMarker.setAttribute(COPIED_FROM_FILE, (Object)javaFile.getFullPath().toString());
        }
    }

    private String determinateMarkerTypeByURI(SourceRelativeURI resourceURI) {
        IResourceServiceProvider serviceProvider = this.serviceProviderRegistry.getResourceServiceProvider(resourceURI.getURI());
        if (serviceProvider == null) {
            return null;
        }
        MarkerTypeProvider typeProvider = (MarkerTypeProvider)serviceProvider.get(MarkerTypeProvider.class);
        Issue.IssueImpl issue = new Issue.IssueImpl();
        issue.setType(CheckType.NORMAL);
        return typeProvider.getMarkerType((Issue)issue);
    }

    private Set<IMarker> findJavaProblemMarker(IFile javaFile, int maxSeverity) throws CoreException {
        HashSet problems = Sets.newHashSet();
        IMarker[] iMarkerArray = javaFile.findMarkers("org.eclipse.jdt.core.problem", true, 0);
        int n = iMarkerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            if (MarkerUtilities.getSeverity((IMarker)marker) >= maxSeverity) {
                problems.add(marker);
            }
            ++n2;
        }
        return problems;
    }

    private boolean hasPlainXtextProblemMarker(IFile srcFile, int maxSeverity) throws CoreException {
        IMarker[] iMarkerArray = srcFile.findMarkers("org.eclipse.xtext.ui.check", true, 0);
        int n = iMarkerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker iMarker = iMarkerArray[n2];
            if (MarkerUtilities.getSeverity((IMarker)iMarker) >= maxSeverity && iMarker.getAttribute(COPIED_FROM_FILE) == null) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void cleanUpCreatedMarkers(IFile javaFile, IResource srcFile) throws CoreException {
        IMarker[] iMarkerArray = srcFile.findMarkers("org.eclipse.xtext.ui.check", true, 0);
        int n = iMarkerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker iMarker = iMarkerArray[n2];
            if (javaFile.getFullPath().toString().equals(iMarker.getAttribute(COPIED_FROM_FILE, ""))) {
                iMarker.delete();
            }
            ++n2;
        }
    }

    private IFile findSourceFile(IEclipseTrace traceToSource, IWorkspace workspace) {
        Iterator iterator = traceToSource.getAllAssociatedLocations().iterator();
        if (iterator.hasNext()) {
            ILocationInEclipseResource srcLocation = (ILocationInEclipseResource)iterator.next();
            return this.findIFile(srcLocation, workspace);
        }
        return null;
    }

    private IFile findIFile(ILocationInEclipseResource locationInResource, IWorkspace workspace) {
        IStorage storage = (IStorage)locationInResource.getPlatformResource();
        if (storage == null) {
            LOG.warn((Object)("Failed to find Storage. Please make sure there are no outdated generated files. URI: " + locationInResource.getAbsoluteResourceURI()));
            return null;
        }
        return workspace.getRoot().getFile(storage.getFullPath());
    }
}

