/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.handler;

import com.google.inject.Inject;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionProvider;
import org.eclipse.xtext.ui.editor.utils.EditorUtils;
import org.eclipse.xtext.ui.editor.validation.AnnotationIssueProcessor;
import org.eclipse.xtext.ui.editor.validation.IValidationIssueProcessor;
import org.eclipse.xtext.ui.editor.validation.MarkerCreator;
import org.eclipse.xtext.ui.editor.validation.MarkerIssueProcessor;
import org.eclipse.xtext.ui.editor.validation.ValidationJob;
import org.eclipse.xtext.ui.validation.MarkerTypeProvider;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;

public class ValidateActionHandler
extends AbstractHandler {
    @Inject
    private IResourceValidator resourceValidator;
    @Inject
    private MarkerCreator markerCreator;
    @Inject
    private MarkerTypeProvider markerTypeProvider;
    @Inject
    private IssueResolutionProvider issueResolutionProvider;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        XtextEditor xtextEditor = EditorUtils.getActiveXtextEditor(event);
        if (xtextEditor != null) {
            IXtextDocument xtextDocument = xtextEditor.getDocument();
            IResource resource = xtextEditor.getResource();
            IValidationIssueProcessor issueProcessor = resource != null ? new MarkerIssueProcessor(resource, xtextEditor.getInternalSourceViewer().getAnnotationModel(), this.markerCreator, this.markerTypeProvider) : new AnnotationIssueProcessor(xtextDocument, xtextEditor.getInternalSourceViewer().getAnnotationModel(), this.issueResolutionProvider);
            ValidationJob validationJob = new ValidationJob(this.resourceValidator, xtextDocument, issueProcessor, CheckMode.ALL);
            validationJob.schedule();
        }
        return this;
    }
}

