/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.quickfix;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.ui.editor.model.edit.BatchModification;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolution;
import org.eclipse.xtext.ui.editor.quickfix.MarkerResolutionGenerator;
import org.eclipse.xtext.ui.util.IssueUtil;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pure;

public class WorkbenchMarkerResolutionAdapter
extends WorkbenchMarkerResolution {
    @Inject
    private MarkerResolutionGenerator resolutionsGenerator;
    @Inject
    private IssueUtil issueUtil;
    @Inject
    private Provider<BatchModification> batchModificationProvider;
    private static final Logger LOG = Logger.getLogger(WorkbenchMarkerResolutionAdapter.class);
    @Accessors
    private IssueResolution primaryResolution;
    @Accessors
    private IMarker primaryMarker;

    public IMarker[] findOtherMarkers(IMarker[] markers) {
        Functions.Function1 _function = it -> !Objects.equal((Object)it, (Object)this.primaryMarker) && Objects.equal((Object)this.issueUtil.getCode(this.primaryMarker), (Object)this.issueUtil.getCode((IMarker)it));
        return (IMarker[])Conversions.unwrapArray((Object)IterableExtensions.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)markers)), (Functions.Function1)_function), IMarker.class);
    }

    public String getLabel() {
        return this.primaryResolution.getLabel();
    }

    public void run(IMarker marker) {
        boolean _not;
        boolean _exists = marker.exists();
        boolean bl = _not = !_exists;
        if (_not) {
            return;
        }
        NullProgressMonitor _nullProgressMonitor = new NullProgressMonitor();
        this.run(new IMarker[]{marker}, (IProgressMonitor)_nullProgressMonitor);
    }

    public void run(IMarker[] markers, IProgressMonitor progressMonitor) {
        Functions.Function1 _function = it -> it.getResource().getProject();
        Map markersByProject = IterableExtensions.groupBy((Iterable)((Iterable)Conversions.doWrapArray((Object)markers)), (Functions.Function1)_function);
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progressMonitor);
        monitor.beginTask("Applying resolutions", markersByProject.size());
        Set _entrySet = markersByProject.entrySet();
        for (Map.Entry g : _entrySet) {
            BatchModification batch = (BatchModification)this.batchModificationProvider.get();
            batch.setProject((IProject)g.getKey());
            List markersInProject = (List)g.getValue();
            Functions.Function1 _function_1 = it -> this.resolution((IMarker)it);
            List resolutions = IterableExtensions.toList((Iterable)IterableExtensions.filterNull((Iterable)ListExtensions.map((List)markersInProject, (Functions.Function1)_function_1)));
            this.cancelIfNeeded((IProgressMonitor)monitor);
            Functions.Function1 _function_2 = it -> it.getModification();
            Iterable modifications = Iterables.filter((Iterable)ListExtensions.map((List)resolutions, (Functions.Function1)_function_2), BatchModification.IBatchableModification.class);
            this.cancelIfNeeded((IProgressMonitor)monitor);
            batch.apply(modifications, (IProgressMonitor)monitor.newChild(1));
            this.cancelIfNeeded((IProgressMonitor)monitor);
        }
        monitor.done();
    }

    protected void cancelIfNeeded(IProgressMonitor monitor) {
        boolean _isCanceled = monitor.isCanceled();
        if (_isCanceled) {
            throw new OperationCanceledException();
        }
    }

    public IssueResolution resolution(IMarker marker) {
        Functions.Function1 _function;
        boolean _not;
        boolean _exists = marker.exists();
        boolean bl = _not = !_exists;
        if (_not) {
            return null;
        }
        Issue issue = this.issueUtil.createIssue(marker);
        List<IssueResolution> resolutions = this.resolutionsGenerator.getResolutionProvider().getResolutions(issue);
        IssueResolution resolution = (IssueResolution)IterableExtensions.head((Iterable)IterableExtensions.filter(resolutions, (Functions.Function1)(_function = it -> this.isSameResolution((IssueResolution)it, this.primaryResolution))));
        if (resolution == null) {
            String _code = issue.getCode();
            String _plus = "Resolution missing for " + _code;
            LOG.warn((Object)_plus);
        }
        return resolution;
    }

    public String getDescription() {
        return this.primaryResolution.getDescription();
    }

    public Image getImage() {
        return this.resolutionsGenerator.getImage(this.primaryResolution);
    }

    private boolean isSameResolution(IssueResolution it, IssueResolution other) {
        return it != null && other != null && Objects.equal((Object)it.getDescription(), (Object)other.getDescription()) && Objects.equal((Object)it.getLabel(), (Object)other.getLabel()) && Objects.equal((Object)it.getImage(), (Object)other.getImage());
    }

    @Pure
    public IssueResolution getPrimaryResolution() {
        return this.primaryResolution;
    }

    public void setPrimaryResolution(IssueResolution primaryResolution) {
        this.primaryResolution = primaryResolution;
    }

    @Pure
    public IMarker getPrimaryMarker() {
        return this.primaryMarker;
    }

    public void setPrimaryMarker(IMarker primaryMarker) {
        this.primaryMarker = primaryMarker;
    }

    public static class Factory {
        @Inject
        private Provider<WorkbenchMarkerResolutionAdapter> provider;

        public IMarkerResolution create(IMarker marker, IssueResolution resolution) {
            WorkbenchMarkerResolutionAdapter resolutionFix = (WorkbenchMarkerResolutionAdapter)((Object)this.provider.get());
            resolutionFix.primaryResolution = resolution;
            resolutionFix.primaryMarker = marker;
            return resolutionFix;
        }
    }
}

