/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource.generic;

import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.Map;
import org.eclipse.emf.mwe2.runtime.workflow.IWorkflowComponent;
import org.eclipse.emf.mwe2.runtime.workflow.IWorkflowContext;
import org.eclipse.xtext.resource.FileExtensionProvider;
import org.eclipse.xtext.resource.IResourceServiceProvider;

public abstract class AbstractGenericResourceSupport
implements IWorkflowComponent {
    @Inject
    private FileExtensionProvider fileExtensionProvider;
    @Inject
    private IResourceServiceProvider resourceServiceProvider;
    @Inject
    private IResourceServiceProvider.Registry registry;
    private Module guiceModule;

    public void preInvoke() {
        this.registerServices(true);
    }

    public void registerServices(boolean force) {
        Injector injector = Guice.createInjector((Module[])new Module[]{this.getGuiceModule()});
        injector.injectMembers((Object)this);
        this.registerInRegistry(force);
    }

    public void setGuiceModule(Module module) {
        this.guiceModule = module;
    }

    protected Module getGuiceModule() {
        if (this.guiceModule == null) {
            this.guiceModule = this.createGuiceModule();
        }
        return this.guiceModule;
    }

    protected abstract Module createGuiceModule();

    @Deprecated
    protected void registerInRegistry() {
        this.registerInRegistry(true);
    }

    protected void registerInRegistry(boolean force) {
        Map<String, Object> map = this.registry.getExtensionToFactoryMap();
        for (String fileExtension : this.fileExtensionProvider.getFileExtensions()) {
            if (!force && map.containsKey(fileExtension)) continue;
            map.put(fileExtension, this.resourceServiceProvider);
        }
    }

    public void invoke(IWorkflowContext ctx) {
    }

    public void postInvoke() {
    }
}

