/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.report.internal.html.table;

import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.jacoco.core.analysis.CounterComparator;
import org.jacoco.core.analysis.ICounter;
import org.jacoco.core.analysis.ICoverageNode;
import org.jacoco.report.internal.ReportOutputFolder;
import org.jacoco.report.internal.html.HTMLElement;
import org.jacoco.report.internal.html.resources.Resources;
import org.jacoco.report.internal.html.table.IColumnRenderer;
import org.jacoco.report.internal.html.table.ITableItem;
import org.jacoco.report.internal.html.table.TableItemComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BarColumn
implements IColumnRenderer {
    private static final int WIDTH = 120;
    private final ICoverageNode.CounterEntity entity;
    private final NumberFormat integerFormat;
    private int max;
    private final Comparator<ITableItem> comparator;

    public BarColumn(ICoverageNode.CounterEntity entity, Locale locale) {
        this.entity = entity;
        this.integerFormat = DecimalFormat.getIntegerInstance(locale);
        this.comparator = new TableItemComparator((Comparator<ICoverageNode>)CounterComparator.MISSEDITEMS.reverse().on(entity).second((Comparator)CounterComparator.TOTALITEMS.reverse().on(entity)));
    }

    @Override
    public boolean init(List<? extends ITableItem> items, ICoverageNode total) {
        this.max = 0;
        for (ITableItem iTableItem : items) {
            int count = iTableItem.getNode().getCounter(this.entity).getTotalCount();
            if (count <= this.max) continue;
            this.max = count;
        }
        return true;
    }

    @Override
    public void footer(HTMLElement td, ICoverageNode total, Resources resources, ReportOutputFolder base) throws IOException {
        ICounter counter = total.getCounter(this.entity);
        td.text(this.integerFormat.format(counter.getMissedCount()));
        td.text(" of ");
        td.text(this.integerFormat.format(counter.getTotalCount()));
    }

    @Override
    public void item(HTMLElement td, ITableItem item, Resources resources, ReportOutputFolder base) throws IOException {
        if (this.max > 0) {
            ICounter counter = item.getNode().getCounter(this.entity);
            int missed = counter.getMissedCount();
            this.bar(td, missed, "redbar.gif", resources, base);
            int covered = counter.getCoveredCount();
            this.bar(td, covered, "greenbar.gif", resources, base);
        }
    }

    private void bar(HTMLElement td, int count, String image, Resources resources, ReportOutputFolder base) throws IOException {
        int width = count * 120 / this.max;
        if (width > 0) {
            td.img(resources.getLink(base, image), width, 10, this.integerFormat.format(count));
        }
    }

    @Override
    public Comparator<ITableItem> getComparator() {
        return this.comparator;
    }
}

