/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtorm.client.impl;

import com.google.gwtorm.client.Key;
import com.google.gwtorm.client.OrmException;
import com.google.gwtorm.client.Transaction;
import com.google.gwtorm.client.impl.AbstractAccess;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public abstract class AbstractTransaction
implements Transaction {
    protected final Map<Object, Action<?, Key<?>, AbstractTransaction>> pendingInsert = AbstractTransaction.newMap();
    protected final Map<Object, Action<?, Key<?>, AbstractTransaction>> pendingUpdate = AbstractTransaction.newMap();
    protected final Map<Object, Action<?, Key<?>, AbstractTransaction>> pendingUpsert = AbstractTransaction.newMap();
    protected final Map<Object, Action<?, Key<?>, AbstractTransaction>> pendingDelete = AbstractTransaction.newMap();

    private static LinkedHashMap<Object, Action<?, Key<?>, AbstractTransaction>> newMap() {
        return new LinkedHashMap();
    }

    protected AbstractTransaction() {
    }

    @Override
    public void commit() throws OrmException {
        for (Action<?, Key<?>, AbstractTransaction> a : this.pendingDelete.values()) {
            a.doDelete(this);
        }
        for (Action<?, Key<?>, AbstractTransaction> a : this.pendingInsert.values()) {
            a.doInsert(this);
        }
        for (Action<?, Key<?>, AbstractTransaction> a : this.pendingUpdate.values()) {
            a.doUpdate(this);
        }
        for (Action<?, Key<?>, AbstractTransaction> a : this.pendingUpsert.values()) {
            a.doUpsert(this);
        }
    }

    <E, K extends Key<?>, T extends AbstractTransaction> void queueInsert(AbstractAccess<E, ?, T> access, Iterable<E> list) {
        AbstractTransaction.queue(this.pendingInsert, access, list);
    }

    <E, K extends Key<?>, T extends AbstractTransaction> void queueUpdate(AbstractAccess<E, ?, T> access, Iterable<E> list) {
        AbstractTransaction.queue(this.pendingUpdate, access, list);
    }

    <E, K extends Key<?>, T extends AbstractTransaction> void queueUpsert(AbstractAccess<E, ?, T> access, Iterable<E> list) {
        AbstractTransaction.queue(this.pendingUpsert, access, list);
    }

    <E, K extends Key<?>, T extends AbstractTransaction> void queueDelete(AbstractAccess<E, ?, T> access, Iterable<E> list) {
        AbstractTransaction.queue(this.pendingDelete, access, list);
    }

    private static <E, K extends Key<?>, T extends AbstractTransaction> void queue(Map<Object, Action<?, Key<?>, AbstractTransaction>> queue, AbstractAccess<E, K, T> access, Iterable<E> list) {
        Action<E, K, T> c = AbstractTransaction.get(queue, access);
        if (c == null) {
            c = new Action<E, K, T>(access);
            AbstractTransaction.put(queue, c);
        }
        c.addAll(list);
    }

    private static <E, K extends Key<?>, T extends AbstractTransaction> Action<E, K, T> get(Map<Object, Action<?, Key<?>, AbstractTransaction>> q, AbstractAccess<E, K, T> access) {
        return q.get(access);
    }

    private static <E, K extends Key<?>, T extends AbstractTransaction> void put(Map queue, Action<E, K, T> c) {
        queue.put(((Action)c).access, c);
    }

    private static class Action<E, K extends Key<?>, T extends AbstractTransaction> {
        private final AbstractAccess<E, K, T> access;
        private final Set<E> instances;

        Action(AbstractAccess<E, K, T> a) {
            this.access = a;
            this.instances = new LinkedHashSet();
        }

        void addAll(Iterable<E> list) {
            for (E o : list) {
                this.instances.add(o);
            }
        }

        void doInsert(T t) throws OrmException {
            this.access.doInsert(this.instances, t);
        }

        void doUpdate(T t) throws OrmException {
            this.access.doUpdate(this.instances, t);
        }

        void doUpsert(T t) throws OrmException {
            this.access.doUpsert(this.instances, t);
        }

        void doDelete(T t) throws OrmException {
            this.access.doDelete(this.instances, t);
        }
    }
}

