/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.document.FeatureField;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.BytesRef;

final class FeatureQuery
extends Query {
    private final String fieldName;
    private final String featureName;
    private final FeatureField.FeatureFunction function;

    FeatureQuery(String fieldName, String featureName, FeatureField.FeatureFunction function) {
        this.fieldName = Objects.requireNonNull(fieldName);
        this.featureName = Objects.requireNonNull(featureName);
        this.function = Objects.requireNonNull(function);
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        FeatureField.FeatureFunction rewritten = this.function.rewrite(reader);
        if (this.function != rewritten) {
            return new FeatureQuery(this.fieldName, this.featureName, rewritten);
        }
        return super.rewrite(reader);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FeatureQuery that = (FeatureQuery)obj;
        return Objects.equals(this.fieldName, that.fieldName) && Objects.equals(this.featureName, that.featureName) && Objects.equals(this.function, that.function);
    }

    @Override
    public int hashCode() {
        int h = this.getClass().hashCode();
        h = 31 * h + this.fieldName.hashCode();
        h = 31 * h + this.featureName.hashCode();
        h = 31 * h + this.function.hashCode();
        return h;
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, final boolean needsScores, final float boost) throws IOException {
        return new Weight(this){

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return false;
            }

            @Override
            public void extractTerms(Set<Term> terms) {
                if (needsScores) {
                    terms.add(new Term(FeatureQuery.this.fieldName, FeatureQuery.this.featureName));
                }
            }

            @Override
            public Explanation explain(LeafReaderContext context, int doc) throws IOException {
                String desc = "weight(" + this.getQuery() + " in " + doc + ") [" + FeatureQuery.this.function + "]";
                Terms terms = context.reader().terms(FeatureQuery.this.fieldName);
                if (terms == null) {
                    return Explanation.noMatch(desc + ". Field " + FeatureQuery.this.fieldName + " doesn't exist.", new Explanation[0]);
                }
                TermsEnum termsEnum = terms.iterator();
                if (!termsEnum.seekExact(new BytesRef(FeatureQuery.this.featureName))) {
                    return Explanation.noMatch(desc + ". Feature " + FeatureQuery.this.featureName + " doesn't exist.", new Explanation[0]);
                }
                PostingsEnum postings = termsEnum.postings(null, 8);
                if (postings.advance(doc) != doc) {
                    return Explanation.noMatch(desc + ". Feature " + FeatureQuery.this.featureName + " isn't set.", new Explanation[0]);
                }
                return FeatureQuery.this.function.explain(FeatureQuery.this.fieldName, FeatureQuery.this.featureName, boost, doc, postings.freq());
            }

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                Terms terms = context.reader().terms(FeatureQuery.this.fieldName);
                if (terms == null) {
                    return null;
                }
                TermsEnum termsEnum = terms.iterator();
                if (!termsEnum.seekExact(new BytesRef(FeatureQuery.this.featureName))) {
                    return null;
                }
                final Similarity.SimScorer scorer = FeatureQuery.this.function.scorer(FeatureQuery.this.fieldName, boost);
                final PostingsEnum postings = termsEnum.postings(null, 8);
                return new Scorer(this){

                    @Override
                    public int docID() {
                        return postings.docID();
                    }

                    @Override
                    public float score() throws IOException {
                        return scorer.score(postings.docID(), postings.freq());
                    }

                    @Override
                    public DocIdSetIterator iterator() {
                        return postings;
                    }
                };
            }
        };
    }

    @Override
    public String toString(String field) {
        return "FeatureQuery(field=" + this.fieldName + ", feature=" + this.featureName + ", function=" + this.function + ")";
    }
}

