/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.core.commands;

import org.eclipse.birt.report.designer.core.DesignerConstants;
import org.eclipse.birt.report.designer.core.model.schematic.HandleAdapterFactory;
import org.eclipse.birt.report.designer.core.model.schematic.TableHandleAdapter;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.ColumnHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.gef.commands.Command;

public class DeleteColumnCommand
extends Command {
    private ColumnHandle handle = null;

    public DeleteColumnCommand(Object model) {
        assert (model instanceof ColumnHandle);
        this.handle = (ColumnHandle)model;
    }

    public void execute() {
        block5: {
            if (this.getTableParent() != null) {
                if (DesignerConstants.TRACING_COMMANDS) {
                    System.out.println("DeleteColumnCommand >> Starts. Target: " + DEUtil.getDisplayLabel(this.getTableParent()));
                }
                TableHandleAdapter tableHandle = HandleAdapterFactory.getInstance().getTableHandleAdapter(this.getTableParent());
                int columnNumber = HandleAdapterFactory.getInstance().getColumnHandleAdapter(this.handle).getColumnNumber();
                try {
                    tableHandle.deleteColumn(new int[]{columnNumber});
                    if (DesignerConstants.TRACING_COMMANDS) {
                        System.out.println("DeleteColumnCommand >> Finished. ");
                    }
                }
                catch (SemanticException semanticException) {
                    if (!DesignerConstants.TRACING_COMMANDS) break block5;
                    System.out.println("DeleteColumnCommand >> Failed. ");
                }
            }
        }
    }

    private Object getTableParent() {
        DesignElementHandle parent = this.handle.getContainer();
        while (parent != null) {
            if (parent instanceof TableHandle || parent instanceof GridHandle) {
                return parent;
            }
            parent = parent.getContainer();
        }
        return null;
    }

    public boolean canExecute() {
        return super.canExecute() && this.handle.canDrop();
    }
}

