/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.core.util.mediator;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.designer.core.DesignerConstants;
import org.eclipse.birt.report.designer.core.util.mediator.IColleague;
import org.eclipse.birt.report.designer.core.util.mediator.IMediatorState;
import org.eclipse.birt.report.designer.core.util.mediator.request.ReportRequest;

public class ReportMediator {
    private boolean isDispatching = false;
    private List listeners = new ArrayList();
    private List stack = new ArrayList();
    private int stackPointer = 0;
    private ReportMediatorState currentState = new ReportMediatorState();
    private static List globalListener = new ArrayList();

    public static void addGlobalColleague(IColleague colleague) {
        if (!globalListener.contains(colleague)) {
            if (DesignerConstants.TRACING_MEDIATOR_GLOBAL_COLLEAGUE_ADD) {
                System.out.println("ReportMediator >> Add a new global colleage: " + colleague);
            }
            globalListener.add(colleague);
        }
    }

    public void addColleague(IColleague colleague) {
        if (!this.listeners.contains(colleague)) {
            if (DesignerConstants.TRACING_MEDIATOR_COLLEAGUE_ADD) {
                System.out.println("ReportMediator >> Add a new colleage: " + colleague);
            }
            this.listeners.add(colleague);
        }
    }

    public void removeColleague(IColleague colleague) {
        if (DesignerConstants.TRACING_MEDIATOR_COLLEAGUE_REMOVE) {
            System.out.println("ReportMediator >> Remove a colleage: " + colleague);
        }
        this.listeners.remove(colleague);
    }

    public static void removeGlobalColleague(IColleague colleague) {
        if (DesignerConstants.TRACING_MEDIATOR_GLOBAL_COLLEAGUE_REMOVE) {
            System.out.println("ReportMediator >> Remove a global colleage: " + colleague);
        }
        globalListener.remove(colleague);
    }

    public void notifyRequest(ReportRequest request) {
        IColleague colleague;
        if (this.isDispatching) {
            return;
        }
        if (DesignerConstants.TRACING_MEDIATOR_NOTIFY) {
            System.out.println("ReportMediator >> Notify a " + request.getType() + "request from " + request.getSource());
        }
        this.isDispatching = true;
        if (this.isInterestRequest(request)) {
            this.currentState.copyFrom(this.convertRequestToState(request));
        }
        int size = this.listeners.size();
        int i = 0;
        while (i < size) {
            colleague = (IColleague)this.listeners.get(i);
            colleague.performRequest(request);
            ++i;
        }
        size = globalListener.size();
        i = 0;
        while (i < size) {
            colleague = (IColleague)globalListener.get(i);
            colleague.performRequest(request);
            ++i;
        }
        this.isDispatching = false;
    }

    private boolean isInterestRequest(ReportRequest request) {
        return "selection".equals(request.getType());
    }

    public void dispose() {
        if (DesignerConstants.TRACING_MEDIATOR_DISPOSE) {
            System.out.println("ReportMediator >> Disposing ...");
        }
        this.currentState = null;
        this.listeners.clear();
        this.stackPointer = 0;
        this.stack = null;
        if (DesignerConstants.TRACING_MEDIATOR_DISPOSE) {
            System.out.println("ReportMediator >> Disposed");
        }
    }

    public void popState() {
        if (DesignerConstants.TRACING_MEDIATOR_STATE_POP) {
            System.out.println("ReportMediator >> Poping state . . .");
        }
        --this.stackPointer;
        if (this.stackPointer != 0) {
            this.restoreState((ReportMediatorState)this.stack.get(this.stackPointer));
        }
        if (this.stackPointer == 0) {
            this.stack.clear();
        }
        if (DesignerConstants.TRACING_MEDIATOR_STATE_POP) {
            System.out.println("ReportMediator >> Poping finished");
        }
    }

    public IMediatorState getCurrentState() {
        return this.currentState;
    }

    public void pushState() {
        if (DesignerConstants.TRACING_MEDIATOR_STATE_PUSH) {
            System.out.print("ReportMediator >> Pushing state . . .");
        }
        try {
            if (this.stack.size() > this.stackPointer) {
                ReportMediatorState s = (ReportMediatorState)this.stack.get(this.stackPointer);
                s.copyFrom(this.currentState);
            } else {
                this.stack.add(this.currentState.clone());
            }
            ++this.stackPointer;
        }
        catch (CloneNotSupportedException e) {
            if (DesignerConstants.TRACING_MEDIATOR_STATE_PUSH) {
                System.out.println("ReportMediator >> Pushing failed");
            }
            throw new RuntimeException(e.getMessage());
        }
        if (DesignerConstants.TRACING_MEDIATOR_STATE_PUSH) {
            System.out.println("ReportMediator >> Pushing finished");
        }
    }

    private ReportMediatorState convertRequestToState(ReportRequest request) {
        ReportMediatorState retValue = new ReportMediatorState();
        retValue.setSource(request.getSource());
        retValue.setSelectiobObject(request.getSelectionModelList());
        return retValue;
    }

    private ReportRequest convertStateToRequest(ReportMediatorState s) {
        ReportRequest request = new ReportRequest();
        request.setSource(s.getSource());
        request.setSelectionObject(s.getSelectionObject());
        return request;
    }

    public void restoreState() {
        this.restoreState((ReportMediatorState)this.stack.get(this.stackPointer - 1));
    }

    protected void restoreState(ReportMediatorState s) {
        if (DesignerConstants.TRACING_MEDIATOR_STATE_RESTORE) {
            System.out.println("ReportMediator >> Restoring state ...");
        }
        this.currentState.copyFrom(s);
        ReportRequest request = this.convertStateToRequest(s);
        this.notifyRequest(request);
        if (DesignerConstants.TRACING_MEDIATOR_STATE_RESTORE) {
            System.out.println("ReportMediator >> Restoring finised.");
        }
    }

    protected static class ReportMediatorState
    implements Cloneable,
    IMediatorState {
        private List selectiobObject = new ArrayList();
        private Object source;

        protected ReportMediatorState() {
        }

        public Object clone() throws CloneNotSupportedException {
            ReportMediatorState state = new ReportMediatorState();
            state.setSelectiobObject(this.getSelectionObject());
            return state;
        }

        protected void copyFrom(ReportMediatorState state) {
            this.setSelectiobObject(state.getSelectionObject());
            this.setSource(state.getSource());
        }

        @Override
        public List getSelectionObject() {
            return this.selectiobObject;
        }

        protected void setSelectiobObject(List selectiobObject) {
            this.selectiobObject = selectiobObject;
        }

        @Override
        public Object getSource() {
            return this.source;
        }

        protected void setSource(Object source) {
            this.source = source;
        }
    }
}

