/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service.command.output;

import java.util.ArrayList;
import org.eclipse.cdt.dsf.gdb.service.IGDBHardwareAndOS2;
import org.eclipse.cdt.dsf.mi.service.command.output.MIConst;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIList;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResult;
import org.eclipse.cdt.dsf.mi.service.command.output.MITuple;
import org.eclipse.cdt.dsf.mi.service.command.output.MIValue;

public class MIInfoOsInfo
extends MIInfo {
    private IGDBHardwareAndOS2.IResourceClass[] resourceClasses;
    private String[] columnNames;
    private String[][] content;

    public MIInfoOsInfo(MIOutput record, boolean resourcesInformation) {
        super(record);
        if (this.isDone()) {
            if (resourcesInformation) {
                this.parseResourcesInformation();
            } else {
                this.parseResourceClasses();
            }
        }
    }

    public IGDBHardwareAndOS2.IResourcesInformation getResourcesInformation() {
        return new IGDBHardwareAndOS2.IResourcesInformation(){

            @Override
            public String[][] getContent() {
                return MIInfoOsInfo.this.content;
            }

            @Override
            public String[] getColumnNames() {
                return MIInfoOsInfo.this.columnNames;
            }
        };
    }

    public IGDBHardwareAndOS2.IResourceClass[] getResourceClasses() {
        return this.resourceClasses;
    }

    private void parseResourceClasses() {
        ArrayList<2> classes = new ArrayList<2>();
        MITuple table = (MITuple)this.get(this.getMIOutput(), "OSDataTable");
        MIList body = (MIList)this.get(table, "body");
        MIResult[] mIResultArray = body.getMIResults();
        int n = mIResultArray.length;
        int n2 = 0;
        while (n2 < n) {
            MIResult r = mIResultArray[n2];
            MITuple row = (MITuple)r.getMIValue();
            final String id = this.getString(row.getMIResults()[0]);
            final String description = this.getString(row.getMIResults()[2]);
            classes.add(new IGDBHardwareAndOS2.IResourceClass(){

                @Override
                public String getId() {
                    return id;
                }

                @Override
                public String getHumanDescription() {
                    return description;
                }
            });
            ++n2;
        }
        this.resourceClasses = classes.toArray(new IGDBHardwareAndOS2.IResourceClass[classes.size()]);
    }

    private void parseResourcesInformation() {
        MITuple table = (MITuple)this.get(this.getMIOutput(), "OSDataTable");
        MIList header = (MIList)this.get(table, "hdr");
        this.columnNames = new String[header.getMIValues().length];
        int i = 0;
        MIValue[] mIValueArray = header.getMIValues();
        int n = mIValueArray.length;
        int n2 = 0;
        while (n2 < n) {
            MIValue v = mIValueArray[n2];
            MITuple column = (MITuple)v;
            String columnName = ((MIConst)this.get(column, "colhdr")).getString();
            this.columnNames[i++] = String.valueOf(Character.toUpperCase(columnName.charAt(0))) + columnName.substring(1);
            ++n2;
        }
        MIList body = (MIList)this.get(table, "body");
        if (body == null) {
            this.content = new String[0][];
            return;
        }
        this.content = new String[body.getMIResults().length][];
        i = 0;
        MIResult[] mIResultArray = body.getMIResults();
        int n3 = mIResultArray.length;
        n = 0;
        while (n < n3) {
            MIResult r = mIResultArray[n];
            MITuple row = (MITuple)r.getMIValue();
            assert (row.getMIResults().length == this.columnNames.length);
            String[] rowStrings = new String[row.getMIResults().length];
            int j = 0;
            MIResult[] mIResultArray2 = row.getMIResults();
            int n4 = mIResultArray2.length;
            int n5 = 0;
            while (n5 < n4) {
                MIResult r2 = mIResultArray2[n5];
                rowStrings[j] = ((MIConst)r2.getMIValue()).getString();
                ++j;
                ++n5;
            }
            this.content[i++] = rowStrings;
            ++n;
        }
    }

    private MIValue get(MIResult[] results, String name) {
        MIResult[] mIResultArray = results;
        int n = results.length;
        int n2 = 0;
        while (n2 < n) {
            MIResult r = mIResultArray[n2];
            if (r.getVariable().equals(name)) {
                return r.getMIValue();
            }
            ++n2;
        }
        return null;
    }

    private MIValue get(MIOutput output, String name) {
        return this.get(output.getMIResultRecord().getMIResults(), name);
    }

    private MIValue get(MITuple tuple, String name) {
        return this.get(tuple.getMIResults(), name);
    }

    private String getString(MIValue value) {
        return ((MIConst)value).getString();
    }

    private String getString(MIResult result) {
        return this.getString(result.getMIValue());
    }
}

