/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.model;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.model.DsfMemoryBlock;
import org.eclipse.cdt.dsf.debug.service.IExpressions;
import org.eclipse.cdt.dsf.debug.service.IFormattedValues;
import org.eclipse.cdt.dsf.debug.service.IMemory;
import org.eclipse.cdt.dsf.internal.DsfPlugin;
import org.eclipse.cdt.dsf.service.DsfServices;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.core.model.IMemoryBlockRetrievalExtension;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.util.tracker.ServiceTracker;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DsfMemoryBlockRetrieval
extends PlatformObject
implements IMemoryBlockRetrievalExtension {
    private static final String DEFAULT_ATTR_DEBUGGER_MEMORY_BLOCKS_VALUE = "";
    private final String fModelId;
    private final DsfSession fSession;
    private final DsfExecutor fExecutor;
    private final String fContextString;
    private final ServiceTracker<IMemory, IMemory> fMemoryServiceTracker;
    private final ServiceTracker<IExpressions, IExpressions> fExpressionServiceTracker;
    private final ILaunchConfiguration fLaunchConfig;
    private final ILaunch fLaunch;
    private final IDebugTarget fDebugTarget;
    private final boolean fSupportsValueModification;
    private final boolean fSupportBaseAddressModification;
    private final int fAddressSize;
    private final int fWordSize;
    private static final String DSF_LAUNCH_ID = "org.eclipse.dsf.launch";
    private static final String ATTR_DEBUGGER_MEMORY_BLOCKS = "org.eclipse.dsf.launch.MEMORY_BLOCKS";
    private static final String MEMORY_BLOCK_EXPRESSION_LIST = "memoryBlockExpressionList";
    private static final String ATTR_EXPRESSION_LIST_CONTEXT = "context";
    private static final String MEMORY_BLOCK_EXPRESSION = "memoryBlockExpression";
    private static final String ATTR_MEMORY_BLOCK_EXPR_LABEL = "label";
    private static final String ATTR_MEMORY_BLOCK_EXPR_ADDRESS = "address";

    public DsfMemoryBlockRetrieval(String modelId, ILaunchConfiguration config, DsfSession session) throws DebugException {
        this.fModelId = modelId;
        this.fContextString = "Context string";
        this.fSession = session;
        if (this.fSession == null) {
            throw new IllegalArgumentException("Session " + session + " is not active");
        }
        this.fExecutor = this.fSession.getExecutor();
        BundleContext bundle = DsfPlugin.getBundleContext();
        String memoryServiceFilter = DsfServices.createServiceFilter(IMemory.class, session.getId());
        try {
            this.fMemoryServiceTracker = new ServiceTracker(bundle, bundle.createFilter(memoryServiceFilter), null);
        }
        catch (InvalidSyntaxException e) {
            throw new DebugException((IStatus)new Status(4, "org.eclipse.cdt.dsf", 5013, "Error creating service filter.", (Throwable)e));
        }
        this.fMemoryServiceTracker.open();
        String expressionServiceFilter = "(&(OBJECTCLASS=" + IExpressions.class.getName() + ")" + "(" + "org.eclipse.cdt.dsf.service.IService.session_id" + "=" + session.getId() + ")" + ")";
        try {
            this.fExpressionServiceTracker = new ServiceTracker(bundle, bundle.createFilter(expressionServiceFilter), null);
        }
        catch (InvalidSyntaxException e) {
            throw new DebugException((IStatus)new Status(4, "org.eclipse.cdt.dsf", 5013, "Error creating service filter.", (Throwable)e));
        }
        this.fExpressionServiceTracker.open();
        this.fLaunchConfig = config;
        this.fLaunch = null;
        this.fDebugTarget = null;
        this.fAddressSize = 4;
        this.fWordSize = 1;
        this.fSupportsValueModification = true;
        this.fSupportBaseAddressModification = false;
    }

    public void initialize(final IMemory.IMemoryDMContext memoryCtx) {
        try {
            final String memento = this.fLaunchConfig.getAttribute(ATTR_DEBUGGER_MEMORY_BLOCKS, DEFAULT_ATTR_DEBUGGER_MEMORY_BLOCKS_VALUE);
            if (memento != null && memento.trim().length() != 0) {
                this.getExecutor().submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            DsfMemoryBlockRetrieval.this.createBlocksFromConfiguration(memoryCtx, memento);
                        }
                        catch (CoreException e) {
                            DsfPlugin.getDefault().getLog().log(e.getStatus());
                        }
                    }
                });
            }
        }
        catch (CoreException e) {
            DsfPlugin.getDefault().getLog().log(e.getStatus());
        }
    }

    protected void createBlocksFromConfiguration(IMemory.IMemoryDMContext memoryCtx, String memento) throws CoreException {
        Element root = DebugPlugin.parseDocument((String)memento);
        if (!root.getNodeName().equalsIgnoreCase(MEMORY_BLOCK_EXPRESSION_LIST)) {
            Status status = new Status(4, "org.eclipse.cdt.dsf", 120, "Memory monitor initialization: invalid memento", null);
            throw new CoreException((IStatus)status);
        }
        if (root.getAttribute(ATTR_EXPRESSION_LIST_CONTEXT).equals(this.fContextString)) {
            ArrayList<DsfMemoryBlock> blocks = new ArrayList<DsfMemoryBlock>();
            NodeList expressionList = root.getChildNodes();
            int length = expressionList.getLength();
            int i = 0;
            while (i < length) {
                Element entry;
                Node node = expressionList.item(i);
                if (node.getNodeType() == 1 && (entry = (Element)node).getNodeName().equalsIgnoreCase(MEMORY_BLOCK_EXPRESSION)) {
                    String label = entry.getAttribute(ATTR_MEMORY_BLOCK_EXPR_LABEL);
                    String address = entry.getAttribute(ATTR_MEMORY_BLOCK_EXPR_ADDRESS);
                    BigInteger blockAddress = new BigInteger(address);
                    DsfMemoryBlock block = new DsfMemoryBlock(this, memoryCtx, this.fModelId, label, blockAddress, this.fWordSize, 0L);
                    blocks.add(block);
                }
                ++i;
            }
            DebugPlugin.getDefault().getMemoryBlockManager().addMemoryBlocks(blocks.toArray(new IMemoryBlock[blocks.size()]));
        }
    }

    public void saveMemoryBlocks() {
        try {
            ILaunchConfigurationWorkingCopy wc = this.fLaunchConfig.getWorkingCopy();
            String newValue = this.getMemento();
            String oldValue = DEFAULT_ATTR_DEBUGGER_MEMORY_BLOCKS_VALUE;
            try {
                oldValue = wc.getAttribute(ATTR_DEBUGGER_MEMORY_BLOCKS, DEFAULT_ATTR_DEBUGGER_MEMORY_BLOCKS_VALUE);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            if (!Objects.equals(oldValue, newValue)) {
                wc.setAttribute(ATTR_DEBUGGER_MEMORY_BLOCKS, newValue);
                wc.doSave();
            }
        }
        catch (CoreException e) {
            DsfPlugin.getDefault().getLog().log(e.getStatus());
        }
    }

    public String getMemento() throws CoreException {
        IMemoryBlock[] blocks = DebugPlugin.getDefault().getMemoryBlockManager().getMemoryBlocks((IMemoryBlockRetrieval)this);
        Document document = DebugPlugin.newDocument();
        Element expressionList = document.createElement(MEMORY_BLOCK_EXPRESSION_LIST);
        expressionList.setAttribute(ATTR_EXPRESSION_LIST_CONTEXT, this.fContextString);
        IMemoryBlock[] iMemoryBlockArray = blocks;
        int n = blocks.length;
        int n2 = 0;
        while (n2 < n) {
            IMemoryBlock block = iMemoryBlockArray[n2];
            if (block instanceof IMemoryBlockExtension) {
                IMemoryBlockExtension memoryBlock = (IMemoryBlockExtension)block;
                Element expression = document.createElement(MEMORY_BLOCK_EXPRESSION);
                expression.setAttribute(ATTR_MEMORY_BLOCK_EXPR_LABEL, memoryBlock.getExpression());
                expression.setAttribute(ATTR_MEMORY_BLOCK_EXPR_ADDRESS, memoryBlock.getBigBaseAddress().toString());
                expressionList.appendChild(expression);
            }
            ++n2;
        }
        document.appendChild(expressionList);
        return DebugPlugin.serializeDocument((Document)document);
    }

    public DsfSession getSession() {
        return this.fSession;
    }

    public DsfExecutor getExecutor() {
        return this.fExecutor;
    }

    public ServiceTracker<IMemory, IMemory> getServiceTracker() {
        return this.fMemoryServiceTracker;
    }

    public ILaunch getLaunch() {
        return this.fLaunch;
    }

    public IDebugTarget getDebugTarget() {
        return this.fDebugTarget;
    }

    public int getAddressSize() {
        return this.fAddressSize;
    }

    public int getAddressableSize() {
        return this.fWordSize;
    }

    public boolean supportsValueModification() {
        return this.fSupportsValueModification;
    }

    public boolean supportBaseAddressModification() {
        return this.fSupportBaseAddressModification;
    }

    public boolean supportsStorageRetrieval() {
        return true;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        throw new DebugException((IStatus)new Status(4, "org.eclipse.cdt.dsf", 5011, "getMemoryBlock() not supported, use getExtendedMemoryBlock()", null));
    }

    public IMemoryBlockExtension getExtendedMemoryBlock(String expression, Object context) throws DebugException {
        BigInteger blockAddress;
        IMemory.IMemoryDMContext memoryDmc;
        block9: {
            memoryDmc = null;
            IDMContext dmc = null;
            if (context instanceof IAdaptable && (dmc = (IDMContext)((IAdaptable)context).getAdapter(IDMContext.class)) != null) {
                memoryDmc = DMContexts.getAncestorOfType(dmc, IMemory.IMemoryDMContext.class);
            }
            if (memoryDmc == null) {
                return null;
            }
            try {
                int base = 10;
                int offset = 0;
                if (expression.startsWith("0x") || expression.startsWith("0X")) {
                    base = 16;
                    offset = 2;
                } else if (expression.startsWith("0b")) {
                    base = 2;
                    offset = 2;
                } else if (expression.startsWith("0")) {
                    base = 8;
                    offset = 1;
                }
                blockAddress = new BigInteger(expression.substring(offset), base);
            }
            catch (NumberFormatException nfexc) {
                blockAddress = this.resolveMemoryAddress(dmc, expression);
                if (blockAddress != null) break block9;
                return null;
            }
        }
        return new DsfMemoryBlock(this, memoryDmc, this.fModelId, expression, blockAddress, this.fWordSize, 0L);
    }

    protected BigInteger resolveMemoryAddress(final IDMContext dmc, final String expression) throws DebugException {
        Query<BigInteger> query = new Query<BigInteger>(){

            @Override
            protected void execute(final DataRequestMonitor<BigInteger> drm) {
                IExpressions expressionService = (IExpressions)DsfMemoryBlockRetrieval.this.fExpressionServiceTracker.getService();
                if (expressionService != null) {
                    IExpressions.IExpressionDMContext expressionDMC = expressionService.createExpression(dmc, expression);
                    String formatId = "HEX.Format";
                    IFormattedValues.FormattedValueDMContext valueDmc = expressionService.getFormattedValueContext(expressionDMC, formatId);
                    expressionService.getFormattedExpressionValue(valueDmc, new DataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)DsfMemoryBlockRetrieval.this.getExecutor(), drm){

                        @Override
                        protected void handleSuccess() {
                            try {
                                String value = ((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue().substring(2);
                                drm.setData(new BigInteger(value, 16));
                            }
                            catch (IndexOutOfBoundsException e) {
                                this.setFormatError(e);
                            }
                            catch (NumberFormatException e) {
                                this.setFormatError(e);
                            }
                            drm.done();
                        }

                        private void setFormatError(Exception e) {
                            drm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf", 10005, "The result of expression evaluation \"" + ((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue() + "\" is not formatted correctly.", (Throwable)e));
                        }
                    });
                }
            }
        };
        this.fExecutor.execute(query);
        try {
            return (BigInteger)query.get();
        }
        catch (InterruptedException e) {
            throw new DebugException((IStatus)new Status(4, "org.eclipse.cdt.dsf", 5013, "Error evaluating memory address (InterruptedException).", (Throwable)e));
        }
        catch (ExecutionException e) {
            throw new DebugException((IStatus)new Status(4, "org.eclipse.cdt.dsf", 5013, "Error evaluating memory address (ExecutionException).", (Throwable)e));
        }
    }

    protected String getModelId() {
        return this.fModelId;
    }
}

