/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.wizards.settingswizards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.internal.ui.wizards.settingswizards.SettingsImportExportException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XMLUtils {
    private XMLUtils() {
    }

    public static List<Element> extractChildElements(Element node, String childElementName) throws SettingsImportExportException {
        ArrayList<Element> extracted = new ArrayList<Element>();
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            switch (child.getNodeType()) {
                case 1: {
                    Element element = (Element)child;
                    if (element.getTagName().equals(childElementName)) {
                        extracted.add(element);
                        break;
                    }
                    throw new SettingsImportExportException("Unknown tag: " + element.getTagName());
                }
                case 3: {
                    Text text = (Text)child;
                    if (XMLUtils.isWhitespace(text.getData())) break;
                    throw new SettingsImportExportException("Unknown text: '" + text.getData() + "'");
                }
                default: {
                    throw new SettingsImportExportException("Unknown node: " + child.getNodeName());
                }
            }
            ++i;
        }
        return extracted;
    }

    public static boolean isWhitespace(String s) {
        if (s == null) {
            return false;
        }
        char[] cArray = s.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!Character.isWhitespace(c)) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

