/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.wizards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cft.server.ui.ICloudFoundryServiceWizardIconProvider;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.cft.server.ui.internal.wizards.AvailableService;
import org.eclipse.cft.server.ui.internal.wizards.CFServiceWizardDynamicIconLoader;
import org.eclipse.cft.server.ui.internal.wizards.CloudFoundryServiceWizardIconProviderRegistry;
import org.eclipse.cft.server.ui.internal.wizards.CloudFoundryServiceWizardPage;
import org.eclipse.cft.server.ui.internal.wizards.ServiceInstance;
import org.eclipse.cft.server.ui.internal.wizards.TextCompositeLayout;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wst.server.core.IRuntime;

public class CloudFoundryServiceWizardPageLeftPanel {
    List<AvailableService> availableServices = new ArrayList<AvailableService>();
    List<AvailableService> selectedServices = new ArrayList<AvailableService>();
    protected Color selEdgeColor;
    protected Color selFillColor;
    ScrolledComposite scrollComp;
    Composite layoutList;
    private Button clearButton;
    private Button addButton;
    private Text filterText;
    private Widget currFocus = null;
    CloudFoundryServiceWizardPage parent;
    private ServiceListTraverseListener traverseListener = new ServiceListTraverseListener();
    CFServiceWizardDynamicIconLoader loader;
    private static final boolean LABEL_FOCUS_SUPPORTED = !System.getProperty("os.name").toLowerCase().contains("linux");
    private Font boldFont;
    private String filterTerm = null;

    public CloudFoundryServiceWizardPageLeftPanel(CloudFoundryServiceWizardPage parent) {
        this.parent = parent;
    }

    private Composite createFilterComp(Composite parent) {
        Composite filterComp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        filterComp.setLayout((Layout)layout);
        Label filterLabel = new Label(filterComp, 0);
        filterLabel.setText(Messages.CloudFoundryServiceWizardPageLeftPanel_FILTER_TITLE);
        GridData data = new GridData(1, 2, false, false);
        filterLabel.setLayoutData((Object)data);
        this.filterText = new Text(filterComp, 128);
        this.filterText.setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        this.filterText.setMessage(Messages.CloudFoundryServiceWizardPageLeftPanel_DEFAULT_FILTER_TEXT);
        this.setCurrFocus((Widget)this.filterText);
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CloudFoundryServiceWizardPageLeftPanel.this.setCurrFocus((Widget)CloudFoundryServiceWizardPageLeftPanel.this.filterText);
                String text = CloudFoundryServiceWizardPageLeftPanel.this.filterText.getText();
                if (Messages.CloudFoundryServiceWizardPageLeftPanel_DEFAULT_FILTER_TEXT.equals(text)) {
                    CloudFoundryServiceWizardPageLeftPanel.this.filterTerm = null;
                } else {
                    CloudFoundryServiceWizardPageLeftPanel.this.filterTerm = CloudFoundryServiceWizardPageLeftPanel.this.filterText.getText().trim();
                }
                CloudFoundryServiceWizardPageLeftPanel.this.updateServiceList();
            }
        });
        this.filterText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                CloudFoundryServiceWizardPageLeftPanel.this.setCurrFocus((Widget)CloudFoundryServiceWizardPageLeftPanel.this.filterText);
            }
        });
        MouseWheelListener mwl = new MouseWheelListener(){

            public void mouseScrolled(MouseEvent event) {
                CloudFoundryServiceWizardPageLeftPanel.this.scrollComp.setFocus();
            }
        };
        this.filterText.addMouseWheelListener(mwl);
        this.filterText.addTraverseListener((TraverseListener)this.traverseListener);
        if (!LABEL_FOCUS_SUPPORTED) {
            this.filterText.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (e.keyCode == 0x1000005 || e.keyCode == 0x1000006 || e.keyCode == 0x1000007 || e.keyCode == 0x1000008) {
                        CloudFoundryServiceWizardPageLeftPanel.this.handleServiceKeyEvent(e);
                    }
                }
            });
        }
        return filterComp;
    }

    public Group createMainWindowComposite(Composite parent) {
        IRuntime runtime = this.parent.getCloudServer().getServer().getRuntime();
        String runtimeTypeId = runtime.getRuntimeType().getId();
        ICloudFoundryServiceWizardIconProvider provider = CloudFoundryServiceWizardIconProviderRegistry.getInstance().getIconProvider(runtimeTypeId);
        if (provider != null) {
            this.loader = new CFServiceWizardDynamicIconLoader(provider, this.parent.getCloudServer());
            this.loader.start();
        }
        GridLayout gridLayout = new GridLayout(3, false);
        Group group = new Group(parent, 4);
        group.setText(Messages.CloudFoundryServiceWizardPageLeftPanel_AVAILABLE_SERVICES);
        group.setLayout((Layout)gridLayout);
        Composite filterComp = this.createFilterComp((Composite)group);
        GridData gd = new GridData(4, -1, true, false, 3, 1);
        filterComp.setLayoutData((Object)gd);
        this.scrollComp = new ScrolledComposite((Composite)group, 512);
        gd = new GridData(4, 4, true, true, 3, 1);
        this.scrollComp.setLayoutData((Object)gd);
        this.scrollComp.setAlwaysShowScrollBars(false);
        this.scrollComp.setBackground(this.scrollComp.getDisplay().getSystemColor(25));
        this.scrollComp.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                Control c = CloudFoundryServiceWizardPageLeftPanel.this.scrollComp.getContent();
                if (c == null) {
                    return;
                }
                Rectangle r = CloudFoundryServiceWizardPageLeftPanel.this.scrollComp.getClientArea();
                r.height = c.computeSize((int)r.width, (int)-1).y;
                c.setBounds(r);
            }
        });
        this.layoutList = this.createLayoutList((Composite)this.scrollComp);
        this.scrollComp.setContent((Control)this.layoutList);
        Label emptyLabel = new Label((Composite)group, 0);
        emptyLabel.setText("");
        gd = new GridData(4, 0x1000000, true, false, 1, 1);
        emptyLabel.setLayoutData((Object)gd);
        this.clearButton = new Button((Composite)group, 8);
        this.clearButton.setText(Messages.CloudFoundryServiceWizardPageLeftPanel_CLEAR);
        gd = new GridData(131072, 0x1000000, false, false, 1, 1);
        this.clearButton.setLayoutData((Object)gd);
        this.clearButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CloudFoundryServiceWizardPageLeftPanel.this.deselectServices(CloudFoundryServiceWizardPageLeftPanel.this.selectedServices);
                CloudFoundryServiceWizardPageLeftPanel.this.selectedServices.clear();
                CloudFoundryServiceWizardPageLeftPanel.this.addButton.setEnabled(false);
                CloudFoundryServiceWizardPageLeftPanel.this.clearButton.setEnabled(false);
                CloudFoundryServiceWizardPageLeftPanel.this.layoutList.redraw();
            }
        });
        this.clearButton.setEnabled(false);
        this.addButton = new Button((Composite)group, 8);
        this.addButton.setText(Messages.CloudFoundryServiceWizardPageLeftPanel_ADD);
        gd = new GridData(131072, 0x1000000, false, false, 1, 1);
        this.addButton.setLayoutData((Object)gd);
        this.addButton.setEnabled(false);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List visibleSelectedServices = CloudFoundryServiceWizardPageLeftPanel.utilGetVisibleServices(CloudFoundryServiceWizardPageLeftPanel.this.selectedServices);
                if (visibleSelectedServices.size() > 0) {
                    CloudFoundryServiceWizardPageLeftPanel.this.createNewServiceInstances(visibleSelectedServices.toArray(new AvailableService[visibleSelectedServices.size()]));
                }
            }
        });
        this.clearButton.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 8 && CloudFoundryServiceWizardPageLeftPanel.this.selectedServices.size() > 0) {
                    CloudFoundryServiceWizardPageLeftPanel.this.selectedServices.get(0).getNameLabel().forceFocus();
                    e.doit = false;
                }
            }
        });
        return group;
    }

    private Composite createLayoutList(Composite parent) {
        Composite result = new Composite(parent, 0);
        result.setBackground(parent.getDisplay().getSystemColor(25));
        Display display = result.getDisplay();
        Font font = result.getFont();
        if (this.boldFont == null) {
            FontData[] fontData = font.getFontData();
            fontData[0].setStyle(1);
            fontData[0].setHeight(fontData[0].getHeight());
            this.boldFont = new Font((Device)display, fontData);
            Color c1 = display.getSystemColor(26);
            Color c2 = display.getSystemColor(25);
            this.selEdgeColor = new Color((Device)display, (c1.getRed() + c2.getRed() * 3) / 4, (c1.getGreen() + c2.getGreen() * 3) / 4, (c1.getBlue() + c2.getBlue() * 3) / 4);
            double blendFactor = Display.getCurrent().getHighContrast() ? 0.3 : 0.1;
            double red = (double)c1.getRed() * blendFactor + (double)c2.getRed() * (1.0 - blendFactor);
            double green = (double)c1.getGreen() * blendFactor + (double)c2.getGreen() * (1.0 - blendFactor);
            double blue = (double)c1.getBlue() * blendFactor + (double)c2.getBlue() * (1.0 - blendFactor);
            this.selFillColor = new Color((Device)display, (int)red, (int)green, (int)blue);
            result.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    if (CloudFoundryServiceWizardPageLeftPanel.this.boldFont != null && !CloudFoundryServiceWizardPageLeftPanel.this.boldFont.isDisposed()) {
                        CloudFoundryServiceWizardPageLeftPanel.this.boldFont.dispose();
                    }
                    if (CloudFoundryServiceWizardPageLeftPanel.this.selEdgeColor != null && !CloudFoundryServiceWizardPageLeftPanel.this.selEdgeColor.isDisposed()) {
                        CloudFoundryServiceWizardPageLeftPanel.this.selEdgeColor.dispose();
                    }
                    if (CloudFoundryServiceWizardPageLeftPanel.this.selFillColor != null && !CloudFoundryServiceWizardPageLeftPanel.this.selFillColor.isDisposed()) {
                        CloudFoundryServiceWizardPageLeftPanel.this.selFillColor.dispose();
                    }
                }
            });
        }
        result.setLayout((Layout)new TextCompositeLayout(this.loader != null));
        result.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                for (AvailableService service : CloudFoundryServiceWizardPageLeftPanel.this.selectedServices) {
                    Rectangle r;
                    if (!service.getNameLabel().isVisible() || (r = service.getAppxLocation()) == null) continue;
                    Rectangle r2 = new Rectangle(r.x, r.y, r.width, r.height);
                    r2.x -= 3;
                    r2.width += 6;
                    r2.y -= 3;
                    r2.height += 6;
                    event.gc.setBackground(CloudFoundryServiceWizardPageLeftPanel.this.selFillColor);
                    event.gc.fillRoundRectangle(r2.x, r2.y, r2.width, r2.height, 7, 7);
                    event.gc.setForeground(CloudFoundryServiceWizardPageLeftPanel.this.selEdgeColor);
                    event.gc.drawRoundRectangle(r2.x, r2.y, r2.width, r2.height, 7, 7);
                }
            }
        });
        return result;
    }

    public void createInnerLayoutList(final List<AvailableService> availableServices, Composite result) {
        this.availableServices = availableServices;
        Color color = result.getBackground();
        Control[] tabList = new Control[availableServices.size()];
        int x = 0;
        while (x < availableServices.size()) {
            final AvailableService service = availableServices.get(x);
            Label imgLabel = new Label(result, 0);
            imgLabel.setBackground(color);
            imgLabel.setData((Object)service);
            Label nameLabel = new Label(result, 64);
            nameLabel.setData((Object)service);
            nameLabel.setFont(this.boldFont);
            nameLabel.setBackground(color);
            if (this.loader != null) {
                this.loader.addIconToRetrieveList(service.getOffering(), imgLabel);
            }
            nameLabel.setText(service.getName());
            nameLabel.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    CloudFoundryServiceWizardPageLeftPanel.this.handleServiceKeyEvent(e);
                }
            });
            tabList[x] = nameLabel;
            nameLabel.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                public void getName(AccessibleEvent e) {
                    e.result = service.getName();
                }

                public void getDescription(AccessibleEvent e) {
                    e.result = service.getDesc();
                }
            });
            Label descLabel = new Label(result, 64);
            descLabel.setData((Object)service);
            descLabel.setBackground(color);
            String desc = service.getDesc();
            descLabel.setText(CloudFoundryServiceWizardPageLeftPanel.trimTextAtBound(desc, 200));
            service.setDescLabel(descLabel);
            service.setImageLabel(imgLabel);
            service.setNameLabel(nameLabel);
            imgLabel.addMouseListener((MouseListener)new CFAvailableServiceListener(service));
            nameLabel.addMouseListener((MouseListener)new CFAvailableServiceListener(service));
            descLabel.addMouseListener((MouseListener)new CFAvailableServiceListener(service));
            descLabel.setToolTipText(CloudFoundryServiceWizardPageLeftPanel.wrapAndTrimTextAtBound(desc, 100));
            ++x;
        }
        result.addMouseListener((MouseListener)new MouseAdapter(){

            private AvailableService getServiceAtClickPos(MouseEvent e, List<AvailableService> availableServices2) {
                AvailableService result = null;
                boolean foundExactMatch = false;
                for (AvailableService service : availableServices2) {
                    if (service.getAppxLocation() == null || !service.getAppxLocation().contains(e.x, e.y)) continue;
                    result = service;
                    foundExactMatch = true;
                    break;
                }
                if (!foundExactMatch) {
                    for (AvailableService service : availableServices2) {
                        int newY = Math.max(0, e.y - 10);
                        if (service.getAppxLocation() == null || !service.getAppxLocation().contains(e.x, newY)) continue;
                        result = service;
                        foundExactMatch = true;
                        break;
                    }
                }
                if (foundExactMatch) {
                    return result;
                }
                return null;
            }

            public void mouseDoubleClick(MouseEvent e) {
                boolean isMultiSelect = (e.stateMask & 0x40000) != 0;
                AvailableService service = this.getServiceAtClickPos(e, availableServices);
                if (service != null && !isMultiSelect) {
                    CloudFoundryServiceWizardPageLeftPanel.this.createNewServiceInstances(new AvailableService[]{service});
                }
            }

            public void mouseDown(MouseEvent e) {
                boolean isMultiSelect = (e.stateMask & 0x40000) != 0;
                AvailableService service = this.getServiceAtClickPos(e, availableServices);
                if (service != null) {
                    CloudFoundryServiceWizardPageLeftPanel.this.selectService(service, true, !isMultiSelect);
                }
            }
        });
        result.setTabList(tabList);
        Control[] controlArray = tabList;
        int n = tabList.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.addTraverseListener((TraverseListener)this.traverseListener);
            ++n2;
        }
    }

    private void handleServiceKeyEvent(KeyEvent e) {
        Widget currFocus = this.getCurrFocus();
        if (currFocus == this.filterText) {
            return;
        }
        if (e.keyCode == 0x1000007 || e.keyCode == 0x1000008) {
            List<AvailableService> visibleServices = CloudFoundryServiceWizardPageLeftPanel.utilGetVisibleServices(this.availableServices);
            if (visibleServices.size() > 0) {
                if (e.keyCode == 0x1000007) {
                    this.selectService(visibleServices.get(0), true, true);
                } else {
                    this.selectService(visibleServices.get(visibleServices.size() - 1), true, true);
                }
            }
            e.doit = false;
        }
        if (e.keyCode == 10 || e.keyCode == 13) {
            AvailableService currService = (AvailableService)((Label)currFocus).getData();
            for (AvailableService as : this.selectedServices) {
                if (as == currService) continue;
                this.createNewServiceInstances(new AvailableService[]{as});
            }
            this.createNewServiceInstances(new AvailableService[]{currService});
            e.doit = false;
        }
        if (e.keyCode == 0x1000005 || e.keyCode == 0x1000006) {
            this.handlePageUporDownOnService(e);
        }
    }

    private void handlePageUporDownOnService(KeyEvent e) {
        AvailableService currService = (AvailableService)((Label)this.currFocus).getData();
        int indexOfService = -1;
        ArrayList<AvailableService> visibleServices = new ArrayList<AvailableService>();
        for (AvailableService as : this.availableServices) {
            if (as.getNameLabel() == null || !as.getNameLabel().isVisible()) continue;
            visibleServices.add(as);
        }
        int x = 0;
        while (x < visibleServices.size()) {
            AvailableService as = (AvailableService)visibleServices.get(x);
            if (as == currService) {
                indexOfService = x;
                break;
            }
            ++x;
        }
        if (indexOfService != -1 && visibleServices.size() > 0) {
            indexOfService = e.keyCode == 0x1000005 ? Math.max(0, indexOfService - 5) : Math.min(visibleServices.size() - 1, indexOfService + 5);
            this.selectService((AvailableService)visibleServices.get(indexOfService), true, true);
        }
        e.doit = false;
    }

    private static List<AvailableService> utilGetVisibleServices(List<AvailableService> inputServices) {
        ArrayList<AvailableService> result = new ArrayList<AvailableService>();
        if (inputServices != null) {
            for (AvailableService s : inputServices) {
                if (s.getNameLabel() == null || !s.getNameLabel().isVisible()) continue;
                result.add(s);
            }
        }
        return result;
    }

    private int getNumberOfVisibleServices() {
        return CloudFoundryServiceWizardPageLeftPanel.utilGetVisibleServices(this.availableServices).size();
    }

    private void updateServiceList() {
        boolean emptyFilter = false;
        if (this.filterTerm == null || this.filterTerm.trim().length() == 0) {
            emptyFilter = true;
        }
        for (AvailableService service : this.availableServices) {
            boolean isVisible = emptyFilter || service.getName().toLowerCase().contains(this.filterTerm.toLowerCase()) || service.getDesc().toLowerCase().contains(this.filterTerm.toLowerCase());
            service.getImageLabel().setVisible(isVisible);
            service.getNameLabel().setVisible(isVisible);
            service.getDescLabel().setVisible(isVisible);
        }
        this.layoutList.layout();
        this.scrollComp.layout();
    }

    private void createNewServiceInstances(AvailableService[] services) {
        AvailableService[] availableServiceArray = services;
        int n = services.length;
        int n2 = 0;
        while (n2 < n) {
            AvailableService service = availableServiceArray[n2];
            List plans = service.getOffering().getServicePlans();
            ServiceInstance si = new ServiceInstance(service.getName(), plans, service.getOffering());
            si.setUserDefinedName(CloudFoundryServiceWizardPageLeftPanel.stripBadCharsFromServiceName(service.getName()));
            this.parent.getRight().addNewServiceInstance(si);
            ++n2;
        }
    }

    private static String stripBadCharsFromServiceName(String str) {
        if (str == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        int x = 0;
        while (x < str.length()) {
            char ch = str.charAt(x);
            if (Character.isLetterOrDigit(ch) || ch == '-' || ch == '_' || ch == '$') {
                result.append(ch);
            }
            ++x;
        }
        return result.toString();
    }

    private static String trimTextAtBound(String str, int bound) {
        if (str.length() > bound) {
            String result = CloudFoundryServiceWizardPageLeftPanel.wrapAndTrimTextAtBound(str, bound);
            int index = result.indexOf("\n");
            if (index == -1) {
                return str;
            }
            return String.valueOf(str.substring(0, index)) + "...";
        }
        return str;
    }

    private static String wrapAndTrimTextAtBound(String text, int bound) {
        StringBuilder result = new StringBuilder();
        String remainingString = text;
        int lastSpace = 0;
        int x = 0;
        while (x < remainingString.length()) {
            if (remainingString.charAt(x) == ' ') {
                lastSpace = x;
            }
            if (x == bound) {
                if (lastSpace == 0) {
                    return text;
                }
                String nextLine = remainingString.substring(0, lastSpace);
                remainingString = remainingString.substring(lastSpace).trim();
                result.append(nextLine);
                result.append("\n");
                x = 0;
                lastSpace = 0;
            }
            ++x;
        }
        result.append(remainingString.trim());
        return result.toString();
    }

    private void deselectServices(List<AvailableService> services) {
        for (AvailableService service : services) {
            service.getDescLabel().setBackground(this.layoutList.getBackground());
            service.getImageLabel().setBackground(this.layoutList.getBackground());
            service.getNameLabel().setBackground(this.layoutList.getBackground());
        }
    }

    public void dispose() {
        if (this.loader != null) {
            this.loader.dispose();
        }
    }

    private void selectService(AvailableService service, boolean scrollTo, boolean clearOtherSelections) {
        if (!this.selectedServices.contains(service)) {
            if (clearOtherSelections) {
                this.deselectServices(this.selectedServices);
                this.selectedServices.clear();
            }
            this.selectedServices.add(service);
        } else if (clearOtherSelections) {
            this.deselectServices(this.selectedServices);
            this.selectedServices.clear();
            this.selectedServices.add(service);
        } else {
            this.selectedServices.remove(service);
            this.addButton.setEnabled(this.selectedServices.size() > 0);
            this.clearButton.setEnabled(this.selectedServices.size() > 0);
            service.getDescLabel().setBackground(this.layoutList.getBackground());
            service.getImageLabel().setBackground(this.layoutList.getBackground());
            service.getNameLabel().setBackground(this.layoutList.getBackground());
            service.getNameLabel().forceFocus();
            this.layoutList.redraw();
            return;
        }
        this.addButton.setEnabled(this.selectedServices.size() > 0);
        this.clearButton.setEnabled(this.selectedServices.size() > 0);
        service.getDescLabel().setBackground(this.selFillColor);
        service.getImageLabel().setBackground(this.selFillColor);
        service.getNameLabel().setBackground(this.selFillColor);
        if (LABEL_FOCUS_SUPPORTED) {
            service.getNameLabel().forceFocus();
        } else {
            this.filterText.forceFocus();
        }
        this.setCurrFocus((Widget)service.getNameLabel());
        this.layoutList.redraw();
        if (service.getAppxLocation() != null && scrollTo) {
            List<AvailableService> visibleServices = CloudFoundryServiceWizardPageLeftPanel.utilGetVisibleServices(this.availableServices);
            boolean isFirstOrLast = false;
            Point origin = this.scrollComp.getOrigin();
            Rectangle bounds = service.getAppxLocation();
            Rectangle area = this.scrollComp.getClientArea();
            if (visibleServices.size() > 0) {
                if (service.getListPosition() == visibleServices.get(0).getListPosition()) {
                    origin.x = 0;
                    origin.y = 0;
                    isFirstOrLast = true;
                } else if (service.getListPosition() == visibleServices.get(visibleServices.size() - 1).getListPosition()) {
                    origin.x = 0;
                    origin.y = service.getAppxLocation().y + service.getAppxLocation().height;
                    isFirstOrLast = true;
                }
            }
            if (!isFirstOrLast) {
                if (origin.y > bounds.y) {
                    origin.y = Math.max(0, bounds.y);
                }
                if (origin.y + area.height < bounds.y + bounds.height) {
                    origin.y = Math.max(0, bounds.y + bounds.height - area.height);
                }
            }
            this.scrollComp.setOrigin(origin);
        }
    }

    private static AvailableService utilGetNextVisibleService(List<AvailableService> services, int startPos) {
        AvailableService firstVisible = null;
        int x = startPos;
        while (x < services.size() && x >= 0) {
            AvailableService as = services.get(x);
            if (as.getNameLabel() != null && as.getNameLabel().isVisible()) {
                firstVisible = as;
                break;
            }
            ++x;
        }
        return firstVisible;
    }

    private static AvailableService utilGetPreviousVisibleService(List<AvailableService> services, int startPos) {
        AvailableService prevVisible = null;
        int x = startPos;
        while (x >= 0 && x < services.size()) {
            AvailableService as = services.get(x);
            if (as.getNameLabel() != null && as.getNameLabel().isVisible()) {
                prevVisible = as;
                break;
            }
            --x;
        }
        return prevVisible;
    }

    private void setCurrFocus(Widget o) {
        this.currFocus = o;
    }

    private Widget getCurrFocus() {
        return this.currFocus;
    }

    private class CFAvailableServiceListener
    extends MouseAdapter
    implements SelectionListener {
        AvailableService service;

        public CFAvailableServiceListener(AvailableService item) {
            this.service = item;
        }

        public void widgetSelected(SelectionEvent e) {
            boolean isMultiSelect = (e.stateMask & 0x40000) != 0;
            CloudFoundryServiceWizardPageLeftPanel.this.selectService(this.service, true, !isMultiSelect);
        }

        public void mouseDoubleClick(MouseEvent e) {
            boolean isMultiSelect;
            boolean bl = isMultiSelect = (e.stateMask & 0x40000) != 0;
            if (!isMultiSelect) {
                CloudFoundryServiceWizardPageLeftPanel.this.createNewServiceInstances(new AvailableService[]{this.service});
            }
        }

        public void mouseUp(MouseEvent e) {
            boolean isMultiSelect = (e.stateMask & 0x40000) != 0;
            CloudFoundryServiceWizardPageLeftPanel.this.selectService(this.service, true, !isMultiSelect);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    private class ServiceListTraverseListener
    implements TraverseListener {
        private ServiceListTraverseListener() {
        }

        public void keyTraversed(TraverseEvent e) {
            AvailableService service;
            Widget focus = CloudFoundryServiceWizardPageLeftPanel.this.getCurrFocus();
            if (e.detail == 4 && !LABEL_FOCUS_SUPPORTED) {
                e.doit = false;
                CloudFoundryServiceWizardPageLeftPanel.this.handleServiceKeyEvent((KeyEvent)e);
                return;
            }
            if (e.detail == 8) {
                if (focus == CloudFoundryServiceWizardPageLeftPanel.this.filterText) {
                    e.doit = true;
                } else {
                    CloudFoundryServiceWizardPageLeftPanel.this.filterText.forceFocus();
                    CloudFoundryServiceWizardPageLeftPanel.this.setCurrFocus((Widget)CloudFoundryServiceWizardPageLeftPanel.this.filterText);
                    e.doit = false;
                }
                return;
            }
            if (e.detail == 2) {
                e.doit = true;
                return;
            }
            if (e.detail == 4) {
                e.doit = false;
                return;
            }
            if (e.detail == 64 || e.detail == 32) {
                e.doit = false;
                if (focus != null && focus instanceof Label && focus != null && ((Label)focus).getData() instanceof AvailableService) {
                    Label source = (Label)focus;
                    service = (AvailableService)source.getData();
                    AvailableService visibleServiceAbove = CloudFoundryServiceWizardPageLeftPanel.utilGetPreviousVisibleService(CloudFoundryServiceWizardPageLeftPanel.this.availableServices, service.getListPosition() - 1);
                    AvailableService visibleServiceBelow = CloudFoundryServiceWizardPageLeftPanel.utilGetNextVisibleService(CloudFoundryServiceWizardPageLeftPanel.this.availableServices, service.getListPosition() + 1);
                    if (visibleServiceAbove == null && e.detail == 32 || visibleServiceBelow == null && e.detail == 64) {
                        return;
                    }
                }
            }
            if (focus != null && focus == CloudFoundryServiceWizardPageLeftPanel.this.filterText) {
                if (CloudFoundryServiceWizardPageLeftPanel.this.getNumberOfVisibleServices() == 0) {
                    e.doit = true;
                    return;
                }
                if (e.detail == 8) {
                    e.doit = true;
                    return;
                }
                AvailableService firstVisible = null;
                for (AvailableService as : CloudFoundryServiceWizardPageLeftPanel.this.availableServices) {
                    if (as.getNameLabel() == null || !as.getNameLabel().isVisible()) continue;
                    firstVisible = as;
                    break;
                }
                if (CloudFoundryServiceWizardPageLeftPanel.this.selectedServices.size() == 0) {
                    if (firstVisible != null) {
                        CloudFoundryServiceWizardPageLeftPanel.this.selectService(firstVisible, true, true);
                    }
                } else {
                    if (firstVisible != null) {
                        firstVisible.getNameLabel().forceFocus();
                        CloudFoundryServiceWizardPageLeftPanel.this.selectService(firstVisible, true, true);
                    }
                    e.doit = false;
                }
                return;
            }
            if (focus == null || !(focus instanceof Label) || !(((Label)focus).getData() instanceof AvailableService)) {
                return;
            }
            AvailableService selectedService = (AvailableService)((Label)focus).getData();
            if (e.detail == 64 || e.detail == 32) {
                service = null;
                int servicePos = -1;
                int x = 0;
                while (x < CloudFoundryServiceWizardPageLeftPanel.this.availableServices.size()) {
                    if (selectedService == CloudFoundryServiceWizardPageLeftPanel.this.availableServices.get(x)) {
                        servicePos = x;
                        break;
                    }
                    ++x;
                }
                if (servicePos != -1) {
                    if (e.detail == 64) {
                        service = CloudFoundryServiceWizardPageLeftPanel.utilGetNextVisibleService(CloudFoundryServiceWizardPageLeftPanel.this.availableServices, servicePos + 1);
                    } else if (e.detail == 32) {
                        service = CloudFoundryServiceWizardPageLeftPanel.utilGetPreviousVisibleService(CloudFoundryServiceWizardPageLeftPanel.this.availableServices, servicePos - 1);
                    }
                }
                if (service != null) {
                    CloudFoundryServiceWizardPageLeftPanel.this.selectService(service, true, true);
                }
            } else {
                e.doit = false;
                if (e.detail == 16) {
                    CloudFoundryServiceWizardPageLeftPanel.this.clearButton.setFocus();
                } else if (e.detail == 8) {
                    CloudFoundryServiceWizardPageLeftPanel.this.filterText.setFocus();
                }
            }
        }
    }
}

