/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.cft.server.core.ApplicationDeploymentInfo;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.cft.server.core.internal.client.DeploymentInfoWorkingCopy;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.cft.server.ui.internal.wizards.CloudFoundryApplicationEnvVarWizardPage;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class EnvVarsWizard
extends Wizard {
    private final CloudFoundryServer cloudServer;
    private final CloudFoundryApplicationModule appModule;
    private DeploymentInfoWorkingCopy infoWorkingCopy;
    private CloudFoundryApplicationEnvVarWizardPage envVarPage;

    public EnvVarsWizard(CloudFoundryServer server, CloudFoundryApplicationModule appModule, DeploymentInfoWorkingCopy workingCopy) {
        Assert.isNotNull((Object)server);
        Assert.isNotNull((Object)appModule);
        Assert.isNotNull((Object)workingCopy);
        this.infoWorkingCopy = workingCopy;
        this.cloudServer = server;
        this.setWindowTitle(server.getServer().getName());
        this.setNeedsProgressMonitor(true);
        this.appModule = appModule;
    }

    public void addPages() {
        this.envVarPage = new CloudFoundryApplicationEnvVarWizardPage(this.cloudServer, (ApplicationDeploymentInfo)this.infoWorkingCopy);
        this.envVarPage.setWizard((IWizard)this);
        this.addPage((IWizardPage)this.envVarPage);
    }

    public boolean performFinish() {
        this.infoWorkingCopy.save();
        final IStatus[] result = new IStatus[1];
        try {
            this.envVarPage.setMessage(Messages.EnvVarsWizard_TEXT_ENV_VAR);
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    try {
                        EnvVarsWizard.this.cloudServer.getBehaviour().operations().environmentVariablesUpdate(EnvVarsWizard.this.appModule.getLocalModule(), EnvVarsWizard.this.appModule.getDeployedApplicationName(), EnvVarsWizard.this.infoWorkingCopy.getEnvVariables()).run(monitor);
                    }
                    catch (CoreException e) {
                        result[0] = e.getStatus();
                    }
                }
            });
            this.envVarPage.setMessage(null);
        }
        catch (InvocationTargetException e) {
            result[0] = CloudFoundryPlugin.getErrorStatus((Throwable)e);
        }
        catch (InterruptedException e) {
            result[0] = CloudFoundryPlugin.getErrorStatus((Throwable)e);
        }
        if (result[0] != null && !result[0].isOK()) {
            this.envVarPage.setErrorMessage(String.valueOf(Messages.EnvVarsWizard_ERROR_ENV_VAR) + result[0].getMessage());
            return false;
        }
        return true;
    }
}

