/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.enablement.oda.xml.util.ISaxParserConsumer;
import org.eclipse.datatools.enablement.oda.xml.util.IXMLSource;
import org.eclipse.datatools.enablement.oda.xml.util.MappingPathElementTree;
import org.eclipse.datatools.enablement.oda.xml.util.RelationInformation;
import org.eclipse.datatools.enablement.oda.xml.util.SaxParser;
import org.eclipse.datatools.enablement.oda.xml.util.SaxParserConsumer;
import org.eclipse.datatools.enablement.oda.xml.util.SaxParserUtil;
import org.eclipse.datatools.enablement.oda.xml.util.XMLPath;

public class SaxParserNestedQueryHelper
implements ISaxParserConsumer {
    private String tableName;
    private RelationInformation relationInfo;
    private SaxParser sp;
    private Thread spThread;
    Map indexPathValuesMap = new HashMap();
    private SaxParserConsumer consumer;
    private MappingPathElementTree mappingPathElementTree;

    @Override
    public void finish() {
    }

    protected SaxParserNestedQueryHelper(SaxParserConsumer consumer, RelationInformation rinfo, IXMLSource xmlSource, String tName) throws OdaException {
        this.tableName = tName;
        this.relationInfo = rinfo;
        this.consumer = consumer;
        this.mappingPathElementTree = this.relationInfo.getTableMappingPathElementTree(this.tableName);
        this.sp = new SaxParser(xmlSource, this, rinfo.containsNamespace());
        this.spThread = new Thread(this.sp);
        this.spThread.start();
        try {
            this.spThread.join();
        }
        catch (InterruptedException e) {
            throw new OdaException((Throwable)e);
        }
    }

    @Override
    public void manipulateData(XMLPath path, String value) {
        if (this.mappingPathElementTree != null) {
            int[] indexes = this.mappingPathElementTree.getMatchedColumnIndexs(path);
            int i = 0;
            while (i < indexes.length) {
                if (this.mappingPathElementTree.isNestedColumn(indexes[i])) {
                    this.addPathValue(indexes[i], path, value);
                }
                ++i;
            }
        }
    }

    public String getNestedColumnValue(XMLPath tablePath, int index, HashMap filters) {
        if (this.mappingPathElementTree != null) {
            Set pathValues = (Set)this.indexPathValuesMap.get(index);
            if (pathValues == null) {
                return null;
            }
            for (NestedColumnPathValue pathValue : pathValues) {
                if (!this.mappingPathElementTree.isValidNestedColumn(index, tablePath, pathValue.getPath())) continue;
                boolean matchFilters = true;
                if (filters != null) {
                    Iterator it = filters.keySet().iterator();
                    while (matchFilters && it.hasNext()) {
                        matchFilters = false;
                        Object filterColumnName = it.next();
                        Object value = filters.get(filterColumnName);
                        int filterColumnIndex = this.consumer.getColumnIndex(filterColumnName.toString());
                        Set filterPathValues = (Set)this.indexPathValuesMap.get(filterColumnIndex);
                        if (filterPathValues == null) continue;
                        for (NestedColumnPathValue filterPathValue : filterPathValues) {
                            if (!filterPathValue.getPath().getPathString().startsWith(pathValue.getPath().getPathString()) || !SaxParserUtil.isTwoValueMatch(filterPathValue.getValue(), value)) continue;
                            matchFilters = true;
                        }
                    }
                }
                if (!matchFilters) continue;
                return pathValue.getValue();
            }
        }
        return null;
    }

    private void addPathValue(int index, XMLPath path, String value) {
        NestedColumnPathValue pathValue = new NestedColumnPathValue(path, value);
        TreeSet<NestedColumnPathValue> pathValues = (TreeSet<NestedColumnPathValue>)this.indexPathValuesMap.get(index);
        if (pathValues == null) {
            pathValues = new TreeSet<NestedColumnPathValue>();
            this.indexPathValuesMap.put(index, pathValues);
        }
        pathValues.add(pathValue);
    }

    @Override
    public void endElement(XMLPath path) {
    }

    @Override
    public void startElement(XMLPath path) {
    }

    private static class NestedColumnPathValue
    implements Comparable {
        XMLPath path;
        String value;

        public NestedColumnPathValue(XMLPath path, String value) {
            this.path = path;
            this.value = value;
        }

        protected XMLPath getPath() {
            return this.path;
        }

        protected String getValue() {
            return this.value;
        }

        public int compareTo(Object o) {
            NestedColumnPathValue other = (NestedColumnPathValue)o;
            return this.path.getPathString().compareTo(other.path.getPathString());
        }
    }
}

