/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.editor.core.connection;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.datatools.connectivity.ConnectEvent;
import org.eclipse.datatools.sqltools.editor.core.connection.ISQLToolsConnectListener;

public class SQLToolsConnectListenersManager {
    private static SQLToolsConnectListenersManager _manager;
    private ListenerList _listeners = new ListenerList();

    private SQLToolsConnectListenersManager() {
    }

    public static synchronized SQLToolsConnectListenersManager getInstance() {
        if (_manager == null) {
            _manager = new SQLToolsConnectListenersManager();
        }
        return _manager;
    }

    public void addConnectListener(ISQLToolsConnectListener listener) {
        if (listener == null) {
            return;
        }
        this._listeners.add((Object)listener);
    }

    public void removeConnectListener(ISQLToolsConnectListener listener) {
        if (listener == null) {
            return;
        }
        this._listeners.remove((Object)listener);
    }

    public boolean fireOkToClose(ConnectEvent event) {
        boolean okToClose = true;
        Object[] listeners = this._listeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            try {
                okToClose = ((ISQLToolsConnectListener)listeners[i]).okToClose(event);
            }
            catch (Exception exception) {}
            if (!okToClose) {
                return okToClose;
            }
            ++i;
        }
        return okToClose;
    }

    public void fireAboutToClose(ConnectEvent event) throws CoreException {
        Object[] listeners = this._listeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            try {
                ((ISQLToolsConnectListener)listeners[i]).aboutToClose(event);
            }
            catch (Exception exception) {}
            ++i;
        }
    }

    public void fireProfileConnected(ConnectEvent event) throws CoreException {
        Object[] listeners = this._listeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            try {
                ((ISQLToolsConnectListener)listeners[i]).profileConnected(event);
            }
            catch (Exception exception) {}
            ++i;
        }
    }

    public void fireCloseConnection(ConnectEvent event) throws CoreException {
        Object[] listeners = this._listeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            try {
                ((ISQLToolsConnectListener)listeners[i]).closeConnection(event);
            }
            catch (Exception exception) {}
            ++i;
        }
    }
}

