/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.core.parser.processors.tcl;

import java.util.List;
import org.eclipse.dltk.ast.ASTListNode;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.statements.Block;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.compiler.problem.ProblemSeverities;
import org.eclipse.dltk.tcl.ast.TclStatement;
import org.eclipse.dltk.tcl.ast.expressions.TclBlockExpression;
import org.eclipse.dltk.tcl.ast.expressions.TclExecuteExpression;
import org.eclipse.dltk.tcl.core.AbstractTclCommandProcessor;
import org.eclipse.dltk.tcl.core.ITclParser;
import org.eclipse.dltk.tcl.core.ast.IfStatement;
import org.eclipse.dltk.tcl.core.ast.TclAdvancedExecuteExpression;
import org.eclipse.dltk.tcl.internal.core.parser.processors.tcl.Messages;

public class TclIfProcessor
extends AbstractTclCommandProcessor {
    private static final String THEN = "then";
    private static final String ELSE = "else";
    private static final String ELSEIF = "elseif";

    @Override
    public ASTNode process(TclStatement statement, ITclParser parser, ASTNode parent) {
        IfContext context = new IfContext(parser, statement);
        IfStatement ifStatement = new IfStatement(context.start(), context.end());
        this.addToParent(parent, (ASTNode)ifStatement);
        try {
            this.parseIf(context, ifStatement);
            if (!context.isEOF()) {
                ASTNode extraBegin = context.get(context.index);
                ASTNode extraEnd = context.get(context.size() - 1);
                this.report(parser, Messages.TclIfProcessor_unexpectedStatements, extraBegin.sourceStart(), extraEnd.sourceEnd(), ProblemSeverities.Error);
            }
        }
        catch (IfStatementError e) {
            this.report(parser, e.getMessage(), e.start, e.end, ProblemSeverities.Error);
        }
        return ifStatement;
    }

    private void parseIf(IfContext context, IfStatement ifStatement) throws IfStatementError {
        ifStatement.acceptCondition(this.parseCondition(context));
        if (context.isEOF()) {
            throw new IfStatementError(Messages.TclIfProcessor_missingThenBlock, context.start(), context.end());
        }
        if (this.checkKeyword(context, THEN) && context.isEOF()) {
            throw new IfStatementError(Messages.TclIfProcessor_missingThenBlock, context.start(), context.end());
        }
        ifStatement.acceptThen(this.parseBranch(context, true, Messages.TclIfProcessor_incorrectThenBlock));
        if (!context.isEOF()) {
            if (this.checkKeyword(context, ELSEIF)) {
                ASTNode elseIfKeyword = context.get(context.index - 1);
                IfStatement nestedIf = new IfStatement(elseIfKeyword.sourceStart(), context.end());
                this.parseIf(context, nestedIf);
                ifStatement.acceptElse((ASTNode)nestedIf);
            } else {
                if (this.checkKeyword(context, ELSE) && context.isEOF()) {
                    throw new IfStatementError(Messages.TclIfProcessor_incorrectElse, context.start(), context.end());
                }
                ifStatement.acceptElse((ASTNode)this.parseBranch(context, false, Messages.TclIfProcessor_incorrectElseBlock));
            }
        }
    }

    private Statement parseBranch(IfContext context, boolean wrapAsBlock, String message) throws IfStatementError {
        ASTNode node = context.get();
        if (node instanceof TclBlockExpression) {
            Block block = new Block(node.sourceStart(), node.sourceEnd());
            this.parseBlock(context.parser, block, (TclBlockExpression)node);
            return block;
        }
        if (node instanceof SimpleReference) {
            Block block = new Block(node.sourceStart(), node.sourceEnd());
            block.addStatement(node);
            return block;
        }
        if (node instanceof TclStatement) {
            if (wrapAsBlock) {
                Block block = new Block(node.sourceStart(), node.sourceEnd());
                block.addStatement(node);
                return block;
            }
            return (TclStatement)node;
        }
        if (node instanceof TclExecuteExpression) {
            if (wrapAsBlock) {
                Block block = new Block(node.sourceStart(), node.sourceEnd());
                block.addStatement(node);
                return block;
            }
            return (TclExecuteExpression)node;
        }
        if (node instanceof Block) {
            return (Block)node;
        }
        throw new IfStatementError(message, context.start(), context.end());
    }

    private boolean checkKeyword(IfContext context, String keyword) {
        SimpleReference ref;
        ASTNode node = context.get(context.index);
        if (node instanceof SimpleReference && keyword.equals((ref = (SimpleReference)node).getName())) {
            ++context.index;
            return true;
        }
        return false;
    }

    private void parseBlock(ITclParser parser, Block el, TclBlockExpression block) {
        String blockContent = block.getBlock();
        blockContent = blockContent.substring(1, blockContent.length() - 1);
        parser.parse(blockContent, block.sourceStart() + 1 - parser.getStartPos(), (ASTNode)el);
    }

    private ASTNode parseCondition(IfContext context) throws IfStatementError {
        if (context.isEOF()) {
            throw new IfStatementError(Messages.TclIfProcessor_missingCondition, context.start(), context.end());
        }
        ASTNode node = context.get();
        if (node instanceof TclBlockExpression) {
            TclBlockExpression bl = (TclBlockExpression)node;
            List parseBlock = bl.parseBlockSimple(false);
            ASTListNode list = new ASTListNode(bl.sourceStart() + 1, bl.sourceEnd() - 1);
            int j = 0;
            while (j < parseBlock.size()) {
                Object st = parseBlock.get(j);
                if (st instanceof TclStatement) {
                    List<ASTNode> expressions = ((TclStatement)((Object)st)).getExpressions();
                    int k = 0;
                    while (k < expressions.size()) {
                        ASTNode expr = expressions.get(k);
                        list.addNode(expr);
                        ++k;
                    }
                }
                ++j;
            }
            return list;
        }
        if (node instanceof SimpleReference) {
            return node;
        }
        if (node instanceof TclAdvancedExecuteExpression) {
            TclAdvancedExecuteExpression ex = (TclAdvancedExecuteExpression)node;
            List childs = ex.getChilds();
            return new ASTListNode(node.sourceStart(), node.sourceEnd(), childs);
        }
        if (node instanceof TclExecuteExpression) {
            return node;
        }
        if (node instanceof Block) {
            return node;
        }
        throw new IfStatementError(Messages.TclIfProcessor_incorrectCondition, node);
    }

    private static class IfContext {
        final ITclParser parser;
        final TclStatement statement;
        final List exprs;
        int index;

        public IfContext(ITclParser parser, TclStatement statement) {
            this.parser = parser;
            this.statement = statement;
            this.exprs = statement.getExpressions();
            this.index = 1;
        }

        public int start() {
            return this.statement.sourceStart();
        }

        public int end() {
            return this.statement.sourceEnd();
        }

        public int size() {
            return this.exprs.size();
        }

        public ASTNode get(int i) {
            return (ASTNode)this.exprs.get(i);
        }

        public ASTNode get() {
            return this.get(this.index++);
        }

        boolean isEOF() {
            return this.index >= this.exprs.size();
        }
    }

    private static class IfStatementError
    extends Exception {
        final int start;
        final int end;

        public IfStatementError(String message, ASTNode node) {
            this(message, node.sourceStart(), node.sourceEnd());
        }

        public IfStatementError(String message, int start, int end) {
            super(message);
            this.start = start;
            this.end = end;
        }
    }
}

